/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.LibraryEngine;

public class ExtensionResolver {
    private final String subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle bundle;
    private final LibraryEngine libraryEngine;

    public ExtensionResolver(String subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
    }

    public <E extends IBaseExtension> void resolveExtensions(List<E> extensions, String defaultLibraryUrl) {
        for (IBaseExtension extension : extensions) {
            IBaseDatatype result;
            IBaseDatatype expression;
            List expressionExtensions;
            List valueExtensions;
            IBaseDatatype value;
            List nestedExtensions = extension.getExtension();
            if (nestedExtensions != null && !nestedExtensions.isEmpty()) {
                this.resolveExtensions(nestedExtensions, defaultLibraryUrl);
            }
            if (!((value = extension.getValue()) instanceof IBaseHasExtensions) || (valueExtensions = ((IBaseHasExtensions)value).getExtension()) == null || (expressionExtensions = valueExtensions.stream().filter(e -> e.getUrl() != null && e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-expression")).collect(Collectors.toList())) == null || expressionExtensions.isEmpty() || (expression = ((IBaseExtension)expressionExtensions.get(0)).getValue()) == null || (result = this.getExpressionResult(expression, defaultLibraryUrl, null)) == null) continue;
            extension.setValue(result);
        }
    }

    protected IBaseDatatype getExpressionResult(IBaseDatatype expression, String defaultLibraryUrl, IBaseDatatype altExpression) {
        List<IBase> result = null;
        if (expression instanceof Expression) {
            result = this.libraryEngine.resolveExpression(this.subjectId, new CqfExpression((Expression)expression, defaultLibraryUrl, (Expression)altExpression), this.parameters, this.bundle);
        }
        if (expression instanceof org.hl7.fhir.r5.model.Expression) {
            result = this.libraryEngine.resolveExpression(this.subjectId, new CqfExpression((org.hl7.fhir.r5.model.Expression)expression, defaultLibraryUrl, (org.hl7.fhir.r5.model.Expression)altExpression), this.parameters, this.bundle);
        }
        return result != null && !result.isEmpty() ? (IBaseDatatype)result.get(0) : null;
    }
}

