/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.DateParam;
import ca.uhn.fhir.rest.param.InternalCodingDt;
import ca.uhn.fhir.rest.param.ParamPrefixEnum;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.TokenParamModifier;
import ca.uhn.fhir.util.ExtensionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.opencds.cqf.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.cql.engine.utility.CodeExtractor;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRetrieveProvider
implements RetrieveProvider {
    private static final Logger logger = LoggerFactory.getLogger(BaseRetrieveProvider.class);
    private final CodeExtractor codeUtil;
    private final IFhirPath fhirPath;
    private final RetrieveSettings retrieveSettings;
    private final TerminologyProvider terminologyProvider;
    private final SearchParameterResolver resolver;

    protected BaseRetrieveProvider(FhirContext fhirContext, TerminologyProvider terminologyProvider, RetrieveSettings retrieveSettings) {
        Objects.requireNonNull(fhirContext, "fhirContext can not be null.");
        this.retrieveSettings = Objects.requireNonNull(retrieveSettings, "retrieveSettings can not be null");
        this.terminologyProvider = Objects.requireNonNull(terminologyProvider, "terminologyProvider can not be null");
        this.codeUtil = new CodeExtractor(fhirContext);
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)fhirContext);
        this.resolver = new SearchParameterResolver(fhirContext);
    }

    public Predicate<IBaseResource> filterByTemplateId(String dataType, String templateId) {
        if (this.getRetrieveSettings().getProfileMode() == RetrieveSettings.PROFILE_MODE.OFF) {
            return resource -> true;
        }
        if (templateId == null || templateId.startsWith(String.format("http://hl7.org/fhir/StructureDefinition/%s", dataType))) {
            logger.debug("No profile-specific template id specified. Returning unfiltered resources.");
            return resource -> true;
        }
        return res -> {
            if (res.getMeta() != null && res.getMeta().getProfile() != null) {
                for (IPrimitiveType profile : res.getMeta().getProfile()) {
                    if (!profile.hasValue() || !profile.getValueAsString().equals(templateId)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public Predicate<IBaseResource> filterByContext(String dataType, String context, String contextPath, Object contextValue) {
        if (context == null || contextValue == null || contextPath == null) {
            logger.debug("Unable to relate {} to {} context with contextPath: {} and contextValue: {}. Returning unfiltered resources.", new Object[]{dataType, context, contextPath, contextValue});
            return resource -> true;
        }
        return res -> {
            Optional resContextValue = this.fhirPath.evaluateFirst((IBase)res, contextPath, IBase.class);
            if (resContextValue.isPresent() && resContextValue.get() instanceof IIdType) {
                String id = ((IIdType)resContextValue.get()).getIdPart();
                if (id == null) {
                    logger.debug("Found null id for {} resource. Skipping.", (Object)dataType);
                    return false;
                }
                if (id.startsWith("urn:")) {
                    logger.debug("Found {} with urn: prefix. Stripping.", (Object)dataType);
                    id = this.stripUrnScheme(id);
                }
                if (!id.equals(contextValue)) {
                    logger.debug("Found {} with id {}. Skipping.", (Object)dataType, (Object)id);
                    return false;
                }
            } else if (resContextValue.isPresent() && resContextValue.get() instanceof IBaseReference) {
                String reference = ((IBaseReference)resContextValue.get()).getReferenceElement().getValue();
                if (reference == null) {
                    logger.debug("Found null reference for {} resource. Skipping.", (Object)dataType);
                    return false;
                }
                if (reference.startsWith("urn:")) {
                    logger.debug("Found reference on {} resource with urn: prefix. Stripping.", (Object)dataType);
                    reference = this.stripUrnScheme(reference);
                }
                if (reference.contains("/")) {
                    reference = reference.split("/")[1];
                }
                if (!reference.equals(contextValue)) {
                    logger.debug("Found {} with reference {}. Skipping.", (Object)dataType, (Object)reference);
                    return false;
                }
            } else {
                Optional reference = this.fhirPath.evaluateFirst((IBase)res, "reference", IBase.class);
                if (!reference.isPresent()) {
                    logger.debug("Found {} resource unrelated to context. Skipping.", (Object)dataType);
                    return false;
                }
                String referenceString = ((IPrimitiveType)reference.get()).getValueAsString();
                if (referenceString.startsWith("urn:")) {
                    logger.debug("Found reference on {} resource with urn: prefix. Stripping.", (Object)dataType);
                    referenceString = this.stripUrnScheme(referenceString);
                }
                if (referenceString.contains("/")) {
                    referenceString = referenceString.substring(referenceString.indexOf("/") + 1);
                }
                if (!referenceString.equals(contextValue)) {
                    logger.debug("Found {} resource for context value: {} when expecting: {}. Skipping.", new Object[]{dataType, referenceString, contextValue});
                    return false;
                }
            }
            return true;
        };
    }

    public Predicate<IBaseResource> filterByTerminology(String dataType, String codePath, Iterable<Code> codes, String valueSet) {
        if (codes == null && valueSet == null) {
            return resource -> true;
        }
        if (codePath == null) {
            return resource -> true;
        }
        return res -> {
            List<Code> resourceCodes;
            List values = this.fhirPath.evaluate((IBase)res, codePath, IBase.class);
            if (values != null && values.size() == 1) {
                String codeValueSet;
                if (values.get(0) instanceof IPrimitiveType) {
                    return this.isPrimitiveMatch(dataType, (IPrimitiveType)values.get(0), codes);
                }
                if (((IBase)values.get(0)).fhirType().equals("CodeableConcept") && (codeValueSet = this.getValueSetFromCode((IBase)values.get(0))) != null) {
                    return codeValueSet.equals(valueSet);
                }
            }
            return this.anyCodeMatch(resourceCodes = this.codeUtil.getElmCodesFromObject(values), codes) || this.anyCodeInValueSet(resourceCodes, valueSet);
        };
    }

    private String stripUrnScheme(String uri) {
        if (uri.startsWith("urn:uuid:")) {
            return uri.substring(9);
        }
        if (uri.startsWith("urn:oid:")) {
            return uri.substring(8);
        }
        return uri;
    }

    private boolean anyCodeMatch(Iterable<Code> left, Iterable<Code> right) {
        if (left == null || right == null) {
            return false;
        }
        for (Code code : left) {
            for (Code otherCode : right) {
                if (code.getCode() == null || !code.getCode().equals(otherCode.getCode()) || code.getSystem() == null || !code.getSystem().equals(otherCode.getSystem())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyCodeInValueSet(Iterable<Code> codes, String valueSet) {
        if (codes == null || valueSet == null) {
            return false;
        }
        ValueSetInfo valueSetInfo = new ValueSetInfo().withId(valueSet);
        for (Code code : codes) {
            if (!this.terminologyProvider.in(code, valueSetInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitiveMatch(String dataType, IPrimitiveType<?> code, Iterable<Code> codes) {
        if (code == null || codes == null) {
            return false;
        }
        String primitiveString = code.getValueAsString().replace(dataType + "/", "");
        for (Code c : codes) {
            String s;
            if (!(c instanceof String) || !(s = (String)c).equals(primitiveString)) continue;
            return true;
        }
        return false;
    }

    private String getValueSetFromCode(IBase base) {
        IBaseExtension ext = ExtensionUtil.getExtensionByUrl((IBase)base, (String)"http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-notDoneValueSet");
        if (ext != null && ext.getValue() != null && ext.getValue() instanceof IPrimitiveType) {
            return ((IPrimitiveType)ext.getValue()).getValueAsString();
        }
        return null;
    }

    public void populateTemplateSearchParams(Map<String, List<IQueryParameterType>> searchParams, String templateId) {
        if (this.getRetrieveSettings().getProfileMode() != RetrieveSettings.PROFILE_MODE.OFF && StringUtils.isNotBlank((CharSequence)templateId)) {
            searchParams.put("_profile", Collections.singletonList(new ReferenceParam(templateId)));
        }
    }

    public void populateContextSearchParams(Map<String, List<IQueryParameterType>> searchParams, String dataType, String context, String contextPath, Object contextValue) {
        if (contextPath == null || contextPath.isEmpty() || contextValue == null) {
            return;
        }
        IdDt ref = StringUtils.isNotBlank((CharSequence)context) ? new IdDt((String)contextValue).withResourceType(context) : new IdDt((String)contextValue);
        RuntimeSearchParam sp = this.resolver.getSearchParameterDefinition(dataType, contextPath);
        if (sp.getName().equals("_id")) {
            searchParams.put(sp.getName(), Collections.singletonList(new TokenParam((String)contextValue)));
        } else {
            searchParams.put(sp.getName(), Collections.singletonList(new ReferenceParam((IIdType)ref)));
        }
    }

    public void populateTerminologySearchParams(Map<String, List<IQueryParameterType>> searchParams, String dataType, String codePath, Iterable<Code> codes, String valueSet) {
        if (codePath == null || codePath.isEmpty()) {
            return;
        }
        RuntimeSearchParam sp = this.resolver.getSearchParameterDefinition(dataType, codePath, RestSearchParameterTypeEnum.TOKEN);
        if (codes != null) {
            ArrayList<TokenParam> codeList = new ArrayList<TokenParam>();
            for (Code code : codes) {
                if (code instanceof Code) {
                    Code c = code;
                    codeList.add(new TokenParam((BaseCodingDt)new InternalCodingDt().setSystem(c.getSystem()).setCode(c.getCode())));
                    continue;
                }
                if (code == null) continue;
                codeList.add(new TokenParam(code.toString()));
            }
            searchParams.put(sp.getName(), codeList);
        } else if (valueSet != null) {
            boolean shouldUseInCodeModifier = this.shouldUseInCodeModifier(valueSet, dataType, sp.getName());
            if (shouldUseInCodeModifier) {
                searchParams.put(sp.getName(), Collections.singletonList(new TokenParam().setModifier(TokenParamModifier.IN).setValue(valueSet)));
            } else {
                ArrayList<TokenParam> codeList = new ArrayList<TokenParam>();
                for (Code code : this.terminologyProvider.expand(new ValueSetInfo().withId(valueSet))) {
                    codeList.add(new TokenParam((BaseCodingDt)new InternalCodingDt().setSystem(code.getSystem()).setCode(code.getCode())));
                }
                searchParams.put(sp.getName(), codeList);
            }
        }
    }

    protected boolean shouldUseInCodeModifier(String valueSet, String resourceName, String searchParamName) {
        return this.retrieveSettings.getTerminologyParameterMode() == RetrieveSettings.TERMINOLOGY_FILTER_MODE.USE_VALUE_SET_URL || this.retrieveSettings.getTerminologyParameterMode() == RetrieveSettings.TERMINOLOGY_FILTER_MODE.AUTO && this.inModifierSupported(valueSet, resourceName, searchParamName);
    }

    protected boolean inModifierSupported(String valueSet, String resourceName, String searchParamName) {
        return true;
    }

    public void populateDateSearchParams(Map<String, List<IQueryParameterType>> searchParams, String dataType, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        java.util.Date end;
        java.util.Date start;
        if (datePath == null && dateHighPath == null && dateRange == null) {
            return;
        }
        if (dateRange == null) {
            throw new IllegalStateException("A date range must be provided when filtering using date parameters");
        }
        if (dateRange.getStart() instanceof DateTime) {
            start = ((DateTime)dateRange.getStart()).toJavaDate();
            end = ((DateTime)dateRange.getEnd()).toJavaDate();
        } else if (dateRange.getStart() instanceof Date) {
            start = ((Date)dateRange.getStart()).toJavaDate();
            end = ((Date)dateRange.getEnd()).toJavaDate();
        } else {
            throw new UnsupportedOperationException("Expected Interval of type org.opencds.cqf.cql.engine.runtime.Date or org.opencds.cqf.cql.engine.runtime.DateTime, found " + dateRange.getStart().getClass().getSimpleName());
        }
        if (StringUtils.isNotBlank((CharSequence)datePath)) {
            ArrayList<DateParam> dateRangeParam = new ArrayList<DateParam>();
            DateParam dateParam = new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, start);
            dateRangeParam.add(dateParam);
            dateParam = new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, end);
            dateRangeParam.add(dateParam);
            RuntimeSearchParam sp = this.resolver.getSearchParameterDefinition(dataType, datePath);
            searchParams.put(sp.getName(), dateRangeParam);
        } else if (StringUtils.isNotBlank((CharSequence)dateLowPath)) {
            ArrayList<DateParam> dateRangeParam = new ArrayList<DateParam>();
            DateParam dateParam = new DateParam(ParamPrefixEnum.GREATERTHAN_OR_EQUALS, start);
            dateRangeParam.add(dateParam);
            RuntimeSearchParam sp = this.resolver.getSearchParameterDefinition(dataType, dateLowPath);
            searchParams.put(sp.getName(), dateRangeParam);
        } else if (StringUtils.isNotBlank((CharSequence)dateHighPath)) {
            ArrayList<DateParam> dateRangeParam = new ArrayList<DateParam>();
            DateParam dateParam = new DateParam(ParamPrefixEnum.LESSTHAN_OR_EQUALS, end);
            dateRangeParam.add(dateParam);
            RuntimeSearchParam sp = this.resolver.getSearchParameterDefinition(dataType, dateHighPath);
            searchParams.put(sp.getName(), dateRangeParam);
        } else {
            throw new IllegalStateException("A date path must be provided when filtering using date parameters");
        }
    }

    protected CodeExtractor getCodeUtil() {
        return this.codeUtil;
    }

    protected IFhirPath getFhirPath() {
        return this.fhirPath;
    }

    protected TerminologyProvider getTerminologyProvider() {
        return this.terminologyProvider;
    }

    protected RetrieveSettings getRetrieveSettings() {
        return this.retrieveSettings;
    }
}

