/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.terminology;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.engine.terminology.TerminologySettings;
import org.opencds.cqf.fhir.cql.engine.utility.ValueSets;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryTerminologyProvider
implements TerminologyProvider {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryTerminologyProvider.class);
    private static final Comparator<Code> CODE_COMPARATOR = (x, y) -> x.getCode().compareTo(y.getCode());
    private final Repository repository;
    private final FhirContext fhirContext;
    private final IFhirPath fhirPath;
    private final Map<String, List<Code>> valueSetIndex;
    private final TerminologySettings terminologySettings;

    public RepositoryTerminologyProvider(Repository repository, TerminologySettings terminologySettings) {
        this(repository, new HashMap<String, List<Code>>(), terminologySettings);
    }

    public RepositoryTerminologyProvider(Repository repository, Map<String, List<Code>> valueSetIndex, TerminologySettings terminologySettings) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null.");
        this.valueSetIndex = Objects.requireNonNull(valueSetIndex, "valueSetIndex can not be null.");
        this.terminologySettings = Objects.requireNonNull(terminologySettings, "terminologySettings can not be null.");
        this.fhirContext = repository.fhirContext();
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)this.fhirContext);
    }

    public RepositoryTerminologyProvider(Repository repository) {
        this(repository, new HashMap<String, List<Code>>(), new TerminologySettings());
    }

    public boolean in(Code code, ValueSetInfo valueSet) {
        Objects.requireNonNull(code, "code can not be null when using 'expand'");
        Objects.requireNonNull(valueSet, "valueSet can not be null when using 'expand'");
        Iterable codes = this.expand(valueSet);
        Range range = this.getSearchRange(code, (List<Code>)codes);
        for (int i = range.start; i < range.end; ++i) {
            Code c = (Code)codes.get(i);
            if (!c.getSystem().equals(code.getSystem())) continue;
            return true;
        }
        return false;
    }

    public List<Code> expand(ValueSetInfo valueSet) {
        Objects.requireNonNull(valueSet, "valueSet can not be null when using 'expand'");
        String url = valueSet.getId() + (String)(valueSet.getVersion() != null ? "|" + valueSet.getVersion() : "");
        List expansion = this.valueSetIndex.computeIfAbsent(url, k -> this.tryExpand(valueSet));
        if (expansion == null) {
            throw new IllegalArgumentException(String.format("Unable to get expansion for ValueSet %s", valueSet.getId()));
        }
        return expansion;
    }

    private Class<? extends IBaseResource> classFor(String resourceType) {
        return this.fhirContext.getResourceDefinition(resourceType).getImplementingClass();
    }

    private List<Code> tryExpand(ValueSetInfo valueSet) {
        List<Code> codes = this.performExpansion(valueSet);
        Collections.sort(codes, CODE_COMPARATOR);
        return codes;
    }

    private List<Code> tryExpandOperation(IBaseResource vs, ValueSetInfo valueSet) {
        boolean useExpandOperation = this.terminologySettings.getValuesetExpansionMode() == TerminologySettings.VALUESET_EXPANSION_MODE.AUTO && this.canRepositoryExpand(valueSet) || this.terminologySettings.getValuesetExpansionMode() == TerminologySettings.VALUESET_EXPANSION_MODE.USE_EXPAND_OPERATION;
        List<Code> codes = null;
        if (useExpandOperation) {
            vs = this.repository.invoke(vs.getIdElement(), "$expand", null).getResource();
            codes = ValueSets.getCodesInExpansion(this.fhirContext, vs);
        }
        if (codes == null && this.terminologySettings.getValuesetExpansionMode() == TerminologySettings.VALUESET_EXPANSION_MODE.USE_EXPAND_OPERATION) {
            throw new IllegalArgumentException(String.format("Failed to expand ValueSet %s", valueSet.getId()));
        }
        return codes;
    }

    private List<Code> tryNaiveExpansion(IBaseResource vs, ValueSetInfo valueSet) {
        if (this.containsExpansionLogic(vs)) {
            throw new IllegalArgumentException(String.format("ValueSet %s requires $expand to support correctly, and $expand is not available", valueSet.getId()));
        }
        logger.warn("ValueSet {} is not expanded. Falling back to compose definition. This will potentially produce incorrect results. ", (Object)valueSet.getId());
        List<Code> codes = ValueSets.getCodesInCompose(this.fhirContext, vs);
        if (codes == null) {
            throw new IllegalArgumentException(String.format("Failed to expand ValueSet %s", valueSet.getId()));
        }
        return codes;
    }

    private List<Code> performExpansion(ValueSetInfo valueSet) {
        Map search = valueSet.getVersion() != null ? Searches.byUrlAndVersion((String)valueSet.getId(), (String)valueSet.getVersion()) : Searches.byUrl((String)valueSet.getId());
        IBaseBundle results = this.repository.search(this.classFor("Bundle"), this.classFor("ValueSet"), search, null);
        List resources = BundleUtil.toListOfResources((FhirContext)this.fhirContext, (IBaseBundle)results);
        if (resources.isEmpty()) {
            throw new IllegalArgumentException(String.format("Unable to locate ValueSet %s", valueSet.getId()));
        }
        if (resources.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple ValueSets resolved for %s", valueSet.getId()));
        }
        IBaseResource vs = (IBaseResource)resources.get(0);
        List<Code> codes = this.tryPreExpansion(vs, valueSet);
        if (codes != null) {
            return codes;
        }
        codes = this.tryExpandOperation(vs, valueSet);
        if (codes != null) {
            return codes;
        }
        return this.tryNaiveExpansion(vs, valueSet);
    }

    private List<Code> tryPreExpansion(IBaseResource vs, ValueSetInfo valueSet) {
        if (this.terminologySettings.getValuesetPreExpansionMode() == TerminologySettings.VALUESET_PRE_EXPANSION_MODE.IGNORE) {
            return null;
        }
        List<Code> codes = ValueSets.getCodesInExpansion(this.fhirContext, vs);
        if (codes == null && this.terminologySettings.getValuesetPreExpansionMode() == TerminologySettings.VALUESET_PRE_EXPANSION_MODE.REQUIRE) {
            throw new IllegalArgumentException(String.format("ValueSet PreExpansion mode was set to REQUIRE, and valueSet %s did not have an expansion", valueSet.getId()));
        }
        if (codes != null && Boolean.TRUE.equals(this.isNaiveExpansion(vs))) {
            logger.warn("Codes for ValueSet {} expanded without a terminology server, some results may not be correct.", (Object)valueSet.getId());
        }
        return codes;
    }

    private Range getSearchRange(Code code, List<Code> expansion) {
        int first;
        int index = Collections.binarySearch(expansion, code, CODE_COMPARATOR);
        if (index < 0) {
            return Range.EMPTY;
        }
        int last = index + 1;
        String value = code.getCode();
        for (first = index; first > 0 && expansion.get(first - 1).getCode().equals(value); --first) {
        }
        while (last < expansion.size() && expansion.get(last).getCode().equals(value)) {
            ++last;
        }
        return new Range(first, last);
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) {
        if (code.getSystem() == null) {
            return null;
        }
        if (code.getSystem().equals(codeSystem.getId()) && (code.getVersion() == null || code.getVersion().equals(codeSystem.getVersion()))) {
            logger.warn("Unvalidated CodeSystem lookup: {} in {}", (Object)code, (Object)codeSystem.getId());
            return code;
        }
        return null;
    }

    private Boolean isNaiveExpansion(IBaseResource resource) {
        IBase expansion = ValueSets.getExpansion(this.fhirContext, resource);
        if (expansion != null) {
            List<IBase> naiveParameters;
            Iterator<IBase> iterator;
            List<IBase> object = ValueSets.getExpansionParameters(expansion, this.fhirPath, ".where(name = 'naive').value");
            if (object instanceof IBase) {
                return this.resolveNaiveBoolean((IBase)object);
            }
            if (object instanceof Iterable && (iterator = (naiveParameters = object).iterator()).hasNext()) {
                IBase param = iterator.next();
                return this.resolveNaiveBoolean(param);
            }
        }
        return null;
    }

    private Boolean resolveNaiveBoolean(IBase param) {
        if (param.fhirType().equals("boolean")) {
            return (Boolean)((IPrimitiveType)param).getValue();
        }
        return null;
    }

    private boolean containsExpansionLogic(IBaseResource resource) {
        List<IBase> includeFilters = ValueSets.getIncludeFilters(this.fhirContext, resource);
        if (includeFilters != null && !includeFilters.isEmpty()) {
            return true;
        }
        List<IBase> excludeFilters = ValueSets.getExcludeFilters(this.fhirContext, resource);
        return excludeFilters != null && !excludeFilters.isEmpty();
    }

    private boolean canRepositoryExpand(ValueSetInfo valueSetInfo) {
        return true;
    }

    private static class Range {
        public static final Range EMPTY = new Range(-1, -1);
        public final int start;
        public final int end;

        public Range(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

