/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.utility;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseEnumFactory;
import org.hl7.fhir.instance.model.api.IBaseEnumeration;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.runtime.Code;

public class CodeExtractor {
    private final RuntimeCompositeDatatypeDefinition conceptDefinition;
    private final RuntimeCompositeDatatypeDefinition codingDefinition;
    private final BaseRuntimeChildDefinition conceptCodingChild;
    private final BaseRuntimeChildDefinition versionDefinition;
    private final BaseRuntimeChildDefinition codeDefinition;
    private final BaseRuntimeChildDefinition systemDefinition;
    private final BaseRuntimeChildDefinition displayDefinition;

    public CodeExtractor(FhirContext fhirContext) {
        this.conceptDefinition = (RuntimeCompositeDatatypeDefinition)fhirContext.getElementDefinition("CodeableConcept");
        this.conceptCodingChild = this.conceptDefinition.getChildByName("coding");
        this.codingDefinition = (RuntimeCompositeDatatypeDefinition)fhirContext.getElementDefinition("Coding");
        this.versionDefinition = this.codingDefinition.getChildByName("version");
        this.codeDefinition = this.codingDefinition.getChildByName("code");
        this.systemDefinition = this.codingDefinition.getChildByName("system");
        this.displayDefinition = this.codingDefinition.getChildByName("display");
    }

    public List<Code> getElmCodesFromObject(Object object) {
        ArrayList<Code> codes = new ArrayList<Code>();
        if (object instanceof Iterable) {
            for (Object innerObject : (Iterable)object) {
                List<Code> elmCodes = this.getElmCodesFromObject(innerObject);
                if (elmCodes == null) continue;
                codes.addAll(elmCodes);
            }
        } else {
            List<Code> elmCodes = this.getElmCodesFromObjectInner(object);
            if (elmCodes != null) {
                codes.addAll(elmCodes);
            }
        }
        return codes;
    }

    private List<Code> getElmCodesFromObjectInner(Object object) {
        ArrayList<Code> codes = new ArrayList<Code>();
        if (object == null) {
            return codes;
        }
        if (object instanceof IBase) {
            List<Code> innerCodes = this.getCodesFromBase((IBase)object);
            if (innerCodes != null) {
                codes.addAll(innerCodes);
            }
        } else if (object instanceof Code) {
            codes.add((Code)object);
        } else {
            throw new IllegalArgumentException(String.format("Unable to extract codes from object %s", object.toString()));
        }
        return codes;
    }

    private List<Code> getCodesFromBase(IBase object) {
        if (object instanceof IBaseEnumeration) {
            IBaseEnumeration enumeration = (IBaseEnumeration)object;
            return this.getCodeFromEnumeration(enumeration);
        }
        if (object.fhirType().equals("CodeableConcept")) {
            return this.getCodesInConcept(object);
        }
        if (object.fhirType().equals("Coding")) {
            return this.generateCodes(Collections.singletonList(object));
        }
        throw new IllegalArgumentException(String.format("Unable to extract codes from fhirType %s", object.fhirType()));
    }

    private List<Code> getCodeFromEnumeration(IBaseEnumeration<Enum<?>> enumeration) {
        ArrayList<Code> codes = new ArrayList<Code>();
        if (enumeration == null) {
            return codes;
        }
        IBaseEnumFactory enumFactory = enumeration.getEnumFactory();
        String system = enumFactory.toSystem((Enum)enumeration.getValue());
        String codeAsString = enumFactory.toCode((Enum)enumeration.getValue());
        if (system != null && !system.isEmpty() && codeAsString != null && !codeAsString.isEmpty()) {
            Code code = new Code();
            code.setCode(codeAsString);
            code.setSystem(system);
            codes.add(code);
        }
        return codes;
    }

    private List<Code> getCodesInConcept(IBase object) {
        List<IBase> codingObjects = this.getCodingObjects(object);
        if (codingObjects == null) {
            return null;
        }
        return this.generateCodes(codingObjects);
    }

    private List<Code> generateCodes(List<IBase> codingObjects) {
        ArrayList<Code> codes = new ArrayList<Code>();
        for (IBase coding : codingObjects) {
            String code = this.getStringValueFromPrimitiveDefinition(this.codeDefinition, coding);
            String display = this.getStringValueFromPrimitiveDefinition(this.displayDefinition, coding);
            String system = this.getStringValueFromPrimitiveDefinition(this.systemDefinition, coding);
            String version = this.getStringValueFromPrimitiveDefinition(this.versionDefinition, coding);
            codes.add(new Code().withSystem(system).withCode(code).withDisplay(display).withVersion(version));
        }
        return codes;
    }

    private List<IBase> getCodingObjects(IBase object) {
        List codingObject = null;
        try {
            codingObject = this.conceptCodingChild.getAccessor().getValues(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return codingObject;
    }

    private String getStringValueFromPrimitiveDefinition(BaseRuntimeChildDefinition definition, IBase value) {
        BaseRuntimeChildDefinition.IAccessor accessor = definition.getAccessor();
        if (value == null || accessor == null) {
            return null;
        }
        List values = accessor.getValues(value);
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalArgumentException("More than one value returned while attempting to access primitive value.");
        }
        IBase baseValue = (IBase)values.get(0);
        if (!(baseValue instanceof IPrimitiveType)) {
            throw new IllegalArgumentException("Non-primitive value encountered while trying to access primitive value.");
        }
        return ((IPrimitiveType)baseValue).getValueAsString();
    }
}

