/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.quick.FhirLibrarySourceProvider;
import org.cqframework.fhir.npm.ILibraryReader;
import org.cqframework.fhir.npm.LibraryLoader;
import org.cqframework.fhir.npm.NpmLibrarySourceProvider;
import org.cqframework.fhir.npm.NpmModelInfoProvider;
import org.cqframework.fhir.npm.NpmProcessor;
import org.cqframework.fhir.utilities.LoggerAdapter;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.Environment;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverterFactory;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.RetrieveProviderConfig;
import org.opencds.cqf.fhir.cql.RetrieveProviderConfigurerImpl;
import org.opencds.cqf.fhir.cql.cql2elm.content.RepositoryFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.cql.engine.retrieve.FederatedDataProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RepositoryRetrieveProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.cql.engine.terminology.RepositoryTerminologyProvider;
import org.opencds.cqf.fhir.utility.adapter.r5.AdapterFactory;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engines {
    private static Logger logger = LoggerFactory.getLogger(Engines.class);

    private Engines() {
    }

    public static CqlEngine forRepository(Repository repository) {
        return Engines.forRepository(repository, EvaluationSettings.getDefault());
    }

    public static CqlEngine forRepository(Repository repository, EvaluationSettings settings) {
        return Engines.forRepository(repository, settings, null, true);
    }

    public static CqlEngine forRepository(Repository repository, EvaluationSettings settings, NpmProcessor npmProcessor, Boolean useLibraryCache) {
        RepositoryTerminologyProvider terminologyProvider = new RepositoryTerminologyProvider(repository, settings.getValueSetCache(), settings.getExpansionMode());
        List<LibrarySourceProvider> sources = Collections.singletonList(Engines.buildLibrarySource(repository));
        Map<String, DataProvider> dataProviders = Engines.buildDataProviders(repository, null, terminologyProvider, settings.getRetrieveSettings());
        Environment environment = Engines.buildEnvironment(settings, sources, terminologyProvider, dataProviders, npmProcessor, useLibraryCache);
        return new CqlEngine(environment, settings.getCqlOptions().getCqlEngineOptions().getOptions());
    }

    public static CqlEngine forRepositoryAndSettings(EvaluationSettings settings, Repository repository, IBaseBundle additionalData) {
        return Engines.forRepositoryAndSettings(settings, repository, additionalData, null, true);
    }

    public static CqlEngine forRepositoryAndSettings(EvaluationSettings settings, Repository repository, IBaseBundle additionalData, NpmProcessor npmProcessor, Boolean useLibraryCache) {
        Preconditions.checkNotNull((Object)settings);
        Preconditions.checkNotNull((Object)repository);
        RepositoryTerminologyProvider terminologyProvider = new RepositoryTerminologyProvider(repository, settings.getValueSetCache(), settings.getExpansionMode());
        ArrayList<LibrarySourceProvider> sourceProviders = new ArrayList<LibrarySourceProvider>();
        sourceProviders.add(Engines.buildLibrarySource(repository));
        Map<String, DataProvider> dataProviders = Engines.buildDataProviders(repository, additionalData, terminologyProvider, settings.getRetrieveSettings());
        Environment environment = Engines.buildEnvironment(settings, sourceProviders, terminologyProvider, dataProviders, npmProcessor, useLibraryCache);
        return new CqlEngine(environment, settings.getCqlOptions().getCqlEngineOptions().getOptions());
    }

    private static LibrarySourceProvider buildLibrarySource(Repository repository) {
        org.opencds.cqf.fhir.utility.adapter.AdapterFactory adapterFactory = Engines.getAdapterFactory(repository.fhirContext());
        return new RepositoryFhirLibrarySourceProvider(repository, adapterFactory, new LibraryVersionSelector(adapterFactory));
    }

    private static Environment buildEnvironment(EvaluationSettings settings, List<LibrarySourceProvider> librarySourceProviders, TerminologyProvider terminologyProvider, Map<String, DataProvider> dataProviders, NpmProcessor npmProcessor, Boolean useLibraryCache) {
        ModelManager modelManager;
        if (settings.getCqlOptions().useEmbeddedLibraries()) {
            librarySourceProviders.add((LibrarySourceProvider)new FhirLibrarySourceProvider());
        }
        ModelManager modelManager2 = modelManager = settings.getModelCache() != null ? new ModelManager(settings.getModelCache()) : new ModelManager();
        if (npmProcessor != null && npmProcessor.getIgContext() != null && npmProcessor.getPackageManager() != null) {
            LibraryLoader reader = new LibraryLoader(npmProcessor.getIgContext().getFhirVersion());
            LoggerAdapter adapter = new LoggerAdapter(logger);
            librarySourceProviders.add((LibrarySourceProvider)new NpmLibrarySourceProvider(npmProcessor.getPackageManager().getNpmList(), (ILibraryReader)reader, (IWorkerContext.ILoggingService)adapter));
            modelManager.getModelInfoLoader().registerModelInfoProvider((ModelInfoProvider)new NpmModelInfoProvider(npmProcessor.getPackageManager().getNpmList(), (ILibraryReader)reader, (IWorkerContext.ILoggingService)adapter));
        }
        LibraryManager libraryManager = new LibraryManager(modelManager, settings.getCqlOptions().getCqlCompilerOptions(), Boolean.TRUE.equals(useLibraryCache) ? settings.getLibraryCache() : null);
        libraryManager.getLibrarySourceLoader().clearProviders();
        if (npmProcessor != null) {
            for (NamespaceInfo n : npmProcessor.getNamespaces()) {
                libraryManager.getNamespaceManager().addNamespace(n);
            }
        }
        librarySourceProviders.forEach(lsp -> libraryManager.getLibrarySourceLoader().registerProvider(lsp));
        if (settings.getCqlOptions().useEmbeddedLibraries()) {
            libraryManager.getLibrarySourceLoader().registerProvider((LibrarySourceProvider)new FhirLibrarySourceProvider());
        }
        return new Environment(libraryManager, dataProviders, terminologyProvider);
    }

    private static Map<String, DataProvider> buildDataProviders(Repository repository, IBaseBundle additionalData, TerminologyProvider theTerminologyProvider, RetrieveSettings retrieveSettings) {
        HashMap<String, DataProvider> dataProviders = new HashMap<String, DataProvider>();
        ArrayList<RetrieveProvider> providers = new ArrayList<RetrieveProvider>();
        ModelResolver modelResolver = FhirModelResolverCache.resolverForVersion(repository.fhirContext().getVersion().getVersion());
        RepositoryRetrieveProvider retrieveProvider = new RepositoryRetrieveProvider(repository, retrieveSettings);
        providers.add((RetrieveProvider)retrieveProvider);
        if (additionalData != null && modelResolver.resolvePath((Object)additionalData, "entry") != null) {
            InMemoryFhirRepository bundleRepo = new InMemoryFhirRepository(repository.fhirContext(), additionalData);
            providers.add((RetrieveProvider)new RepositoryRetrieveProvider((Repository)bundleRepo, retrieveSettings));
        }
        RetrieveProviderConfigurerImpl retrieveProviderConfigurer = new RetrieveProviderConfigurerImpl(RetrieveProviderConfig.defaultConfig());
        for (RetrieveProvider provider : providers) {
            retrieveProviderConfigurer.configure(provider, theTerminologyProvider);
        }
        dataProviders.put("http://hl7.org/fhir", (DataProvider)new FederatedDataProvider(modelResolver, providers));
        return dataProviders;
    }

    public static org.opencds.cqf.fhir.utility.adapter.AdapterFactory getAdapterFactory(FhirContext fhirContext) {
        switch (fhirContext.getVersion().getVersion()) {
            case DSTU3: {
                return new org.opencds.cqf.fhir.utility.adapter.dstu3.AdapterFactory();
            }
            case R4: {
                return new org.opencds.cqf.fhir.utility.adapter.r4.AdapterFactory();
            }
            case R5: {
                return new AdapterFactory();
            }
        }
        throw new IllegalArgumentException(String.format("unsupported FHIR version: %s", fhirContext));
    }

    public static CqlFhirParametersConverter getCqlFhirParametersConverter(FhirContext fhirContext) {
        FhirTypeConverter fhirTypeConverter = new FhirTypeConverterFactory().create(fhirContext.getVersion().getVersion());
        return new CqlFhirParametersConverter(fhirContext, Engines.getAdapterFactory(fhirContext), fhirTypeConverter);
    }
}

