/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.cql2elm.content;

import ca.uhn.fhir.context.FhirContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.cql2elm.content.BaseFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.opencds.cqf.fhir.utility.iterable.BundleIterable;
import org.opencds.cqf.fhir.utility.search.Searches;

public class RepositoryFhirLibrarySourceProvider
extends BaseFhirLibrarySourceProvider {
    private Repository repository;
    private FhirContext fhirContext;
    private LibraryVersionSelector libraryVersionSelector;

    public RepositoryFhirLibrarySourceProvider(Repository repository, AdapterFactory adapterFactory, LibraryVersionSelector libraryVersionSelector) {
        super(adapterFactory);
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.fhirContext = repository.fhirContext();
        this.libraryVersionSelector = Objects.requireNonNull(libraryVersionSelector, "libraryVersionSelector can not be null");
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected FhirContext getFhirContext() {
        return this.fhirContext;
    }

    @Override
    protected IBaseResource getLibrary(VersionedIdentifier libraryIdentifier) {
        Class lt;
        Class bt = this.fhirContext.getResourceDefinition("Bundle").getImplementingClass();
        IBaseBundle libs = this.repository.search(bt, lt = this.fhirContext.getResourceDefinition("Library").getImplementingClass(), Searches.byNameAndVersion((String)libraryIdentifier.getId(), (String)libraryIdentifier.getVersion()));
        Iterator iter = new BundleIterable(this.repository, libs).iterator();
        if (!iter.hasNext()) {
            return null;
        }
        ArrayList<IBaseResource> libraries = new ArrayList<IBaseResource>();
        iter.forEachRemaining(x -> libraries.add(x.getResource()));
        return this.libraryVersionSelector.select(libraryIdentifier, libraries);
    }
}

