/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Extension;
import org.opencds.cqf.cql.engine.retrieve.TerminologyAwareRetrieveProvider;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.opencds.cqf.fhir.cql.engine.utility.CodeExtractor;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleRetrieveProvider
extends TerminologyAwareRetrieveProvider {
    private static final Logger logger = LoggerFactory.getLogger(BundleRetrieveProvider.class);
    private final CodeExtractor codeUtil;
    private final IFhirPath fhirPath;
    private final Map<String, List<IBaseResource>> resourceMap = new HashMap<String, List<IBaseResource>>();

    public BundleRetrieveProvider(FhirContext fhirContext, IBaseBundle iBaseBundle) {
        Objects.requireNonNull(fhirContext, "bundle can not be null.");
        Objects.requireNonNull(iBaseBundle, "bundle can not be null.");
        this.codeUtil = new CodeExtractor(fhirContext);
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)fhirContext);
        List resources = BundleUtil.toListOfResources((FhirContext)fhirContext, (IBaseBundle)iBaseBundle);
        for (IBaseResource r : resources) {
            this.resourceMap.computeIfAbsent(r.fhirType(), k -> new ArrayList()).add(r);
        }
    }

    public Iterable<Object> retrieve(String context, String contextPath, Object contextValue, String dataType, String templateId, String codePath, Iterable<Code> codes, String valueSet, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        return this.resourceMap.computeIfAbsent(dataType, k -> Collections.emptyList()).stream().filter(this.filterByTemplateId(dataType, templateId)).filter(this.filterByContext(dataType, context, contextPath, contextValue)).filter(this.filterByTerminology(dataType, codePath, codes, valueSet)).collect(Collectors.toList());
    }

    private boolean anyCodeMatch(Iterable<Code> left, Iterable<Code> right) {
        if (left == null || right == null) {
            return false;
        }
        for (Code code : left) {
            for (Code otherCode : right) {
                if (code.getCode() == null || !code.getCode().equals(otherCode.getCode()) || code.getSystem() == null || !code.getSystem().equals(otherCode.getSystem())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean anyCodeInValueSet(Iterable<Code> codes, String valueSet) {
        if (codes == null || valueSet == null) {
            return false;
        }
        if (this.terminologyProvider == null) {
            throw new IllegalStateException(String.format("Unable to check code membership for in ValueSet %s. terminologyProvider is null.", valueSet));
        }
        ValueSetInfo valueSetInfo = new ValueSetInfo().withId(valueSet);
        for (Code code : codes) {
            if (!this.terminologyProvider.in(code, valueSetInfo)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrimitiveMatch(String dataType, IPrimitiveType<?> code, Iterable<Code> codes) {
        if (code == null || codes == null) {
            return false;
        }
        String primitiveString = code.getValueAsString().replace(dataType + "/", "");
        for (Code c : codes) {
            String s;
            if (!(c instanceof String) || !(s = (String)c).equals(primitiveString)) continue;
            return true;
        }
        return false;
    }

    private Predicate<? super IBaseResource> filterByTerminology(String dataType, String codePath, Iterable<Code> codes, String valueSet) {
        if (codes == null && valueSet == null) {
            return resource -> true;
        }
        if (codePath == null) {
            return resource -> true;
        }
        return res -> {
            List<Code> resourceCodes;
            List values = this.fhirPath.evaluate((IBase)res, codePath, IBase.class);
            if (values != null && values.size() == 1) {
                String codeValueSet;
                if (values.get(0) instanceof IPrimitiveType) {
                    return this.isPrimitiveMatch(dataType, (IPrimitiveType)values.get(0), codes);
                }
                if (((IBase)values.get(0)).fhirType().equals("CodeableConcept") && (codeValueSet = this.getValueSetFromCode((IBase)values.get(0))) != null) {
                    return valueSet != null && codeValueSet.equals(valueSet);
                }
            }
            return this.anyCodeMatch(resourceCodes = this.codeUtil.getElmCodesFromObject(values), codes) || this.anyCodeInValueSet(resourceCodes, valueSet);
        };
    }

    private Predicate<? super IBaseResource> filterByTemplateId(String dataType, String templateId) {
        if (templateId == null || templateId.startsWith(String.format("http://hl7.org/fhir/StructureDefinition/%s", dataType))) {
            logger.debug("No profile-specific template id specified. Returning unfiltered resources.");
            return resource -> true;
        }
        return res -> {
            if (res.getMeta() != null && res.getMeta().getProfile() != null) {
                for (IPrimitiveType profile : res.getMeta().getProfile()) {
                    if (!profile.hasValue() || !profile.getValueAsString().equals(templateId)) continue;
                    return true;
                }
            }
            return false;
        };
    }

    private String getValueSetFromCode(IBase base) {
        CodeableConcept cc;
        Extension e;
        if (base instanceof CodeableConcept && (e = (cc = (CodeableConcept)base).getExtensionByUrl("http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-notDoneValueSet")) != null && e.hasValue()) {
            return e.getValueAsPrimitive().getValueAsString();
        }
        return null;
    }

    private Predicate<? super IBaseResource> filterByContext(String dataType, String context, String contextPath, Object contextValue) {
        if (context == null || contextValue == null || contextPath == null) {
            logger.debug("Unable to relate {} to {} context with contextPath: {} and contextValue: {}. Returning unfiltered resources.", new Object[]{dataType, context, contextPath, contextValue});
            return resource -> true;
        }
        return res -> {
            Optional resContextValue = this.fhirPath.evaluateFirst((IBase)res, contextPath, IBase.class);
            if (resContextValue.isPresent() && resContextValue.get() instanceof IIdType) {
                String id = ((IIdType)resContextValue.get()).getIdPart();
                if (id == null) {
                    logger.debug("Found null id for {} resource. Skipping.", (Object)dataType);
                    return false;
                }
                if (id.startsWith("urn:")) {
                    logger.debug("Found {} with urn: prefix. Stripping.", (Object)dataType);
                    id = this.stripUrnScheme(id);
                }
                if (!id.equals(contextValue)) {
                    logger.debug("Found {} with id {}. Skipping.", (Object)dataType, (Object)id);
                    return false;
                }
            } else if (resContextValue.isPresent() && resContextValue.get() instanceof IBaseReference) {
                String reference = ((IBaseReference)resContextValue.get()).getReferenceElement().getValue();
                if (reference == null) {
                    logger.debug("Found null reference for {} resource. Skipping.", (Object)dataType);
                    return false;
                }
                if (reference.startsWith("urn:")) {
                    logger.debug("Found reference on {} resource with urn: prefix. Stripping.", (Object)dataType);
                    reference = this.stripUrnScheme(reference);
                }
                if (reference.contains("/")) {
                    reference = reference.split("/")[1];
                }
                if (!reference.equals(contextValue)) {
                    logger.debug("Found {} with reference {}. Skipping.", (Object)dataType, (Object)reference);
                    return false;
                }
            } else {
                Optional reference = this.fhirPath.evaluateFirst((IBase)res, "reference", IBase.class);
                if (!reference.isPresent()) {
                    logger.debug("Found {} resource unrelated to context. Skipping.", (Object)dataType);
                    return false;
                }
                String referenceString = ((IPrimitiveType)reference.get()).getValueAsString();
                if (referenceString.startsWith("urn:")) {
                    logger.debug("Found reference on {} resource with urn: prefix. Stripping.", (Object)dataType);
                    referenceString = this.stripUrnScheme(referenceString);
                }
                if (referenceString.contains("/")) {
                    referenceString = referenceString.substring(referenceString.indexOf("/") + 1, referenceString.length());
                }
                if (!referenceString.equals(contextValue)) {
                    logger.debug("Found {} resource for context value: {} when expecting: {}. Skipping.", new Object[]{dataType, referenceString, contextValue});
                    return false;
                }
            }
            return true;
        };
    }

    private String stripUrnScheme(String uri) {
        if (uri.startsWith("urn:uuid:")) {
            return uri.substring(9);
        }
        if (uri.startsWith("urn:oid:")) {
            return uri.substring(8);
        }
        return uri;
    }
}

