/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.utility.iterable.BundleIterable;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterable;
import org.opencds.cqf.fhir.utility.search.Searches;

public class RepositoryRetrieveProvider
extends RetrieveProvider {
    private final Repository repository;
    private final FhirContext fhirContext;

    public RepositoryRetrieveProvider(Repository repository, RetrieveSettings settings) {
        super(repository.fhirContext());
        this.repository = Objects.requireNonNull(repository, "repository can not be null.");
        this.fhirContext = repository.fhirContext();
        this.setSearchByTemplate(settings.getSearchByTemplate());
        this.setFilterBySearchParam(settings.getFilterBySearchParam());
    }

    public Iterable<Object> retrieve(String context, String contextPath, Object contextValue, String dataType, String templateId, String codePath, Iterable<Code> codes, String valueSet, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        Class resourceType = this.fhirContext.getResourceDefinition(dataType).getImplementingClass();
        Class bt = this.fhirContext.getResourceDefinition("Bundle").getImplementingClass();
        if (this.isFilterBySearchParam()) {
            HashMap<String, List<IQueryParameterType>> searchParams = new HashMap<String, List<IQueryParameterType>>();
            this.populateTemplateSearchParams(searchParams, templateId);
            this.populateContextSearchParams(searchParams, dataType, contextPath, context, contextValue);
            this.populateTerminologySearchParams(searchParams, dataType, codePath, codes, valueSet);
            this.populateDateSearchParams(searchParams, dataType, datePath, dateLowPath, dateHighPath, dateRange);
            IBaseBundle resources = this.repository.search(bt, resourceType, searchParams);
            return new BundleMappingIterable(this.repository, resources, p -> p.getResource());
        }
        IBaseBundle resources = this.repository.search(bt, resourceType, Searches.ALL);
        BundleIterable iter = new BundleIterable(this.repository, resources);
        return iter.toStream().map(x -> x.getResource()).filter(this.filterByTemplateId(dataType, templateId)).filter(this.filterByContext(dataType, context, contextPath, contextValue)).filter(this.filterByTerminology(dataType, codePath, codes, valueSet)).collect(Collectors.toList());
    }
}

