/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import org.opencds.cqf.cql.engine.fhir.retrieve.RestFhirRetrieveProvider;
import org.opencds.cqf.cql.engine.fhir.retrieve.SearchParamFhirRetrieveProvider;
import org.opencds.cqf.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.cql.engine.retrieve.TerminologyAwareRetrieveProvider;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.fhir.cql.RetrieveProviderConfig;
import org.opencds.cqf.fhir.cql.RetrieveProviderConfigurer;

public class RetrieveProviderConfigurerImpl
implements RetrieveProviderConfigurer {
    RetrieveProviderConfig retrieveProviderConfig;

    public RetrieveProviderConfigurerImpl(RetrieveProviderConfig dataProviderConfig) {
        this.retrieveProviderConfig = dataProviderConfig;
    }

    @Override
    public void configure(RetrieveProvider retrieveProvider, TerminologyProvider terminologyProvider) {
        if (retrieveProvider instanceof TerminologyAwareRetrieveProvider) {
            ((TerminologyAwareRetrieveProvider)retrieveProvider).setTerminologyProvider(terminologyProvider);
            ((TerminologyAwareRetrieveProvider)retrieveProvider).setExpandValueSets(this.retrieveProviderConfig.getExpandValueSets());
        }
        if (retrieveProvider instanceof SearchParamFhirRetrieveProvider) {
            ((SearchParamFhirRetrieveProvider)retrieveProvider).setMaxCodesPerQuery(this.retrieveProviderConfig.getMaxCodesPerQuery());
        }
        if (retrieveProvider instanceof RestFhirRetrieveProvider) {
            ((RestFhirRetrieveProvider)retrieveProvider).setSearchStyle(this.retrieveProviderConfig.getSearchStyle());
        }
    }
}

