/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.cql2elm.content;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IQuery;
import ca.uhn.fhir.rest.gclient.IReadExecutable;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.BundleUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.cql.cql2elm.content.BaseFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.utility.adapter.AdapterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirClientFhirLibrarySourceProvider
extends BaseFhirLibrarySourceProvider {
    Logger logger = LoggerFactory.getLogger(FhirClientFhirLibrarySourceProvider.class);
    private IGenericClient client;
    private AdapterFactory adapterFactory;
    private LibraryVersionSelector libraryVersionSelector;
    private Map<VersionedIdentifier, IBaseResource> cache;

    public FhirClientFhirLibrarySourceProvider(IGenericClient client, AdapterFactory adapterFactory, LibraryVersionSelector libraryVersionSelector) {
        super(adapterFactory);
        this.client = client;
        this.adapterFactory = adapterFactory;
        this.libraryVersionSelector = libraryVersionSelector;
        this.cache = new HashMap<VersionedIdentifier, IBaseResource>();
    }

    protected IBaseResource getLibrary(IIdType id) {
        try {
            return (IBaseResource)((IReadExecutable)((IReadExecutable)this.client.read().resource("Library").withId(id).elementsSubset(new String[]{"name", "version", "content", "type"})).encodedJson()).execute();
        }
        catch (Exception e) {
            this.logger.error(String.format("error while getting library with id %s", id), (Throwable)e);
            return null;
        }
    }

    @Override
    public IBaseResource getLibrary(VersionedIdentifier libraryIdentifier) {
        IBaseResource library = this.cache.get(libraryIdentifier);
        if (library != null) {
            return library;
        }
        IBaseBundle result = (IBaseBundle)((IQuery)((IQuery)this.client.search().forResource("Library").elementsSubset(new String[]{"name", "version"})).where(new TokenClientParam("name").exactly().code(libraryIdentifier.getId())).encodedJson()).execute();
        List resources = BundleUtil.toListOfResourcesOfType((FhirContext)this.client.getFhirContext(), (IBaseBundle)result, (Class)this.client.getFhirContext().getResourceDefinition("Library").getImplementingClass());
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        Collection libraries = resources.stream().map(x -> x).collect(Collectors.toList());
        library = this.libraryVersionSelector.select(libraryIdentifier, libraries);
        if (library != null) {
            library = this.getLibrary(this.adapterFactory.createLibrary(library).getId());
            this.cache.put(libraryIdentifier, library);
        }
        return library;
    }
}

