/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.fhir.cql.CqlOptions;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.cql.engine.terminology.TerminologySettings;

public class EvaluationSettings {
    private Map<ModelIdentifier, Model> modelCache;
    private Map<VersionedIdentifier, CompiledLibrary> libraryCache;
    private Map<String, List<Code>> valueSetCache;
    private List<LibrarySourceProvider> librarySourceProviders;
    private CqlOptions cqlOptions;
    private RetrieveSettings retrieveSettings;
    private TerminologySettings terminologySettings;

    public static EvaluationSettings getDefault() {
        EvaluationSettings settings = new EvaluationSettings();
        CqlOptions options = CqlOptions.defaultOptions();
        settings.setCqlOptions(options);
        settings.setModelCache(new ConcurrentHashMap<ModelIdentifier, Model>());
        settings.setLibraryCache(new ConcurrentHashMap<VersionedIdentifier, CompiledLibrary>());
        settings.setValueSetCache(new ConcurrentHashMap<String, List<Code>>());
        settings.setRetrieveSettings(new RetrieveSettings());
        settings.setTerminologySettings(new TerminologySettings());
        settings.withLibrarySourceProviders(new ArrayList<LibrarySourceProvider>());
        return settings;
    }

    public Map<ModelIdentifier, Model> getModelCache() {
        return this.modelCache;
    }

    public void setModelCache(Map<ModelIdentifier, Model> modelCache) {
        this.modelCache = modelCache;
    }

    public EvaluationSettings withModelCache(Map<ModelIdentifier, Model> modelCache) {
        this.setModelCache(modelCache);
        return this;
    }

    public Map<VersionedIdentifier, CompiledLibrary> getLibraryCache() {
        return this.libraryCache;
    }

    public void setLibraryCache(Map<VersionedIdentifier, CompiledLibrary> libraryCache) {
        this.libraryCache = libraryCache;
    }

    public EvaluationSettings withLibraryCache(Map<VersionedIdentifier, CompiledLibrary> libraryCache) {
        this.setLibraryCache(libraryCache);
        return this;
    }

    public Map<String, List<Code>> getValueSetCache() {
        return this.valueSetCache;
    }

    public void setValueSetCache(Map<String, List<Code>> valueSetCache) {
        this.valueSetCache = valueSetCache;
    }

    public EvaluationSettings withValueSetCache(Map<String, List<Code>> valueSetCache) {
        this.setValueSetCache(valueSetCache);
        return this;
    }

    public CqlOptions getCqlOptions() {
        return this.cqlOptions;
    }

    public EvaluationSettings withCqlOptions(CqlOptions cqlOptions) {
        this.setCqlOptions(cqlOptions);
        return this;
    }

    public void setCqlOptions(CqlOptions cqlOptions) {
        this.cqlOptions = cqlOptions;
    }

    public RetrieveSettings getRetrieveSettings() {
        return this.retrieveSettings;
    }

    public EvaluationSettings withRetrieveSettings(RetrieveSettings retrieveSettings) {
        this.setRetrieveSettings(retrieveSettings);
        return this;
    }

    public void setRetrieveSettings(RetrieveSettings retrieveSettings) {
        this.retrieveSettings = retrieveSettings;
    }

    public TerminologySettings getTerminologySettings() {
        return this.terminologySettings;
    }

    public EvaluationSettings withTerminologySettings(TerminologySettings terminologySettings) {
        this.setTerminologySettings(terminologySettings);
        return this;
    }

    public void setTerminologySettings(TerminologySettings terminologySettings) {
        this.terminologySettings = terminologySettings;
    }

    public EvaluationSettings withLibrarySourceProviders(List<LibrarySourceProvider> librarySourceProviders) {
        this.librarySourceProviders = librarySourceProviders;
        return this;
    }

    public List<LibrarySourceProvider> getLibrarySourceProviders() {
        return this.librarySourceProviders;
    }
}

