/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.ParametersUtil;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.StringLibrarySourceProvider;
import org.cqframework.fhir.npm.NpmProcessor;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r5.model.Parameters;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryConstructor;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlParameterDefinition;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryEngine {
    private static Logger logger = LoggerFactory.getLogger(LibraryEngine.class);
    protected final Repository repository;
    protected final FhirContext fhirContext;
    protected final EvaluationSettings settings;
    protected NpmProcessor npmProcessor;

    public LibraryEngine(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null);
    }

    public LibraryEngine(Repository repository, EvaluationSettings evaluationSettings, NpmProcessor npmProcessor) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.settings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirContext = repository.fhirContext();
        this.npmProcessor = npmProcessor;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public EvaluationSettings getSettings() {
        return this.settings;
    }

    private Pair<String, Object> buildContextParameter(String patientId) {
        Pair contextParameter = null;
        if (patientId != null) {
            if (patientId.startsWith("Patient/")) {
                patientId = patientId.replace("Patient/", "");
            }
            contextParameter = Pair.of((Object)"Patient", (Object)patientId);
        }
        return contextParameter;
    }

    public IBaseParameters evaluate(String url, String patientId, IBaseParameters parameters, IBaseBundle additionalData, ZonedDateTime zonedDateTime, Set<String> expressions) {
        return this.evaluate(VersionedIdentifiers.forUrl(url), patientId, parameters, additionalData, zonedDateTime, expressions);
    }

    public IBaseParameters evaluate(VersionedIdentifier id, String patientId, IBaseParameters parameters, IBaseBundle additionalData, ZonedDateTime zonedDateTime, Set<String> expressions) {
        CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.repository.fhirContext());
        EvaluationResult result = this.getEvaluationResult(id, patientId, parameters, additionalData, expressions, cqlFhirParametersConverter, zonedDateTime, null);
        return cqlFhirParametersConverter.toFhirParameters(result);
    }

    public IBaseParameters evaluateExpression(String expression, IBaseParameters parameters, String patientId, List<Pair<String, String>> libraries, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        LibraryConstructor libraryConstructor = new LibraryConstructor(this.fhirContext);
        CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.fhirContext);
        List<CqlParameterDefinition> cqlParameters = cqlFhirParametersConverter.toCqlParameterDefinitions(parameters);
        if (contextParameter != null) {
            String contextType = contextParameter.getClass().getSimpleName();
            cqlParameters.add(new CqlParameterDefinition("%fhirpathcontext", contextType, false, contextParameter));
            String resourceType = resourceParameter == null ? contextType : resourceParameter.getClass().getSimpleName();
            cqlParameters.add(new CqlParameterDefinition("%resource", resourceType, false, resourceParameter == null ? contextParameter : resourceParameter));
        }
        if (expression.contains("%context")) {
            expression = expression.replace("%context", "%fhirpathcontext");
        }
        String cql = libraryConstructor.constructCqlLibrary(expression, libraries, cqlParameters);
        HashSet<String> expressions = new HashSet<String>();
        expressions.add("return");
        ArrayList<StringLibrarySourceProvider> librarySourceProviders = new ArrayList<StringLibrarySourceProvider>();
        librarySourceProviders.add(new StringLibrarySourceProvider((List)Lists.newArrayList((Object[])new String[]{cql})));
        CqlEngine engine = Engines.forRepositoryAndSettings(this.settings, this.repository, bundle, this.npmProcessor, false);
        LibrarySourceLoader providers = engine.getEnvironment().getLibraryManager().getLibrarySourceLoader();
        for (LibrarySourceProvider librarySourceProvider : librarySourceProviders) {
            providers.registerProvider(librarySourceProvider);
        }
        Map<String, Object> evaluationParameters = cqlFhirParametersConverter.toCqlParameters(parameters);
        if (contextParameter != null) {
            evaluationParameters.put("%fhirpathcontext", contextParameter);
            evaluationParameters.put("%resource", resourceParameter == null ? contextParameter : resourceParameter);
        }
        VersionedIdentifier versionedIdentifier = new VersionedIdentifier().withId("expression").withVersion("1.0.0");
        EvaluationResult result = engine.evaluate(versionedIdentifier.getId(), expressions, this.buildContextParameter(patientId), evaluationParameters);
        return cqlFhirParametersConverter.toFhirParameters(result);
    }

    public List<IBase> getExpressionResult(String subjectId, String expression, String language, String libraryToBeEvaluated, IBaseParameters parameters, IBaseBundle bundle) {
        return this.getExpressionResult(subjectId, expression, language, libraryToBeEvaluated, parameters, bundle, null, null);
    }

    public List<IBase> getExpressionResult(String subjectId, String expression, String language, String libraryToBeEvaluated, IBaseParameters parameters, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        this.validateExpression(language, expression);
        List<IBase> results = null;
        switch (language) {
            case "text/cql": 
            case "text/cql.expression": 
            case "text/cql-expression": 
            case "text/fhirpath": {
                ArrayList<Pair<String, String>> libraries = new ArrayList<Pair<String, String>>();
                if (!StringUtils.isBlank((CharSequence)libraryToBeEvaluated)) {
                    libraries.add((Pair<String, String>)new ImmutablePair((Object)libraryToBeEvaluated, (Object)Canonicals.getIdPart((String)libraryToBeEvaluated)));
                }
                IBaseParameters parametersResult = this.evaluateExpression(expression, parameters, subjectId, libraries, bundle, contextParameter, resourceParameter);
                results = this.resolveParameterValues(ParametersUtil.getNamedParameters((FhirContext)this.fhirContext, (IBaseResource)parametersResult, (String)"return"));
                break;
            }
            case "text/cql-identifier": 
            case "text/cql.identifier": 
            case "text/cql.name": 
            case "text/cql-name": {
                this.validateLibrary(libraryToBeEvaluated);
                IBaseParameters parametersResult = this.evaluate(libraryToBeEvaluated, subjectId, parameters, bundle, null, Collections.singleton(expression));
                results = this.resolveParameterValues(ParametersUtil.getNamedParameters((FhirContext)this.fhirContext, (IBaseResource)parametersResult, (String)expression));
                break;
            }
            default: {
                logger.warn("An action language other than CQL was found: {}", (Object)language);
            }
        }
        return results;
    }

    public void validateExpression(String language, String expression) {
        if (language == null) {
            logger.error("Missing language type for the Expression");
            throw new IllegalArgumentException("Missing language type for the Expression");
        }
        if (expression == null) {
            logger.error("Missing expression for the Expression");
            throw new IllegalArgumentException("Missing expression for the Expression");
        }
    }

    public void validateLibrary(String libraryUrl) {
        if (libraryUrl == null) {
            logger.error("Missing library for the Expression");
            throw new IllegalArgumentException("Missing library for the Expression");
        }
    }

    public List<IBase> resolveParameterValues(List<IBase> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        ArrayList<IBase> returnValues = new ArrayList<IBase>();
        switch (this.fhirContext.getVersion().getVersion()) {
            case DSTU3: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            case R4: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            case R5: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("unsupported FHIR version: %s", this.fhirContext));
            }
        }
        return returnValues;
    }

    public List<IBase> resolveExpression(String patientId, CqfExpression expression, IBaseParameters params, IBaseBundle bundle) {
        return this.resolveExpression(patientId, expression, params, bundle, null, null);
    }

    public List<IBase> resolveExpression(String patientId, CqfExpression expression, IBaseParameters params, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        List<IBase> result = this.getExpressionResult(patientId, expression.getExpression(), expression.getLanguage(), expression.getLibraryUrl(), params, bundle, contextParameter, resourceParameter);
        if (result == null && expression.getAltExpression() != null) {
            result = this.getExpressionResult(patientId, expression.getAltExpression(), expression.getAltLanguage(), expression.getAltLibraryUrl(), params, bundle, contextParameter, resourceParameter);
        }
        return result;
    }

    public EvaluationResult getEvaluationResult(VersionedIdentifier id, String patientId, IBaseParameters parameters, IBaseBundle additionalData, Set<String> expressions, CqlFhirParametersConverter cqlFhirParametersConverter, @Nullable ZonedDateTime zonedDateTime, CqlEngine engine) {
        if (cqlFhirParametersConverter == null) {
            cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.repository.fhirContext());
        }
        if (engine == null) {
            engine = Engines.forRepositoryAndSettings(this.settings, this.repository, additionalData, this.npmProcessor, true);
        }
        Map<String, Object> evaluationParameters = cqlFhirParametersConverter.toCqlParameters(parameters);
        return engine.evaluate(new VersionedIdentifier().withId(id.getId()), expressions, this.buildContextParameter(patientId), evaluationParameters, null, zonedDateTime);
    }
}

