/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlParameterDefinition;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryConstructor {
    private static final Logger logger = LoggerFactory.getLogger(LibraryConstructor.class);
    protected FhirContext fhirContext;
    protected IFhirPath fhirPath;

    public LibraryConstructor(FhirContext fhirContext) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext can not be null");
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)fhirContext);
    }

    public String constructCqlLibrary(String expression, List<Pair<String, String>> libraries, List<CqlParameterDefinition> parameters) {
        logger.debug("Constructing expression for local evaluation");
        return this.constructCqlLibrary("expression", "1.0.0", Arrays.asList(String.format("%ndefine \"return\":%n       %s", expression)), libraries, parameters);
    }

    public String constructCqlLibrary(String name, String version, List<String> expressions, List<Pair<String, String>> libraries, List<CqlParameterDefinition> parameters) {
        StringBuilder sb = new StringBuilder();
        this.constructHeader(sb, name, version);
        this.constructUsings(sb);
        this.constructIncludes(sb, libraries);
        this.constructParameters(sb, parameters);
        this.constructContext(sb, null);
        for (String expression : expressions) {
            sb.append(String.format("%s%n%n", expression));
        }
        String cql = sb.toString();
        logger.debug(cql);
        return cql;
    }

    private String getFhirVersionString(FhirVersionEnum fhirVersion) {
        return fhirVersion == FhirVersionEnum.DSTU3 ? "3.0.1" : fhirVersion.getFhirVersionString();
    }

    private void constructIncludes(StringBuilder sb, List<Pair<String, String>> libraries) {
        sb.append(String.format("include FHIRHelpers version '%s' called FHIRHelpers%n", this.getFhirVersionString(this.fhirContext.getVersion().getVersion())));
        if (libraries != null) {
            for (Pair<String, String> library : libraries) {
                VersionedIdentifier vi = VersionedIdentifiers.forUrl((String)library.getLeft());
                sb.append(String.format("include \"%s\"", vi.getId()));
                if (vi.getVersion() != null) {
                    sb.append(String.format(" version '%s'", vi.getVersion()));
                }
                if (library.getRight() != null) {
                    sb.append(String.format(" called \"%s\"", library.getRight()));
                }
                sb.append("\n");
            }
        }
        sb.append("\n");
    }

    private void constructParameters(StringBuilder sb, List<CqlParameterDefinition> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (CqlParameterDefinition cpd : parameters) {
            sb.append("parameter \"").append(cpd.getName()).append("\" ").append(this.getTypeDeclaration(cpd.getType(), cpd.getIsList())).append(String.format("%n", new Object[0]));
        }
    }

    private String getTypeDeclaration(String type, Boolean isList) {
        if (Boolean.TRUE.equals(isList)) {
            return "List<" + type + ">";
        }
        return type;
    }

    private void constructUsings(StringBuilder sb) {
        sb.append(String.format("using FHIR version '%s'%n%n", this.getFhirVersionString(this.fhirContext.getVersion().getVersion())));
    }

    private void constructHeader(StringBuilder sb, String name, String version) {
        sb.append(String.format("library %s version '%s'%n%n", name, version));
    }

    private void constructContext(StringBuilder sb, String contextType) {
        sb.append(String.format(String.format("context %s%n%n", StringUtils.isBlank((CharSequence)contextType) ? "Patient" : contextType), new Object[0]));
    }
}

