/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.cql2elm.content;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.cqframework.cql.cql2elm.LibraryContentType;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IAttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;

public abstract class BaseFhirLibrarySourceProvider
implements LibrarySourceProvider {
    protected IAdapterFactory adapterFactory;

    protected BaseFhirLibrarySourceProvider(IAdapterFactory adapterFactory) {
        this.adapterFactory = Objects.requireNonNull(adapterFactory, "adapterFactory can not be null");
    }

    public InputStream getLibraryContent(VersionedIdentifier libraryIdentifier, LibraryContentType libraryContentType) {
        Objects.requireNonNull(libraryIdentifier, "versionedIdentifier can not be null.");
        Objects.requireNonNull(libraryContentType, "libraryContentType can not be null.");
        IBaseResource library = this.getLibrary(libraryIdentifier);
        if (library == null) {
            return null;
        }
        return this.getContentStream(library, libraryContentType.mimeType());
    }

    protected InputStream getContentStream(IBaseResource library, String contentType) {
        ILibraryAdapter libraryAdapter = this.adapterFactory.createLibrary(library);
        if (libraryAdapter.hasContent()) {
            for (ICompositeType attachment : libraryAdapter.getContent()) {
                IAttachmentAdapter attachmentAdapter = this.adapterFactory.createAttachment(attachment);
                if (!attachmentAdapter.getContentType().equals(contentType)) continue;
                return new ByteArrayInputStream(attachmentAdapter.getData());
            }
        }
        return null;
    }

    public InputStream getLibrarySource(VersionedIdentifier libraryIdentifier) {
        return this.getLibraryContent(libraryIdentifier, LibraryContentType.CQL);
    }

    protected abstract IBaseResource getLibrary(VersionedIdentifier var1);
}

