/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.parameters;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.cql.engine.execution.ExpressionResult;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlParameterDefinition;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IParametersAdapter;
import org.opencds.cqf.fhir.utility.adapter.IParametersParameterComponentAdapter;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlFhirParametersConverter {
    Logger logger = LoggerFactory.getLogger(CqlFhirParametersConverter.class);
    protected IAdapterFactory adapterFactory;
    protected FhirTypeConverter fhirTypeConverter;
    protected FhirContext fhirContext;
    private ModelResolver modelResolver;
    static final String EMPTY_LIST_EXT_URL = "http://hl7.org/fhir/StructureDefinition/cqf-isEmptyList";
    static final String DATA_ABSENT_REASON_EXT_URL = "http://hl7.org/fhir/StructureDefinition/data-absent-reason";
    static final String DATA_ABSENT_REASON_UNKNOWN_CODE = "unknown";

    public CqlFhirParametersConverter(FhirContext fhirContext, IAdapterFactory adapterFactory, FhirTypeConverter fhirTypeConverter) {
        this.fhirContext = Objects.requireNonNull(fhirContext);
        this.adapterFactory = Objects.requireNonNull(adapterFactory);
        this.fhirTypeConverter = Objects.requireNonNull(fhirTypeConverter);
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirContext.getVersion().getVersion());
    }

    private static IBaseBooleanDatatype booleanType(FhirContext context, Boolean value) {
        try {
            return (IBaseBooleanDatatype)context.getElementDefinition("Boolean").getImplementingClass().getDeclaredConstructor(Boolean.class).newInstance(value);
        }
        catch (Exception e) {
            throw new InternalErrorException("error creating BooleanType", (Throwable)e);
        }
    }

    private static IBaseDatatype codeType(FhirContext context, String value) {
        try {
            return (IBaseDatatype)context.getElementDefinition("Code").getImplementingClass().getDeclaredConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            throw new InternalErrorException("error creating CodeType", (Throwable)e);
        }
    }

    private static IBaseBooleanDatatype emptyBooleanWithExtension(FhirContext context, String url, IBaseDatatype value) {
        IBaseBooleanDatatype result = CqlFhirParametersConverter.booleanType(context, null);
        IBaseExtension ext = ((IBaseHasExtensions)result).addExtension();
        ext.setUrl(url);
        ext.setValue(value);
        return result;
    }

    public IBaseParameters toFhirParameters(EvaluationResult evaluationResult) {
        IBaseParameters params = null;
        try {
            params = (IBaseParameters)this.fhirContext.getResourceDefinition("Parameters").getImplementingClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error trying to create Parameters resource", (Throwable)e);
            throw new RuntimeException(e);
        }
        IParametersAdapter pa = this.adapterFactory.createParameters(params);
        for (Map.Entry entry : evaluationResult.expressionResults.entrySet()) {
            String name = (String)entry.getKey();
            Object value = ((ExpressionResult)entry.getValue()).value();
            if (value == null) {
                IBaseBooleanDatatype dataAbsentValue = CqlFhirParametersConverter.emptyBooleanWithExtension(this.fhirContext, DATA_ABSENT_REASON_EXT_URL, CqlFhirParametersConverter.codeType(this.fhirContext, DATA_ABSENT_REASON_UNKNOWN_CODE));
                this.addPart(pa, name, dataAbsentValue);
                continue;
            }
            if (value instanceof Iterable) {
                Iterable iterable = (Iterable)value;
                if (!iterable.iterator().hasNext()) {
                    IBaseBooleanDatatype emptyListValue = CqlFhirParametersConverter.emptyBooleanWithExtension(this.fhirContext, EMPTY_LIST_EXT_URL, (IBaseDatatype)CqlFhirParametersConverter.booleanType(this.fhirContext, true));
                    this.addPart(pa, name, emptyListValue);
                }
                Iterable values = (Iterable)value;
                for (Object o : values) {
                    this.addPart(pa, name, o);
                }
                continue;
            }
            this.addPart(pa, name, value);
        }
        return params;
    }

    protected IParametersParameterComponentAdapter addPart(IParametersAdapter pa, String name) {
        IBaseBackboneElement ppc = pa.addParameter();
        IParametersParameterComponentAdapter ppca = this.adapterFactory.createParametersParameters(ppc);
        ppca.setName(name);
        return ppca;
    }

    protected void addPart(IParametersAdapter pa, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            IParametersParameterComponentAdapter ppca = this.addPart(pa, name);
            Iterable values = (Iterable)value;
            for (Object o : values) {
                this.addSubPart(ppca, "element", o);
            }
            return;
        }
        if (this.fhirTypeConverter.isCqlType(value)) {
            value = this.fhirTypeConverter.toFhirType(value);
        }
        if (value instanceof IBaseBackboneElement) {
            IParametersParameterComponentAdapter ppca = this.adapterFactory.createParametersParameters((IBaseBackboneElement)value);
            ppca.setName(name);
            pa.addParameter((IBase)ppca.get());
        } else if (value instanceof IBaseDatatype) {
            IParametersParameterComponentAdapter ppca = this.addPart(pa, name);
            ppca.setValue((IBaseDatatype)value);
        } else if (value instanceof IBaseResource) {
            IParametersParameterComponentAdapter ppca = this.addPart(pa, name);
            ppca.setResource((IBaseResource)value);
        } else {
            throw new IllegalArgumentException(String.format("unknown type when trying to convert to parameters: %s", value.getClass().getSimpleName()));
        }
    }

    protected IParametersParameterComponentAdapter addSubPart(IParametersParameterComponentAdapter ppcAdapter, String name) {
        IBaseBackboneElement ppc = ppcAdapter.addPart();
        IParametersParameterComponentAdapter ppca = this.adapterFactory.createParametersParameters(ppc);
        ppca.setName(name);
        return ppca;
    }

    protected void addSubPart(IParametersParameterComponentAdapter ppcAdapter, String name, Object value) {
        IParametersParameterComponentAdapter ppca = this.addSubPart(ppcAdapter, name);
        if (value == null) {
            return;
        }
        if (value instanceof Iterable) {
            Iterable values = (Iterable)value;
            for (Object o : values) {
                this.addSubPart(ppca, "element", o);
            }
            return;
        }
        if (this.fhirTypeConverter.isCqlType(value)) {
            value = this.fhirTypeConverter.toFhirType(value);
        }
        if (value instanceof IBaseDatatype) {
            ppca.setValue((IBaseDatatype)value);
        } else if (value instanceof IBaseResource) {
            ppca.setResource((IBaseResource)value);
        } else {
            throw new IllegalArgumentException(String.format("unknown type when trying to convert to parameters: %s", value.getClass().getSimpleName()));
        }
    }

    public List<CqlParameterDefinition> toCqlParameterDefinitions(IBaseParameters parameters) {
        if (parameters == null) {
            return Collections.emptyList();
        }
        IParametersAdapter parametersAdapter = this.adapterFactory.createParameters(parameters);
        Map<String, List<IParametersParameterComponentAdapter>> children = parametersAdapter.getParameter().stream().map(x -> this.adapterFactory.createParametersParameters(x)).filter(x -> x.getName() != null).collect(Collectors.groupingBy(IParametersParameterComponentAdapter::getName));
        ArrayList<CqlParameterDefinition> cqlParameterDefinitions = new ArrayList<CqlParameterDefinition>();
        for (Map.Entry<String, List<IParametersParameterComponentAdapter>> entry : children.entrySet()) {
            Optional<IBaseExtension> ext = entry.getValue().stream().filter(x -> x.hasExtension()).flatMap(x -> x.getExtension().stream()).filter(x -> x.getUrl() != null && x.getUrl().equals("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-parameterDefinition")).findFirst();
            List values = entry.getValue().stream().map(x -> this.convertToCql((IParametersParameterComponentAdapter)x)).filter(x -> x != null).collect(Collectors.toList());
            String name = entry.getKey();
            Boolean isList = null;
            if (ext.isPresent()) {
                isList = this.isListType(ext.get());
            }
            if (isList == null) {
                if (values.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Unable to determine if parameter %s is meant to be collection. Use the http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-parameterDefinition extension to specify metadata.", entry.getKey()));
                }
                isList = values.size() == 1 ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            if (!isList.booleanValue() && entry.getValue().size() > 1) {
                throw new IllegalArgumentException(String.format("The parameter %s was defined as a single value but multiple values were passed", entry.getKey()));
            }
            String type = null;
            if (ext.isPresent()) {
                type = this.getType(ext.get());
            }
            if (type == null && !values.isEmpty()) {
                type = values.get(0).getClass().getSimpleName();
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Unable to infer type for parameter %s. Use the http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-parameterDefinition extension to specify metadata.", entry.getKey()));
            }
            List value = null;
            if (isList.booleanValue()) {
                value = values;
            } else if (!values.isEmpty()) {
                value = values.get(0);
            }
            cqlParameterDefinitions.add(new CqlParameterDefinition(name, type, isList, value));
        }
        return cqlParameterDefinitions;
    }

    public Map<String, Object> toCqlParameters(IBaseParameters parameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        List<CqlParameterDefinition> cqlParameterDefinitions = this.toCqlParameterDefinitions(parameters);
        if (cqlParameterDefinitions == null || cqlParameterDefinitions.isEmpty()) {
            return parameterMap;
        }
        for (CqlParameterDefinition def : cqlParameterDefinitions) {
            parameterMap.put(def.getName(), def.getValue());
        }
        return parameterMap;
    }

    private String getType(IBaseExtension<?, ?> parameterDefinitionExtension) {
        Object type = this.modelResolver.resolvePath((Object)parameterDefinitionExtension.getValue(), "type");
        if (type instanceof IPrimitiveType) {
            return ((IPrimitiveType)type).getValueAsString();
        }
        return null;
    }

    private Boolean isListType(IBaseExtension<?, ?> parameterDefinitionExtension) {
        Object max = this.modelResolver.resolvePath((Object)parameterDefinitionExtension.getValue(), "max");
        if (max instanceof IPrimitiveType) {
            String maxString = ((IPrimitiveType)max).getValueAsString();
            return !maxString.equals("1");
        }
        Object min = this.modelResolver.resolvePath((Object)parameterDefinitionExtension.getValue(), "min");
        if (min instanceof IPrimitiveType) {
            return (Integer)((IPrimitiveType)min).getValue() > 1;
        }
        return false;
    }

    private Object convertToCql(IParametersParameterComponentAdapter ppca) {
        if (ppca.hasValue()) {
            return this.fhirTypeConverter.toCqlType((Object)ppca.getValue());
        }
        if (ppca.hasResource()) {
            return ppca.getResource();
        }
        if (ppca.hasPart()) {
            this.logger.debug("Ignored {} parameter sub-parts", (Object)ppca.getPart().size());
        }
        return null;
    }
}

