/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.repository.IRepository;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceLoader;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.quick.FhirLibrarySourceProvider;
import org.cqframework.fhir.npm.ILibraryReader;
import org.cqframework.fhir.npm.LibraryLoader;
import org.cqframework.fhir.npm.NpmLibrarySourceProvider;
import org.cqframework.fhir.npm.NpmModelInfoProvider;
import org.cqframework.fhir.npm.NpmProcessor;
import org.cqframework.fhir.utilities.LoggerAdapter;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.cql.model.NamespaceInfo;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r5.context.ILoggingService;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.Environment;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverterFactory;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.cql2elm.content.RepositoryFhirLibrarySourceProvider;
import org.opencds.cqf.fhir.cql.cql2elm.util.LibraryVersionSelector;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.cql.engine.retrieve.FederatedDataProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RepositoryRetrieveProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.cql.engine.terminology.RepositoryTerminologyProvider;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engines {
    private static Logger logger = LoggerFactory.getLogger(Engines.class);

    private Engines() {
    }

    public static CqlEngine forRepository(IRepository repository) {
        return Engines.forRepository(repository, EvaluationSettings.getDefault());
    }

    public static CqlEngine forRepository(IRepository repository, EvaluationSettings settings) {
        return Engines.forRepository(repository, settings, null);
    }

    public static CqlEngine forRepository(IRepository repository, EvaluationSettings settings, IBaseBundle additionalData) {
        Preconditions.checkNotNull((Object)settings);
        Preconditions.checkNotNull((Object)repository);
        RepositoryTerminologyProvider terminologyProvider = new RepositoryTerminologyProvider(repository, settings.getValueSetCache(), settings.getTerminologySettings());
        Map<String, DataProvider> dataProviders = Engines.buildDataProviders(repository, additionalData, terminologyProvider, settings.getRetrieveSettings());
        Environment environment = Engines.buildEnvironment(repository, settings, terminologyProvider, dataProviders);
        return Engines.createEngine(environment, settings);
    }

    private static Environment buildEnvironment(IRepository repository, EvaluationSettings settings, TerminologyProvider terminologyProvider, Map<String, DataProvider> dataProviders) {
        ModelManager modelManager = settings.getModelCache() != null ? new ModelManager(settings.getModelCache()) : new ModelManager();
        LibraryManager libraryManager = new LibraryManager(modelManager, settings.getCqlOptions().getCqlCompilerOptions(), settings.getLibraryCache());
        Engines.registerLibrarySourceProviders(settings, libraryManager, repository);
        Engines.registerNpmSupport(settings, libraryManager, modelManager);
        return new Environment(libraryManager, dataProviders, terminologyProvider);
    }

    private static void registerLibrarySourceProviders(EvaluationSettings settings, LibraryManager manager, IRepository repository) {
        LibrarySourceLoader loader = manager.getLibrarySourceLoader();
        loader.clearProviders();
        for (LibrarySourceProvider s : settings.getLibrarySourceProviders()) {
            loader.registerProvider(s);
        }
        if (settings.getCqlOptions().useEmbeddedLibraries()) {
            loader.registerProvider((LibrarySourceProvider)new FhirLibrarySourceProvider());
        }
        loader.registerProvider(Engines.buildLibrarySource(repository));
    }

    private static void registerNpmSupport(EvaluationSettings settings, LibraryManager libraryManager, ModelManager modelManager) {
        NpmProcessor npmProcessor = settings.getNpmProcessor();
        if (npmProcessor == null || npmProcessor.getIgContext() == null || npmProcessor.getPackageManager() == null) {
            return;
        }
        LibraryLoader reader = new LibraryLoader(npmProcessor.getIgContext().getFhirVersion());
        LoggerAdapter adapter = new LoggerAdapter(logger);
        libraryManager.getLibrarySourceLoader().registerProvider((LibrarySourceProvider)new NpmLibrarySourceProvider(npmProcessor.getPackageManager().getNpmList(), (ILibraryReader)reader, (ILoggingService)adapter));
        modelManager.getModelInfoLoader().registerModelInfoProvider((ModelInfoProvider)new NpmModelInfoProvider(npmProcessor.getPackageManager().getNpmList(), (ILibraryReader)reader, (ILoggingService)adapter));
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> uris = new HashSet<String>();
        for (NamespaceInfo n : npmProcessor.getNamespaces()) {
            if (keys.contains(n.getName()) || uris.contains(n.getUri())) continue;
            libraryManager.getNamespaceManager().addNamespace(n);
            keys.add(n.getName());
            uris.add(n.getUri());
        }
    }

    private static LibrarySourceProvider buildLibrarySource(IRepository repository) {
        IAdapterFactory adapterFactory = IAdapterFactory.forFhirContext((FhirContext)repository.fhirContext());
        return new RepositoryFhirLibrarySourceProvider(repository, adapterFactory, new LibraryVersionSelector(adapterFactory));
    }

    private static Map<String, DataProvider> buildDataProviders(IRepository repository, IBaseBundle additionalData, TerminologyProvider terminologyProvider, RetrieveSettings retrieveSettings) {
        HashMap<String, DataProvider> dataProviders = new HashMap<String, DataProvider>();
        ArrayList<RetrieveProvider> providers = new ArrayList<RetrieveProvider>();
        ModelResolver modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)repository.fhirContext().getVersion().getVersion());
        RepositoryRetrieveProvider retrieveProvider = new RepositoryRetrieveProvider(repository, terminologyProvider, retrieveSettings);
        providers.add(retrieveProvider);
        if (additionalData != null && modelResolver.resolvePath((Object)additionalData, "entry") != null) {
            InMemoryFhirRepository bundleRepo = new InMemoryFhirRepository(repository.fhirContext(), additionalData);
            RepositoryRetrieveProvider provider = new RepositoryRetrieveProvider((IRepository)bundleRepo, terminologyProvider, retrieveSettings);
            providers.add(provider);
        }
        dataProviders.put("http://hl7.org/fhir", (DataProvider)new FederatedDataProvider(modelResolver, providers));
        return dataProviders;
    }

    private static CqlEngine createEngine(Environment environment, EvaluationSettings settings) {
        CqlEngine engine = new CqlEngine(environment, settings.getCqlOptions().getCqlEngineOptions().getOptions());
        if (settings.getCqlOptions().getCqlEngineOptions().isDebugLoggingEnabled()) {
            DebugMap map = new DebugMap();
            map.setIsLoggingEnabled(true);
            engine.getState().setDebugMap(map);
        }
        return engine;
    }

    public static CqlFhirParametersConverter getCqlFhirParametersConverter(FhirContext fhirContext) {
        FhirTypeConverter fhirTypeConverter = new FhirTypeConverterFactory().create(fhirContext.getVersion().getVersion());
        return new CqlFhirParametersConverter(fhirContext, IAdapterFactory.forFhirContext((FhirContext)fhirContext), fhirTypeConverter);
    }
}

