/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.utility.CqfExpression;

public class ExtensionResolver {
    private final IIdType subjectId;
    private final IBaseParameters parameters;
    private final IBaseBundle bundle;
    private final LibraryEngine libraryEngine;

    public ExtensionResolver(IIdType subjectId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        this.subjectId = subjectId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
    }

    public <E extends IBaseExtension> void resolveExtensions(IBase resource, List<E> extensions, Map<String, String> referencedLibraries) {
        for (IBaseExtension extension : extensions) {
            IBaseDatatype result;
            Optional<IBaseExtension> expressionExtensions;
            IBaseHasExtensions hasExtensions;
            List valueExtensions;
            IBaseDatatype value;
            List nestedExtensions = extension.getExtension();
            if (nestedExtensions != null && !nestedExtensions.isEmpty()) {
                this.resolveExtensions(resource, nestedExtensions, referencedLibraries);
            }
            if (!((value = extension.getValue()) instanceof IBaseHasExtensions) || (valueExtensions = (hasExtensions = (IBaseHasExtensions)value).getExtension()) == null || !(expressionExtensions = valueExtensions.stream().filter(e -> e.getUrl() != null && e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/cqf-expression")).findFirst()).isPresent() || (result = this.getExpressionResult(expressionExtensions.get(), referencedLibraries, resource)) == null) continue;
            extension.setValue(result);
        }
    }

    protected <E extends IBaseExtension<?, ?>> IBaseDatatype getExpressionResult(E expressionExtension, Map<String, String> referencedLibraries, IBase resource) {
        List<IBase> result = this.libraryEngine.resolveExpression(this.subjectId.getIdPart(), CqfExpression.of(expressionExtension, referencedLibraries), this.parameters, null, this.bundle, resource, null);
        return result != null && !result.isEmpty() ? (IBaseDatatype)result.get(0) : null;
    }
}

