/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.fhirpath.IFhirPath;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hl7.elm.r1.VersionedIdentifier;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlParameterDefinition;
import org.opencds.cqf.fhir.utility.FhirPathCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryConstructor {
    private static final Logger logger = LoggerFactory.getLogger(LibraryConstructor.class);
    protected FhirContext fhirContext;
    protected IFhirPath fhirPath;

    public LibraryConstructor(FhirContext fhirContext) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext can not be null");
        this.fhirPath = FhirPathCache.cachedForContext((FhirContext)fhirContext);
    }

    public String constructCqlLibrary(String name, String version, String expression, Map<String, String> libraries, List<CqlParameterDefinition> parameters) {
        logger.debug("Constructing expression for local evaluation");
        return this.constructCqlLibrary(name, version, List.of("%ndefine \"return\":%n       %s".formatted(expression)), libraries, parameters);
    }

    public String constructCqlLibrary(String name, String version, List<String> expressions, Map<String, String> libraries, List<CqlParameterDefinition> parameters) {
        StringBuilder sb = new StringBuilder();
        this.constructHeader(sb, name, version);
        this.constructUsings(sb);
        this.constructIncludes(sb, libraries);
        this.constructParameters(sb, parameters);
        this.constructContext(sb, null);
        for (String expression : expressions) {
            sb.append("%s%n%n".formatted(expression));
        }
        String cql = sb.toString();
        logger.debug(cql);
        return cql;
    }

    private String getFhirVersionString(FhirVersionEnum fhirVersion) {
        return fhirVersion == FhirVersionEnum.DSTU3 ? "3.0.1" : fhirVersion.getFhirVersionString();
    }

    private void constructIncludes(StringBuilder sb, Map<String, String> libraries) {
        sb.append("include FHIRHelpers version '%s' called FHIRHelpers%n".formatted(this.getFhirVersionString(this.fhirContext.getVersion().getVersion())));
        if (libraries != null) {
            for (Map.Entry<String, String> library : libraries.entrySet()) {
                VersionedIdentifier vi = VersionedIdentifiers.forUrl(library.getValue());
                sb.append("include \"%s\"".formatted(vi.getId()));
                if (vi.getVersion() != null) {
                    sb.append(" version '%s'".formatted(vi.getVersion()));
                }
                sb.append(" called \"%s\"".formatted(library.getKey()));
                sb.append("\n");
            }
        }
        sb.append("\n");
    }

    private void constructParameters(StringBuilder sb, List<CqlParameterDefinition> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (CqlParameterDefinition cpd : parameters) {
            sb.append("parameter \"").append(cpd.getName()).append("\" ").append(this.getTypeDeclaration(cpd.getType(), cpd.getIsList())).append("%n".formatted(new Object[0]));
        }
    }

    private String getTypeDeclaration(String type, Boolean isList) {
        if (Boolean.TRUE.equals(isList)) {
            return "List<" + type + ">";
        }
        return type;
    }

    private void constructUsings(StringBuilder sb) {
        sb.append("using FHIR version '%s'%n%n".formatted(this.getFhirVersionString(this.fhirContext.getVersion().getVersion())));
    }

    private void constructHeader(StringBuilder sb, String name, String version) {
        sb.append("library %s version '%s'%n%n".formatted(name, version));
    }

    private void constructContext(StringBuilder sb, String contextType) {
        sb.append("context %s%n%n".formatted(StringUtils.isBlank((CharSequence)contextType) ? "Patient" : contextType).formatted(new Object[0]));
    }
}

