/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.repository.IRepository;
import ca.uhn.fhir.util.ParametersUtil;
import com.google.common.collect.Lists;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.StringLibrarySourceProvider;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r5.model.Parameters;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.EvaluationResult;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryConstructor;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlFhirParametersConverter;
import org.opencds.cqf.fhir.cql.engine.parameters.CqlParameterDefinition;
import org.opencds.cqf.fhir.utility.CqfExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryEngine {
    private static final Logger logger = LoggerFactory.getLogger(LibraryEngine.class);
    protected final IRepository repository;
    protected final FhirContext fhirContext;
    protected final EvaluationSettings settings;

    public LibraryEngine(IRepository repository, EvaluationSettings evaluationSettings) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.settings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirContext = repository.fhirContext();
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public EvaluationSettings getSettings() {
        return this.settings;
    }

    private Pair<String, Object> buildContextParameter(String patientId) {
        Pair contextParameter = null;
        if (patientId != null) {
            if (patientId.startsWith("Patient/")) {
                patientId = patientId.replace("Patient/", "");
            }
            contextParameter = Pair.of((Object)"Patient", (Object)patientId);
        }
        return contextParameter;
    }

    public IBaseParameters evaluate(String url, String patientId, IBaseParameters parameters, Map<String, Object> rawParameters, IBaseBundle additionalData, ZonedDateTime zonedDateTime, Set<String> expressions) {
        return this.evaluate(VersionedIdentifiers.forUrl(url), patientId, parameters, rawParameters, additionalData, zonedDateTime, expressions);
    }

    public IBaseParameters evaluate(VersionedIdentifier id, String patientId, IBaseParameters parameters, Map<String, Object> rawParameters, IBaseBundle additionalData, ZonedDateTime zonedDateTime, Set<String> expressions) {
        CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.repository.fhirContext());
        EvaluationResult result = this.getEvaluationResult(id, patientId, parameters, rawParameters, additionalData, expressions, cqlFhirParametersConverter, zonedDateTime, null);
        return cqlFhirParametersConverter.toFhirParameters(result);
    }

    protected String getModelName(Object base) {
        if (base instanceof List) {
            List list = (List)base;
            return this.getModelName(list.get(0));
        }
        String fhirType = ((IBase)base).fhirType();
        if (fhirType.contains(".")) {
            String[] split = fhirType.split("\\.");
            fhirType = Arrays.stream(split).map(StringUtils::capitalize).collect(Collectors.joining("."));
        }
        return "FHIR.%s".formatted(fhirType);
    }

    public IBaseParameters evaluateExpression(String expression, IBaseParameters parameters, Map<String, Object> rawParameters, String patientId, Map<String, String> referencedLibraries, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        LibraryConstructor libraryConstructor = new LibraryConstructor(this.fhirContext);
        CqlFhirParametersConverter cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.fhirContext);
        List<CqlParameterDefinition> cqlParameters = cqlFhirParametersConverter.toCqlParameterDefinitions(parameters);
        String fhirPathContextName = "%fhirpathcontext";
        if (contextParameter != null) {
            String contextType = this.getModelName(contextParameter);
            cqlParameters.add(new CqlParameterDefinition(fhirPathContextName, contextType, false));
            String resourceType = resourceParameter == null ? contextType : this.getModelName(resourceParameter);
            cqlParameters.add(new CqlParameterDefinition("%resource", resourceType, false));
        }
        if (rawParameters != null) {
            rawParameters.forEach((k, v) -> cqlParameters.add(new CqlParameterDefinition((String)k, this.getModelName(v), v instanceof List)));
        }
        if (expression.contains("%context")) {
            expression = expression.replace("%context", fhirPathContextName);
        }
        String libraryName = "expression";
        String libraryVersion = "1.0.0";
        String cql = libraryConstructor.constructCqlLibrary(libraryName, libraryVersion, expression, referencedLibraries, cqlParameters);
        HashSet<String> expressions = new HashSet<String>();
        expressions.add("return");
        EvaluationSettings requestSettings = new EvaluationSettings(this.settings);
        requestSettings.getLibrarySourceProviders().add((LibrarySourceProvider)new StringLibrarySourceProvider((List)Lists.newArrayList((Object[])new String[]{cql})));
        CqlEngine engine = Engines.forRepository(this.repository, requestSettings, bundle);
        Map<String, Object> evaluationParameters = cqlFhirParametersConverter.toCqlParameters(parameters);
        if (contextParameter != null) {
            evaluationParameters.put(fhirPathContextName, contextParameter);
            evaluationParameters.put("%resource", resourceParameter == null ? contextParameter : resourceParameter);
        }
        if (rawParameters != null) {
            evaluationParameters.putAll(rawParameters);
        }
        VersionedIdentifier id = new VersionedIdentifier().withId(libraryName).withVersion(libraryVersion);
        EvaluationResult result = engine.evaluate(id.getId(), expressions, this.buildContextParameter(patientId), evaluationParameters);
        return cqlFhirParametersConverter.toFhirParameters(result);
    }

    public List<IBase> getExpressionResult(String subjectId, String expression, String language, String libraryToBeEvaluated, Map<String, String> referencedLibraries, IBaseParameters parameters, Map<String, Object> rawParameters, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        this.validateExpression(language, expression);
        List<IBase> results = null;
        switch (language) {
            case "text/cql": 
            case "text/cql.expression": 
            case "text/cql-expression": 
            case "text/fhirpath": {
                IBaseParameters parametersResult = this.evaluateExpression(expression, parameters, rawParameters, subjectId, referencedLibraries, bundle, contextParameter, resourceParameter);
                results = this.resolveParameterValues(ParametersUtil.getNamedParameters((FhirContext)this.fhirContext, (IBaseResource)parametersResult, (String)"return"));
                break;
            }
            case "text/cql-identifier": 
            case "text/cql.identifier": 
            case "text/cql.name": 
            case "text/cql-name": {
                this.validateLibrary(libraryToBeEvaluated);
                IBaseParameters parametersResult = this.evaluate(libraryToBeEvaluated, subjectId, parameters, rawParameters, bundle, null, Collections.singleton(expression));
                results = this.resolveParameterValues(ParametersUtil.getNamedParameters((FhirContext)this.fhirContext, (IBaseResource)parametersResult, (String)expression));
                break;
            }
            default: {
                logger.warn("An action language other than CQL was found: {}", (Object)language);
            }
        }
        return results;
    }

    public void validateExpression(String language, String expression) {
        if (language == null) {
            logger.error("Missing language type for the Expression");
            throw new IllegalArgumentException("Missing language type for the Expression");
        }
        if (expression == null) {
            logger.error("Missing expression for the Expression");
            throw new IllegalArgumentException("Missing expression for the Expression");
        }
    }

    public void validateLibrary(String libraryUrl) {
        if (libraryUrl == null) {
            logger.error("Missing library for the Expression");
            throw new IllegalArgumentException("Missing library for the Expression");
        }
    }

    public List<IBase> resolveParameterValues(List<IBase> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        ArrayList<IBase> returnValues = new ArrayList<IBase>();
        switch (this.fhirContext.getVersion().getVersion()) {
            case DSTU3: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            case R4: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            case R5: {
                values.forEach(v -> {
                    Parameters.ParametersParameterComponent param = (Parameters.ParametersParameterComponent)v;
                    if (param.hasValue()) {
                        returnValues.add((IBase)param.getValue());
                    } else if (param.hasResource()) {
                        returnValues.add((IBase)param.getResource());
                    }
                });
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported FHIR version: %s".formatted(this.fhirContext));
            }
        }
        return returnValues;
    }

    public List<IBase> resolveExpression(String patientId, CqfExpression expression, IBaseParameters params, Map<String, Object> rawParameters, IBaseBundle bundle, IBase contextParameter, IBase resourceParameter) {
        List<IBase> result = this.getExpressionResult(patientId, expression.getExpression(), expression.getLanguage(), expression.getLibraryUrl(), expression.getReferencedLibraries(), params, rawParameters, bundle, contextParameter, resourceParameter);
        if (result == null && expression.getAltExpression() != null) {
            result = this.getExpressionResult(patientId, expression.getAltExpression(), expression.getAltLanguage(), expression.getAltLibraryUrl(), expression.getReferencedLibraries(), params, rawParameters, bundle, contextParameter, resourceParameter);
        }
        return result;
    }

    public EvaluationResult getEvaluationResult(VersionedIdentifier id, String patientId, IBaseParameters parameters, Map<String, Object> rawParameters, IBaseBundle additionalData, Set<String> expressions, CqlFhirParametersConverter cqlFhirParametersConverter, @Nullable ZonedDateTime zonedDateTime, CqlEngine engine) {
        if (cqlFhirParametersConverter == null) {
            cqlFhirParametersConverter = Engines.getCqlFhirParametersConverter(this.repository.fhirContext());
        }
        if (engine == null) {
            engine = Engines.forRepository(this.repository, this.settings, additionalData);
        }
        Map<String, Object> evaluationParameters = cqlFhirParametersConverter.toCqlParameters(parameters);
        if (rawParameters != null && !rawParameters.isEmpty()) {
            evaluationParameters.putAll(rawParameters);
        }
        return engine.evaluate(new VersionedIdentifier().withId(id.getId()), expressions, this.buildContextParameter(patientId), evaluationParameters, null, zonedDateTime);
    }
}

