/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.cql2elm.content;

import jakarta.xml.bind.JAXB;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import org.hl7.cql.model.ModelIdentifier;
import org.hl7.cql.model.ModelInfoProvider;
import org.hl7.elm_modelinfo.r1.ModelInfo;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.opencds.cqf.fhir.cql.cql2elm.content.ModelInfoContentType;
import org.opencds.cqf.fhir.utility.adapter.IAdapterFactory;
import org.opencds.cqf.fhir.utility.adapter.IAttachmentAdapter;
import org.opencds.cqf.fhir.utility.adapter.ILibraryAdapter;

public abstract class BaseFhirModelInfoProvider
implements ModelInfoProvider {
    protected IAdapterFactory adapterFactory;

    protected BaseFhirModelInfoProvider(IAdapterFactory adapterFactory) {
        this.adapterFactory = Objects.requireNonNull(adapterFactory, "adapterFactory can not be null");
    }

    public ModelInfo load(ModelIdentifier modelIdentifier) {
        InputStream is = this.getModelInfoContent(modelIdentifier, ModelInfoContentType.XML);
        return (ModelInfo)JAXB.unmarshal((InputStream)is, ModelInfo.class);
    }

    protected InputStream getModelInfoContent(ModelIdentifier modelIdentifier, ModelInfoContentType modelInfoContentType) {
        Objects.requireNonNull(modelIdentifier, "versionedIdentifier can not be null.");
        Objects.requireNonNull(modelInfoContentType, "modelInfoContentType can not be null.");
        IBaseResource library = this.getLibrary(modelIdentifier);
        if (library == null) {
            return null;
        }
        return this.getContentStream(library, modelInfoContentType.mimeType());
    }

    protected InputStream getContentStream(IBaseResource library, String contentType) {
        ILibraryAdapter libraryAdapter = this.adapterFactory.createLibrary(library);
        if (libraryAdapter.hasContent()) {
            for (ICompositeType attachment : libraryAdapter.getContent()) {
                IAttachmentAdapter attachmentAdapter = this.adapterFactory.createAttachment((IBase)attachment);
                if (!attachmentAdapter.getContentType().equals(contentType)) continue;
                return new ByteArrayInputStream(attachmentAdapter.getData());
            }
        }
        return null;
    }

    protected abstract IBaseResource getLibrary(ModelIdentifier var1);
}

