/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cql.engine.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.repository.IRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.BaseRetrieveProvider;
import org.opencds.cqf.fhir.cql.engine.retrieve.RetrieveSettings;
import org.opencds.cqf.fhir.utility.iterable.BundleMappingIterable;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;

public class RepositoryRetrieveProvider
extends BaseRetrieveProvider {
    private final IRepository repository;
    private final FhirContext fhirContext;

    public RepositoryRetrieveProvider(IRepository repository, TerminologyProvider terminologyProvider, RetrieveSettings settings) {
        super(repository.fhirContext(), terminologyProvider, settings);
        this.repository = Objects.requireNonNull(repository, "repository can not be null.");
        this.fhirContext = repository.fhirContext();
    }

    public Iterable<Object> retrieve(String context, String contextPath, Object contextValue, String dataType, String templateId, String codePath, Iterable<Code> codes, String valueSet, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        Class resourceType = this.fhirContext.getResourceDefinition(dataType).getImplementingClass();
        Class bt = this.fhirContext.getResourceDefinition("Bundle").getImplementingClass();
        SearchConfig config = new SearchConfig();
        this.configureTerminology(config, dataType, codePath, codes, valueSet);
        this.configureContext(config, dataType, context, contextPath, contextValue);
        this.configureProfile(config, dataType, templateId);
        this.configureDates(config, dataType, datePath, dateLowPath, dateHighPath, dateRange);
        Map<String, String> headers = this.headersForContext(context, contextValue);
        IBaseBundle resources = this.repository.search(bt, resourceType, config.searchParams, headers);
        BundleMappingIterable iter = new BundleMappingIterable(this.repository, resources, p -> p.getResource());
        return iter.toStream().filter(config.filter).collect(Collectors.toList());
    }

    private Map<String, String> headersForContext(String context, Object contextValue) {
        if (context == null || contextValue == null) {
            return Collections.emptyMap();
        }
        return Map.of("X-FHIR-Compartment", context + "/" + contextValue.toString());
    }

    private void configureProfile(SearchConfig config, String dataType, String templateId) {
        RetrieveSettings.SEARCH_FILTER_MODE mode = this.getRetrieveSettings().getSearchParameterMode();
        switch (mode) {
            case FILTER_IN_MEMORY: 
            case AUTO: {
                config.filter = config.filter.and(this.filterByTemplateId(dataType, templateId));
                break;
            }
            case USE_SEARCH_PARAMETERS: {
                this.populateTemplateSearchParams(config.searchParams, dataType, templateId);
            }
        }
    }

    private void configureContext(SearchConfig config, String dataType, String context, String contextPath, Object contextValue) {
        RetrieveSettings.SEARCH_FILTER_MODE mode = this.getRetrieveSettings().getSearchParameterMode();
        switch (mode) {
            case FILTER_IN_MEMORY: {
                config.filter = config.filter.and(this.filterByContext(dataType, context, contextPath, contextValue));
                break;
            }
            case AUTO: 
            case USE_SEARCH_PARAMETERS: {
                this.populateContextSearchParams(config.searchParams, dataType, context, contextPath, contextValue);
            }
        }
    }

    private void configureTerminology(SearchConfig config, String dataType, String codePath, Iterable<Code> codes, String valueSet) {
        RetrieveSettings.TERMINOLOGY_FILTER_MODE mode = this.getRetrieveSettings().getTerminologyParameterMode();
        switch (mode) {
            case FILTER_IN_MEMORY: {
                config.filter = config.filter.and(this.filterByTerminology(dataType, codePath, codes, valueSet));
                break;
            }
            case AUTO: 
            case USE_INLINE_CODES: 
            case USE_VALUE_SET_URL: {
                this.populateTerminologySearchParams(config.searchParams, dataType, codePath, codes, valueSet);
            }
        }
    }

    private void configureDates(SearchConfig config, String dataType, String datePath, String dateLowPath, String dateHighPath, Interval dateRange) {
        RetrieveSettings.SEARCH_FILTER_MODE mode = this.getRetrieveSettings().getSearchParameterMode();
        switch (mode) {
            case FILTER_IN_MEMORY: 
            case AUTO: {
                if (datePath == null) break;
                throw new UnsupportedOperationException("in-memory dateFilters are not supported");
            }
            case USE_SEARCH_PARAMETERS: {
                this.populateDateSearchParams(config.searchParams, dataType, datePath, dateLowPath, dateHighPath, dateRange);
            }
        }
    }

    @Override
    protected boolean inModifierSupported(String valueSet, String resourceName, String searchParamName) {
        return !(this.repository instanceof InMemoryFhirRepository) && super.inModifierSupported(valueSet, resourceName, searchParamName);
    }

    private class SearchConfig {
        public Map<String, List<IQueryParameterType>> searchParams = new HashMap<String, List<IQueryParameterType>>();
        public Predicate<IBaseResource> filter = x -> true;

        private SearchConfig() {
        }
    }
}

