/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.cql.r4;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.cql.BaseCqlExecutionProcessor;
import org.opencds.cqf.fhir.utility.r4.Parameters;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class R4CqlExecutionService {
    protected Repository repository;
    protected EvaluationSettings evaluationSettings;

    public R4CqlExecutionService(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = repository;
        this.evaluationSettings = evaluationSettings;
    }

    public org.hl7.fhir.r4.model.Parameters evaluate(String subject, String expression, org.hl7.fhir.r4.model.Parameters parameters, List<org.hl7.fhir.r4.model.Parameters> library, BooleanType useServerData, Bundle data, List<org.hl7.fhir.r4.model.Parameters> prefetchData, Endpoint dataEndpoint, Endpoint contentEndpoint, Endpoint terminologyEndpoint, String content) {
        BaseCqlExecutionProcessor baseCqlExecutionProcessor = new BaseCqlExecutionProcessor();
        if (prefetchData != null) {
            return Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[]{Parameters.part((String)"invalid parameters", (Resource)((OperationOutcome)baseCqlExecutionProcessor.createIssue("warning", "prefetchData is not yet supported", this.repository)), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])});
        }
        if (expression == null && content == null) {
            return Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[]{Parameters.part((String)"invalid parameters", (Resource)((OperationOutcome)baseCqlExecutionProcessor.createIssue("error", "The $cql operation requires the expression parameter and/or content parameter to exist", this.repository)), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])});
        }
        try {
            if (contentEndpoint != null) {
                this.repository = Repositories.proxy((Repository)this.repository, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
            }
            LibraryEngine libraryEngine = new LibraryEngine(this.repository, this.evaluationSettings);
            List<Pair<String, String>> libraries = baseCqlExecutionProcessor.resolveIncludedLibraries(library);
            if (StringUtils.isBlank((CharSequence)content)) {
                return (org.hl7.fhir.r4.model.Parameters)libraryEngine.evaluateExpression(expression, (IBaseParameters)(parameters == null ? new org.hl7.fhir.r4.model.Parameters() : parameters), subject, libraries, (IBaseBundle)data);
            }
            CqlEngine engine = Engines.forRepositoryAndSettings((EvaluationSettings)this.evaluationSettings, (Repository)this.repository, null);
            LibraryManager libraryManager = engine.getEnvironment().getLibraryManager();
            VersionedIdentifier libraryIdentifier = baseCqlExecutionProcessor.resolveLibraryIdentifier(content, null, libraryManager);
            return (org.hl7.fhir.r4.model.Parameters)libraryEngine.evaluate(libraryIdentifier, subject, (IBaseParameters)parameters, (IBaseBundle)data, expression == null ? null : Collections.singleton(expression));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Parameters.parameters((Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[]{Parameters.part((String)"evaluation error", (Resource)((OperationOutcome)baseCqlExecutionProcessor.createIssue("error", e.getMessage(), this.repository)), (Parameters.ParametersParameterComponent[])new Parameters.ParametersParameterComponent[0])});
        }
    }
}

