/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierComponentDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class R4MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    private final boolean enforceIds;

    public R4MeasureDefBuilder() {
        this(false);
    }

    public R4MeasureDefBuilder(boolean enforceIds) {
        this.enforceIds = enforceIds;
    }

    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            SdeDef sdeDef = new SdeDef(s.getId(), this.conceptToConceptDef(s.getCode()), s.getCriteria().getExpression());
            sdes.add(sdeDef);
        }
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            this.checkId((Element)group);
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Measure.MeasureGroupPopulationComponent pop : group.getPopulation()) {
                this.checkId((Element)pop);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop.getId(), this.conceptToConceptDef(pop.getCode()), populationType, pop.getCriteria().getExpression()));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            for (Measure.MeasureGroupStratifierComponent mgsc : group.getStratifier()) {
                this.checkId((Element)mgsc);
                ArrayList<StratifierComponentDef> components = new ArrayList<StratifierComponentDef>();
                for (Measure.MeasureGroupStratifierComponentComponent scc : mgsc.getComponent()) {
                    this.checkId((Element)scc);
                    StratifierComponentDef scd = new StratifierComponentDef(scc.getId(), this.conceptToConceptDef(scc.getCode()), scc.hasCriteria() ? scc.getCriteria().getExpression() : null);
                    components.add(scd);
                }
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), this.conceptToConceptDef(mgsc.getCode()), mgsc.getCriteria().getExpression(), components);
                stratifiers.add(stratifierDef);
            }
            groups.add(new GroupDef(group.getId(), this.conceptToConceptDef(group.getCode()), stratifiers, populations));
        }
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode()), groups, sdes);
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (this.enforceIds && (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId()))) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (this.enforceIds && (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId()))) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }
}

