/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4SubmitDataService {
    private static final Logger ourLogger = LoggerFactory.getLogger(R4SubmitDataService.class);
    private final Repository myRepository;

    public R4SubmitDataService(Repository theRepository) {
        this.myRepository = theRepository;
    }

    public Bundle submitData(IdType theId, MeasureReport theReport, List<IBaseResource> theResources) {
        Bundle transactionBundle = new Bundle().setType(Bundle.BundleType.TRANSACTION).addEntry(this.createEntry((IBaseResource)theReport));
        if (theResources != null) {
            for (IBaseResource res : theResources) {
                if (res instanceof Bundle) {
                    Bundle nestedBundle = (Bundle)res;
                    for (Bundle.BundleEntryComponent entry : nestedBundle.getEntry()) {
                        transactionBundle.addEntry(this.createEntry((IBaseResource)entry.getResource()));
                    }
                    continue;
                }
                transactionBundle.addEntry(this.createEntry(res));
            }
        }
        return (Bundle)this.myRepository.transaction((IBaseBundle)transactionBundle);
    }

    private Bundle.BundleEntryComponent createEntry(IBaseResource theResource) {
        return new Bundle.BundleEntryComponent().setResource((Resource)theResource).setRequest(this.createRequest(theResource));
    }

    private Bundle.BundleEntryRequestComponent createRequest(IBaseResource theResource) {
        Bundle.BundleEntryRequestComponent request = new Bundle.BundleEntryRequestComponent();
        if (theResource.getIdElement().hasValue()) {
            request.setMethod(Bundle.HTTPVerb.PUT).setUrl(theResource.getIdElement().getValue());
        } else {
            request.setMethod(Bundle.HTTPVerb.POST).setUrl(theResource.fhirType());
        }
        return request;
    }
}

