/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverterFactory;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.plandefinition.OperationParametersParser;
import org.opencds.cqf.fhir.utility.repository.Repositories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePlanDefinitionProcessor<T> {
    private static final Logger logger = LoggerFactory.getLogger(BasePlanDefinitionProcessor.class);
    protected static final List<String> EXCLUDED_EXTENSION_LIST = Arrays.asList("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeCapability", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeRepresentationLevel", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-questionnaire-generate", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-logicDefinition", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-effectiveDataRequirements");
    protected final OperationParametersParser operationParametersParser;
    protected final ModelResolver modelResolver;
    protected Repository repository;
    protected LibraryEngine libraryEngine;
    protected EvaluationSettings evaluationSettings;
    protected String subjectId;
    protected String encounterId;
    protected String practitionerId;
    protected String organizationId;
    protected IBaseDatatype userType;
    protected IBaseDatatype userLanguage;
    protected IBaseDatatype userTaskContext;
    protected IBaseDatatype setting;
    protected IBaseDatatype settingContext;
    protected IBaseParameters parameters;
    protected Boolean useServerData;
    protected IBaseBundle bundle;
    protected IBaseParameters prefetchData;
    protected Boolean containResources;
    protected IBaseResource questionnaire;
    protected Collection<IBaseResource> requestResources;
    protected Collection<IBaseResource> extractedResources;

    protected BasePlanDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.operationParametersParser = new OperationParametersParser(Engines.getAdapterFactory((FhirContext)this.fhirContext()), new FhirTypeConverterFactory().create(this.fhirVersion()));
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)repository.fhirContext().getVersion().getVersion());
    }

    public static <T extends IBase> Optional<T> castOrThrow(IBase obj, Class<T> type, String errorMessage) {
        if (obj == null) {
            return Optional.empty();
        }
        if (type.isInstance(obj)) {
            return Optional.of((IBase)type.cast(obj));
        }
        throw new IllegalArgumentException(errorMessage);
    }

    public FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    public FhirVersionEnum fhirVersion() {
        return this.fhirContext().getVersion().getVersion();
    }

    public abstract <CanonicalType extends IPrimitiveType<String>> T resolvePlanDefinition(IIdType var1, CanonicalType var2, IBaseResource var3);

    public abstract T initApply(T var1);

    public abstract IBaseResource applyPlanDefinition(T var1);

    public abstract IBaseResource transformToCarePlan(IBaseResource var1);

    public abstract IBaseResource transformToBundle(IBaseResource var1);

    protected abstract void extractQuestionnaireResponse();

    protected abstract void addOperationOutcomeIssue(String var1);

    public abstract IBaseBundle packagePlanDefinition(T var1, boolean var2);

    public IBaseBundle packagePlanDefinition(T planDefinition) {
        return this.packagePlanDefinition(planDefinition, false);
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseBundle packagePlanDefinition(IIdType id, CanonicalType canonical, IBaseResource planDefinition, boolean isPut) {
        return this.packagePlanDefinition(this.resolvePlanDefinition(id, canonical, planDefinition), isPut);
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource apply(IIdType id, CanonicalType canonical, IBaseResource planDefinition, String subject, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext) {
        return this.apply(id, canonical, planDefinition, this.subjectId, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, null, true, null, null, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource apply(IIdType id, CanonicalType canonical, IBaseResource planDefinition, String subject, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        this.repository = Repositories.proxy((Repository)this.repository, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        return this.apply(id, canonical, planDefinition, subject, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource apply(IIdType id, CanonicalType canonical, IBaseResource planDefinition, String subject, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, LibraryEngine libraryEngine) {
        if (this.fhirVersion() == FhirVersionEnum.R5) {
            return this.applyR5(id, canonical, planDefinition, subject, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, libraryEngine);
        }
        this.subjectId = subject;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        this.useServerData = useServerData;
        this.bundle = bundle;
        this.prefetchData = prefetchData;
        this.libraryEngine = libraryEngine;
        this.containResources = true;
        this.requestResources = new ArrayList<IBaseResource>();
        this.extractedResources = new ArrayList<IBaseResource>();
        return this.transformToCarePlan(this.applyPlanDefinition(this.initApply(this.resolvePlanDefinition(id, canonical, planDefinition))));
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource applyR5(IIdType id, CanonicalType canonical, IBaseResource planDefinition, String patientId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        this.repository = Repositories.proxy((Repository)this.repository, (IBaseResource)dataEndpoint, (IBaseResource)contentEndpoint, (IBaseResource)terminologyEndpoint);
        return this.applyR5(id, canonical, planDefinition, patientId, encounterId, practitionerId, organizationId, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <CanonicalType extends IPrimitiveType<String>> IBaseResource applyR5(IIdType id, CanonicalType canonical, IBaseResource planDefinition, String patientId, String encounterId, String practitionerId, String organizationId, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, LibraryEngine libraryEngine) {
        this.subjectId = patientId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        this.organizationId = organizationId;
        this.userType = userType;
        this.userLanguage = userLanguage;
        this.userTaskContext = userTaskContext;
        this.setting = setting;
        this.settingContext = settingContext;
        this.parameters = parameters;
        this.useServerData = useServerData;
        this.bundle = bundle;
        this.prefetchData = prefetchData;
        this.libraryEngine = libraryEngine;
        this.containResources = false;
        this.requestResources = new ArrayList<IBaseResource>();
        this.extractedResources = new ArrayList<IBaseResource>();
        return this.transformToBundle(this.applyPlanDefinition(this.initApply(this.resolvePlanDefinition(id, canonical, planDefinition))));
    }

    protected void resolveDynamicValue(List<IBase> result, String path, IElement requestAction, IBase resource) {
        IBase value;
        if (result == null || result.isEmpty()) {
            return;
        }
        path = path.replace("%", "");
        IBase iBase = value = result.size() == 1 ? result.get(0) : result;
        if (path.startsWith("activity.extension") || path.startsWith("action.extension")) {
            if (this.repository.fhirContext().getVersion().getVersion() != FhirVersionEnum.DSTU3) {
                throw new IllegalArgumentException("Please use the priority path when setting indicator values when using FHIR R4 or higher for CDS Hooks evaluation");
            }
            ((Element)requestAction).addExtension().setValue((Type)value);
        } else if (path.startsWith("action.") || resource == null) {
            this.modelResolver.setValue((Object)requestAction, path.replace("action.", ""), (Object)value);
        } else {
            this.modelResolver.setValue((Object)resource, path, (Object)value);
        }
    }
}

