/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.prepopulate;

import ca.uhn.fhir.util.ExtensionUtil;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.opencds.cqf.fhir.cql.CqfExpression;

class PrePopulateHelper {
    PrePopulateHelper() {
    }

    CqfExpression getExpressionByExtension(Questionnaire questionnaire, Questionnaire.QuestionnaireItemComponent item, String extensionUrl) {
        Extension extension = item.getExtensionByUrl(extensionUrl);
        IBaseExtension languageExtension = ExtensionUtil.getExtensionByUrl((IBase)item, (String)"http://hl7.org/fhir/StructureDefinition/cqf-expression-language");
        return new CqfExpression(languageExtension.getValue().toString(), extension.getValue().toString(), this.getLibraryUrl(questionnaire));
    }

    private String getLibraryUrl(Questionnaire questionnaire) {
        return questionnaire.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-library") ? (String)((UriType)questionnaire.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library").getValue()).getValue() : null;
    }
}

