/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r4.processor.prepopulate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.cr.questionnaire.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.questionnaire.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.r4.processor.prepopulate.ExpressionProcessor;

public class PrePopulateItemWithExtension {
    private final ExpressionProcessor expressionProcessor;

    public PrePopulateItemWithExtension() {
        this(new ExpressionProcessor());
    }

    private PrePopulateItemWithExtension(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    List<Questionnaire.QuestionnaireItemComponent> processItem(PrePopulateRequest prePopulateRequest, Questionnaire.QuestionnaireItemComponent questionnaireItem, Questionnaire questionnaire) throws ResolveExpressionException {
        Expression contextExpression = (Expression)questionnaireItem.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext").getValue();
        List<IBase> populationContext = this.expressionProcessor.getExpressionResult(prePopulateRequest, contextExpression, questionnaireItem.getLinkId(), questionnaire);
        return populationContext.stream().map(context -> this.processPopulationContext(questionnaireItem, (IBase)context)).collect(Collectors.toList());
    }

    Questionnaire.QuestionnaireItemComponent processPopulationContext(Questionnaire.QuestionnaireItemComponent questionnaireGroupItem, IBase context) {
        Questionnaire.QuestionnaireItemComponent contextItem = this.copyItemWithNoSubItems(questionnaireGroupItem);
        questionnaireGroupItem.getItem().forEach(item -> {
            Questionnaire.QuestionnaireItemComponent processedSubItem = this.createNewQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)item, context);
            contextItem.addItem(processedSubItem);
        });
        return contextItem;
    }

    Questionnaire.QuestionnaireItemComponent createNewQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent questionnaireItem, IBase context) {
        Questionnaire.QuestionnaireItemComponent item = questionnaireItem.copy();
        String path = item.getDefinition().split("#")[1].split("\\.")[1];
        Property initialProperty = ((Base)context).getNamedProperty(path);
        if (initialProperty.hasValues() && !initialProperty.isList()) {
            Type initialValue = ItemValueTransformer.transformValue((Type)initialProperty.getValues().get(0));
            item.addExtension(ExtensionBuilders.buildR4(ExtensionBuilders.QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION));
            item.addInitial(new Questionnaire.QuestionnaireItemInitialComponent().setValue(initialValue));
        }
        return item;
    }

    Questionnaire.QuestionnaireItemComponent copyItemWithNoSubItems(Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        Questionnaire.QuestionnaireItemComponent questionnaireItemComponent = questionnaireItem.copy();
        questionnaireItemComponent.setItem(new ArrayList());
        return questionnaireItemComponent;
    }
}

