/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem;

import java.util.List;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.ValueSet;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionnaireTypeIsChoice {
    protected static final Logger logger = LoggerFactory.getLogger(QuestionnaireTypeIsChoice.class);
    protected Repository repository;

    public static QuestionnaireTypeIsChoice of(Repository repository) {
        return new QuestionnaireTypeIsChoice(repository);
    }

    QuestionnaireTypeIsChoice(Repository repository) {
        this.repository = repository;
    }

    public Questionnaire.QuestionnaireItemComponent addProperties(ElementDefinition element, Questionnaire.QuestionnaireItemComponent item) {
        ValueSet valueSet = this.getValueSet(element);
        if (valueSet.hasExpansion()) {
            this.addAnswerOptionsForValueSetWithExpansionComponent(valueSet, item);
        } else {
            this.addAnswerOptionsForValueSetWithComposeComponent(valueSet, item);
        }
        return item;
    }

    protected void addAnswerOptionsForValueSetWithExpansionComponent(ValueSet valueSet, Questionnaire.QuestionnaireItemComponent item) {
        List expansionList = valueSet.getExpansion().getContains();
        expansionList.forEach(expansion -> {
            Coding coding = this.getCoding((ValueSet.ValueSetExpansionContainsComponent)expansion);
            item.addAnswerOption().setValue((DataType)coding);
        });
    }

    protected void addAnswerOptionsForValueSetWithComposeComponent(ValueSet valueSet, Questionnaire.QuestionnaireItemComponent item) {
        List systems = valueSet.getCompose().getInclude();
        systems.forEach(system -> system.getConcept().forEach(concept -> {
            Coding coding = this.getCoding((ValueSet.ConceptReferenceComponent)concept, system.getSystem());
            item.addAnswerOption().setValue((DataType)coding);
        }));
    }

    protected Coding getCoding(ValueSet.ConceptReferenceComponent code, String systemUri) {
        return new Coding().setCode(code.getCode()).setSystem(systemUri).setDisplay(code.getDisplay());
    }

    protected Coding getCoding(ValueSet.ValueSetExpansionContainsComponent code) {
        return new Coding().setCode(code.getCode()).setSystem(code.getSystem()).setDisplay(code.getDisplay());
    }

    protected ValueSet getValueSet(ElementDefinition element) {
        String valueSetUrl = element.getBinding().getValueSet();
        return (ValueSet)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)new CanonicalType().setValue((Object)valueSetUrl));
    }
}

