/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseQuestionnaireResponseProcessor<T> {
    protected static final Logger logger = LoggerFactory.getLogger(BaseQuestionnaireResponseProcessor.class);
    protected final EvaluationSettings evaluationSettings;
    protected final ModelResolver modelResolver;
    protected Repository repository;
    protected LibraryEngine libraryEngine;
    protected String patientId;
    protected IBaseParameters parameters;
    protected IBaseBundle bundle;
    protected String libraryUrl;
    protected static final String subjectType = "Patient";

    protected BaseQuestionnaireResponseProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion());
    }

    public FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    public FhirVersionEnum fhirVersion() {
        return this.fhirContext().getVersion().getVersion();
    }

    public static <T extends IBase> Optional<T> castOrThrow(IBase obj, Class<T> type, String errorMessage) {
        if (obj == null) {
            return Optional.empty();
        }
        if (type.isInstance(obj)) {
            return Optional.of((IBase)type.cast(obj));
        }
        throw new IllegalArgumentException(errorMessage);
    }

    protected abstract IBaseBundle createResourceBundle(T var1, List<IBaseResource> var2);

    public abstract List<IBaseResource> processItems(T var1);

    public abstract T resolveQuestionnaireResponse(IIdType var1, IBaseResource var2);

    protected abstract void setup(T var1);

    public IBaseBundle extract(IIdType id, IBaseResource questionnaireResponse, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        return this.extract(this.resolveQuestionnaireResponse(id, questionnaireResponse), parameters, bundle, libraryEngine == null ? new LibraryEngine(this.repository, this.evaluationSettings) : libraryEngine);
    }

    public IBaseBundle extract(T questionnaireResponse, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        if (questionnaireResponse == null) {
            String message = "Unable to perform operation $extract.  The QuestionnaireResponse was null";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
        this.setup(questionnaireResponse);
        List<IBaseResource> resources = this.processItems(questionnaireResponse);
        return this.createResourceBundle(questionnaireResponse, resources);
    }

    protected String getExtractId(T questionnaireResponse) {
        return "extract-" + ((IBaseResource)questionnaireResponse).getIdElement().getIdPart();
    }
}

