/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.r5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.ExtensionResolver;
import org.opencds.cqf.fhir.cr.activitydefinition.BaseActivityDefinitionProcessor;
import org.opencds.cqf.fhir.utility.r5.InputParameterResolver;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDefinitionProcessor
extends BaseActivityDefinitionProcessor<ActivityDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(ActivityDefinitionProcessor.class);
    protected InputParameterResolver inputParameterResolver;

    public ActivityDefinitionProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public ActivityDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        super(repository, evaluationSettings);
    }

    @Override
    public <C extends IPrimitiveType<String>> ActivityDefinition resolveActivityDefinition(IIdType id, C canonical, IBaseResource activityDefinition) throws FHIRException {
        IBaseResource baseActivityDefinition = activityDefinition;
        if (baseActivityDefinition == null) {
            baseActivityDefinition = id != null ? this.repository.read(ActivityDefinition.class, id) : (ActivityDefinition)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, canonical);
        }
        Objects.requireNonNull(baseActivityDefinition, "Couldn't find ActivityDefinition " + String.valueOf(id));
        return ActivityDefinitionProcessor.castOrThrow((IBase)baseActivityDefinition, ActivityDefinition.class, "The activityDefinition passed in was not a valid instance of ActivityDefinition.class").orElse(null);
    }

    @Override
    protected ActivityDefinition initApply(ActivityDefinition activityDefinition) {
        logger.info("Performing $apply operation on {}", (Object)activityDefinition.getId());
        this.inputParameterResolver = new InputParameterResolver(this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.useServerData, this.bundle, this.repository);
        this.extensionResolver = new ExtensionResolver(this.subjectId, (IBaseParameters)this.inputParameterResolver.getParameters(), this.bundle, this.libraryEngine);
        return activityDefinition;
    }

    @Override
    public IBaseResource applyActivityDefinition(ActivityDefinition activityDefinition) {
        DomainResource result;
        try {
            result = (DomainResource)Class.forName("org.hl7.fhir.r5.model." + activityDefinition.getKind().toCode()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException("Could not find org.hl7.fhir.r5.model." + activityDefinition.getKind().toCode());
        }
        switch (result.fhirType()) {
            case "ServiceRequest": {
                result = this.resolveServiceRequest(activityDefinition);
                break;
            }
            case "MedicationRequest": {
                result = this.resolveMedicationRequest(activityDefinition);
                break;
            }
            case "SupplyRequest": {
                result = this.resolveSupplyRequest(activityDefinition);
                break;
            }
            case "Procedure": {
                result = this.resolveProcedure(activityDefinition);
                break;
            }
            case "DiagnosticReport": {
                result = this.resolveDiagnosticReport(activityDefinition);
                break;
            }
            case "Communication": {
                result = this.resolveCommunication(activityDefinition);
                break;
            }
            case "CommunicationRequest": {
                result = this.resolveCommunicationRequest(activityDefinition);
                break;
            }
            case "Task": {
                result = this.resolveTask(activityDefinition);
                break;
            }
            default: {
                String msg = "Unsupported activity type: " + result.fhirType();
                logger.error(msg);
                throw new FHIRException(msg);
            }
        }
        this.resolveMeta(result, activityDefinition);
        String defaultLibraryUrl = activityDefinition.hasLibrary() ? ((CanonicalType)activityDefinition.getLibrary().get(0)).getValueAsString() : null;
        this.resolveExtensions(result, activityDefinition, defaultLibraryUrl);
        Parameters inputParams = this.inputParameterResolver.getParameters();
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent dynamicValue : activityDefinition.getDynamicValue()) {
            if (!dynamicValue.hasExpression()) continue;
            Expression expression = dynamicValue.getExpression();
            List expressionResult = this.libraryEngine.resolveExpression(this.subjectId, new CqfExpression(expression.getLanguage(), expression.getExpression(), expression.hasReference() ? expression.getReference() : defaultLibraryUrl), (IBaseParameters)inputParams, this.bundle);
            this.resolveDynamicValue(expressionResult, expression.getExpression(), dynamicValue.getPath(), (IBaseResource)result);
        }
        return result;
    }

    private void resolveMeta(DomainResource resource, ActivityDefinition activityDefinition) {
        Meta meta = new Meta();
        if (activityDefinition.hasProfile()) {
            meta.addProfile(activityDefinition.getProfile());
            resource.setMeta(meta);
        }
    }

    private void resolveExtensions(DomainResource resource, ActivityDefinition activityDefinition, String defaultLibraryUrl) {
        if (activityDefinition.hasExtension()) {
            resource.setExtension(activityDefinition.getExtension().stream().filter(e -> !EXCLUDED_EXTENSION_LIST.contains(e.getUrl())).collect(Collectors.toList()));
            this.extensionResolver.resolveExtensions(resource.getExtension(), defaultLibraryUrl);
        }
    }

    private Task resolveTask(ActivityDefinition activityDefinition) {
        Task task = new Task();
        if (activityDefinition.hasExtension("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus")) {
            DataType value = activityDefinition.getExtensionByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus").getValue();
            if (value instanceof StringType) {
                task.setStatus(Task.TaskStatus.valueOf((String)((StringType)value).asStringValue().toUpperCase()));
            } else {
                logger.debug("Extension {} should have a value of type {}", (Object)"http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus", (Object)StringType.class.getName());
            }
        } else {
            task.setStatus(Task.TaskStatus.DRAFT);
        }
        task.setIntent(activityDefinition.hasIntent() ? Task.TaskIntent.fromCode((String)activityDefinition.getIntent().toCode()) : Task.TaskIntent.PROPOSAL);
        if (activityDefinition.hasUrl()) {
            task.setInstantiatesCanonical(activityDefinition.getUrl());
        }
        if (activityDefinition.hasCode()) {
            task.setCode(activityDefinition.getCode());
        }
        if (activityDefinition.hasExtension()) {
            task.setExtension(activityDefinition.getExtension());
        }
        if (activityDefinition.hasDescription()) {
            task.setDescription(activityDefinition.getDescription());
        }
        return task;
    }

    private ServiceRequest resolveServiceRequest(ActivityDefinition activityDefinition) {
        ServiceRequest serviceRequest = new ServiceRequest();
        serviceRequest.setStatus(Enumerations.RequestStatus.DRAFT);
        serviceRequest.setIntent(activityDefinition.hasIntent() ? Enumerations.RequestIntent.fromCode((String)activityDefinition.getIntent().toCode()) : Enumerations.RequestIntent.ORDER);
        serviceRequest.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            serviceRequest.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(activityDefinition.getUrl())));
        }
        if (this.practitionerId != null) {
            serviceRequest.setRequester(new Reference(this.practitionerId));
        } else if (this.organizationId != null) {
            serviceRequest.setRequester(new Reference(this.organizationId));
        }
        if (activityDefinition.hasExtension()) {
            serviceRequest.setExtension(activityDefinition.getExtension());
        }
        if (activityDefinition.hasCode()) {
            serviceRequest.setCode(new CodeableReference(activityDefinition.getCode()));
        } else if (!activityDefinition.hasCode() && !activityDefinition.hasDynamicValue()) {
            throw new FHIRException("Missing required code property");
        }
        if (activityDefinition.hasBodySite()) {
            serviceRequest.setBodySite(activityDefinition.getBodySite());
        }
        if (activityDefinition.hasDoNotPerform()) {
            serviceRequest.setDoNotPerform(activityDefinition.getDoNotPerform());
        }
        if (activityDefinition.hasProduct()) {
            throw new FHIRException("Product does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        if (activityDefinition.hasDosage()) {
            throw new FHIRException("Dosage does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        return serviceRequest;
    }

    private MedicationRequest resolveMedicationRequest(ActivityDefinition activityDefinition) {
        MedicationRequest medicationRequest = new MedicationRequest();
        medicationRequest.setStatus(MedicationRequest.MedicationrequestStatus.DRAFT);
        medicationRequest.setIntent(activityDefinition.hasIntent() ? MedicationRequest.MedicationRequestIntent.fromCode((String)activityDefinition.getIntent().toCode()) : MedicationRequest.MedicationRequestIntent.ORDER);
        medicationRequest.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasProductCodeableConcept()) {
            medicationRequest.setMedication(new CodeableReference(activityDefinition.getProductCodeableConcept()));
        } else if (activityDefinition.hasProductReference()) {
            medicationRequest.setMedication(new CodeableReference(activityDefinition.getProductReference()));
        } else {
            throw new FHIRException("Missing required code property");
        }
        if (activityDefinition.hasDosage()) {
            activityDefinition.getDosage().forEach(arg_0 -> ((MedicationRequest)medicationRequest).addDosageInstruction(arg_0));
        }
        if (activityDefinition.hasDoNotPerform()) {
            medicationRequest.setDoNotPerform(activityDefinition.getDoNotPerform());
        }
        if (activityDefinition.hasBodySite()) {
            throw new FHIRException("BodySite does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        if (activityDefinition.hasCode()) {
            throw new FHIRException("Code does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        if (activityDefinition.hasQuantity()) {
            throw new FHIRException("Quantity does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        return medicationRequest;
    }

    private SupplyRequest resolveSupplyRequest(ActivityDefinition activityDefinition) {
        SupplyRequest supplyRequest = new SupplyRequest();
        supplyRequest.setStatus(SupplyRequest.SupplyRequestStatus.DRAFT);
        if (this.practitionerId != null) {
            supplyRequest.setRequester(new Reference(this.practitionerId));
        }
        if (this.organizationId != null) {
            supplyRequest.setRequester(new Reference(this.organizationId));
        }
        if (!activityDefinition.hasQuantity()) {
            throw new FHIRException("Missing required orderedItem.quantity property");
        }
        supplyRequest.setQuantity(activityDefinition.getQuantity());
        if (activityDefinition.hasCode()) {
            supplyRequest.setItem(new CodeableReference(activityDefinition.getCode()));
        }
        if (activityDefinition.hasProduct()) {
            throw new FHIRException("Product does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        if (activityDefinition.hasDosage()) {
            throw new FHIRException("Dosage does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        if (activityDefinition.hasBodySite()) {
            throw new FHIRException("BodySite does not map to " + String.valueOf(activityDefinition.getKind()));
        }
        return supplyRequest;
    }

    private Procedure resolveProcedure(ActivityDefinition activityDefinition) {
        Procedure procedure = new Procedure();
        procedure.setStatus(Enumerations.EventStatus.UNKNOWN);
        procedure.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            procedure.setInstantiatesCanonical(Collections.singletonList(new CanonicalType(activityDefinition.getUrl())));
        }
        if (activityDefinition.hasCode()) {
            procedure.setCode(activityDefinition.getCode());
        }
        if (activityDefinition.hasBodySite()) {
            procedure.setBodySite(activityDefinition.getBodySite());
        }
        return procedure;
    }

    private DiagnosticReport resolveDiagnosticReport(ActivityDefinition activityDefinition) {
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        diagnosticReport.setStatus(DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
        diagnosticReport.setSubject(new Reference(this.subjectId));
        if (!activityDefinition.hasCode()) {
            throw new FHIRException("Missing required ActivityDefinition.code property for DiagnosticReport");
        }
        diagnosticReport.setCode(activityDefinition.getCode());
        if (activityDefinition.hasRelatedArtifact()) {
            ArrayList<Attachment> presentedFormAttachments = new ArrayList<Attachment>();
            for (RelatedArtifact artifact : activityDefinition.getRelatedArtifact()) {
                Attachment attachment = new Attachment();
                if (artifact.hasResourceElement()) {
                    attachment.setUrl((String)artifact.getResourceElement().getValue());
                }
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                presentedFormAttachments.add(attachment);
            }
            diagnosticReport.setPresentedForm(presentedFormAttachments);
        }
        return diagnosticReport;
    }

    private Communication resolveCommunication(ActivityDefinition activityDefinition) {
        Communication communication = new Communication();
        communication.setStatus(Enumerations.EventStatus.UNKNOWN);
        communication.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasCode()) {
            communication.setReason(Collections.singletonList(new CodeableReference(activityDefinition.getCode())));
        }
        if (activityDefinition.hasRelatedArtifact()) {
            for (RelatedArtifact artifact : activityDefinition.getRelatedArtifact()) {
                if (!artifact.hasResourceElement()) continue;
                Attachment attachment = new Attachment().setUrl((String)artifact.getResourceElement().getValue());
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                Communication.CommunicationPayloadComponent payload = new Communication.CommunicationPayloadComponent();
                payload.setContent((DataType)(artifact.hasDisplay() ? attachment.setTitle(artifact.getDisplay()) : attachment));
                communication.setPayload(Collections.singletonList(payload));
            }
        }
        return communication;
    }

    private CommunicationRequest resolveCommunicationRequest(ActivityDefinition activityDefinition) {
        CommunicationRequest communicationRequest = new CommunicationRequest();
        communicationRequest.setStatus(Enumerations.RequestStatus.DRAFT);
        communicationRequest.setSubject(new Reference(this.subjectId));
        if (this.encounterId != null && !this.encounterId.isEmpty()) {
            communicationRequest.setEncounter(new Reference(this.encounterId));
        }
        if (this.practitionerId != null && !this.practitionerId.isEmpty()) {
            communicationRequest.setRequester(new Reference(this.practitionerId));
        }
        if (activityDefinition.hasDoNotPerform()) {
            communicationRequest.setDoNotPerform(activityDefinition.getDoNotPerform());
        }
        if (activityDefinition.hasCode() && activityDefinition.getCode().hasText()) {
            communicationRequest.addPayload().setContent((DataType)new StringType(activityDefinition.getCode().getText()));
        }
        return communicationRequest;
    }
}

