/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum MeasureEvalType {
    SUBJECT("subject", "Subject", "An evaluation generating an individual report that provides information on the performance for a given measure with respect to a single subject"),
    SUBJECTLIST("subject-list", "Subject List", "An evaluation generating a subject list report that includes a listing of subjects that satisfied each population criteria in the measure."),
    PATIENT("patient", "Patient", "An evaluation generating an individual report that provides information on the performance for a given measure with respect to a single patient"),
    PATIENTLIST("patient-list", "Patient List", "An evaluation generating a patient list report that includes a listing of patients that satisfied each population criteria in the measure"),
    POPULATION("population", "Population", "An evaluation generating a summary report that returns the number of subjects in each population criteria for the measure");

    private String code;
    private String display;
    private String definition;
    private static final Map<String, MeasureEvalType> lookup;

    private MeasureEvalType(String code, String display, String definition) {
        this.code = code;
        this.display = display;
        this.definition = definition;
    }

    public static Optional<MeasureEvalType> fromCode(String code) {
        return Optional.ofNullable(lookup.get(code));
    }

    public String getSystem() {
        return null;
    }

    public String toCode() {
        return this.code;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getDefinition() {
        return this.definition;
    }

    static {
        lookup = new HashMap<String, MeasureEvalType>();
        for (MeasureEvalType mpt : MeasureEvalType.values()) {
            lookup.put(mpt.toCode(), mpt);
        }
    }
}

