/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Resource;
import org.opencds.cqf.fhir.cr.measure.common.CodeDef;
import org.opencds.cqf.fhir.cr.measure.common.ConceptDef;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDefBuilder;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;

public class Dstu3MeasureDefBuilder
implements MeasureDefBuilder<Measure> {
    private final boolean enforceIds;

    public Dstu3MeasureDefBuilder() {
        this(false);
    }

    public Dstu3MeasureDefBuilder(boolean enforceIds) {
        this.enforceIds = enforceIds;
    }

    @Override
    public MeasureDef build(Measure measure) {
        this.checkId((Resource)measure);
        ArrayList<SdeDef> sdes = new ArrayList<SdeDef>();
        for (Measure.MeasureSupplementalDataComponent s : measure.getSupplementalData()) {
            this.checkId((Element)s);
            SdeDef sdeDef = new SdeDef(s.getId(), null, s.getCriteria());
            sdes.add(sdeDef);
        }
        MeasureScoring groupMeasureScoringCode = this.getMeasureScoring(measure);
        if (groupMeasureScoringCode == null) {
            throw new IllegalStateException("MeasureScoring must be specified on Measure");
        }
        ArrayList<GroupDef> groups = new ArrayList<GroupDef>();
        HashMap<GroupDef, MeasureScoring> groupMeasureScoring = new HashMap<GroupDef, MeasureScoring>();
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            Object pop2;
            this.checkId((Element)group);
            ArrayList<PopulationDef> populations = new ArrayList<PopulationDef>();
            for (Object pop2 : group.getPopulation()) {
                this.checkId((Element)pop2);
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop2.getCode().getCodingFirstRep().getCode());
                populations.add(new PopulationDef(pop2.getId(), this.conceptToConceptDef(pop2.getCode()), populationType, pop2.getCriteria()));
            }
            ArrayList<StratifierDef> stratifiers = new ArrayList<StratifierDef>();
            pop2 = group.getStratifier().iterator();
            while (pop2.hasNext()) {
                Measure.MeasureGroupStratifierComponent mgsc = (Measure.MeasureGroupStratifierComponent)pop2.next();
                this.checkId((Element)mgsc);
                StratifierDef stratifierDef = new StratifierDef(mgsc.getId(), null, mgsc.getCriteria());
                stratifiers.add(stratifierDef);
            }
            GroupDef groupDef = new GroupDef(group.getId(), null, stratifiers, populations);
            groups.add(groupDef);
            groupMeasureScoring.put(groupDef, groupMeasureScoringCode);
        }
        return new MeasureDef(measure.getId(), measure.getUrl(), measure.getVersion(), groupMeasureScoring, groups, sdes);
    }

    private ConceptDef conceptToConceptDef(CodeableConcept codeable) {
        if (codeable == null) {
            return null;
        }
        ArrayList<CodeDef> codes = new ArrayList<CodeDef>();
        for (Coding c : codeable.getCoding()) {
            codes.add(this.codeToCodeDef(c));
        }
        return new ConceptDef(codes, codeable.getText());
    }

    private CodeDef codeToCodeDef(Coding coding) {
        return new CodeDef(coding.getSystem(), coding.getVersion(), coding.getCode(), coding.getDisplay());
    }

    private void checkId(Element e) {
        if (this.enforceIds && (e.getId() == null || StringUtils.isBlank((CharSequence)e.getId()))) {
            throw new NullPointerException("id is required on all Elements of type: " + e.fhirType());
        }
    }

    private void checkId(Resource r) {
        if (this.enforceIds && (r.getId() == null || StringUtils.isBlank((CharSequence)r.getId()))) {
            throw new NullPointerException("id is required on all Resources of type: " + r.fhirType());
        }
    }

    private MeasureScoring getMeasureScoring(Measure measure) {
        return MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode());
    }
}

