/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Quantity;
import org.opencds.cqf.fhir.cr.measure.common.BaseMeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;

public class R4MeasureReportScorer
extends BaseMeasureReportScorer<MeasureReport> {
    @Override
    public void score(Map<GroupDef, MeasureScoring> measureScoring, MeasureReport measureReport) {
        for (MeasureReport.MeasureReportGroupComponent mrgc : measureReport.getGroup()) {
            this.scoreGroup(this.getGroupMeasureScoring(mrgc, measureScoring), mrgc);
        }
    }

    protected MeasureScoring getGroupMeasureScoring(MeasureReport.MeasureReportGroupComponent mrgc, Map<GroupDef, MeasureScoring> measureScoring) {
        MeasureScoring measureScoringFromGroup = null;
        for (Map.Entry<GroupDef, MeasureScoring> entry : measureScoring.entrySet()) {
            if (measureScoring.size() == 1) {
                measureScoringFromGroup = entry.getValue();
                break;
            }
            if (mrgc.getId() != null && entry.getKey().id() != null && entry.getKey().id().equals(mrgc.getId())) {
                measureScoringFromGroup = entry.getValue();
                break;
            }
            if (mrgc.getPopulation().size() != entry.getKey().populations().size()) continue;
            int i = 0;
            block1: for (MeasureReport.MeasureReportGroupPopulationComponent popId : mrgc.getPopulation()) {
                for (PopulationDef popDefEntry : entry.getKey().populations()) {
                    if (!popId.getId().equals(popDefEntry.id())) continue;
                    ++i;
                    continue block1;
                }
            }
            if (i != mrgc.getPopulation().size()) continue;
            measureScoringFromGroup = entry.getValue();
        }
        if (measureScoringFromGroup == null) {
            throw new IllegalStateException("No MeasureScoring value set");
        }
        return measureScoringFromGroup;
    }

    protected void scoreGroup(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupComponent mrgc) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getPopulationCount(mrgc, MeasurePopulationType.NUMERATOR), this.getPopulationCount(mrgc, MeasurePopulationType.DENOMINATOR));
                if (score == null) break;
                mrgc.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent : mrgc.getStratifier()) {
            this.scoreStratifier(measureScoring, stratifierComponent);
        }
    }

    protected void scoreStratum(MeasureScoring measureScoring, MeasureReport.StratifierGroupComponent stratum) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getPopulationCount(stratum, MeasurePopulationType.NUMERATOR), this.getPopulationCount(stratum, MeasurePopulationType.DENOMINATOR));
                if (score == null) break;
                stratum.setMeasureScore(new Quantity(score.doubleValue()));
                break;
            }
        }
    }

    protected Integer getPopulationCount(MeasureReport.MeasureReportGroupComponent mrgc, MeasurePopulationType populationType) {
        Optional<MeasureReport.MeasureReportGroupPopulationComponent> pop = mrgc.getPopulation().stream().filter(x -> x.getCode().getCodingFirstRep().getCode().equals(populationType.toCode())).findFirst();
        if (pop.isPresent()) {
            return pop.get().getCount();
        }
        return null;
    }

    protected Integer getPopulationCount(MeasureReport.StratifierGroupComponent sgc, MeasurePopulationType populationType) {
        Optional<MeasureReport.StratifierGroupPopulationComponent> pop = sgc.getPopulation().stream().filter(x -> x.getCode().getCodingFirstRep().getCode().equals(populationType.toCode())).findFirst();
        if (pop.isPresent()) {
            return pop.get().getCount();
        }
        return null;
    }

    protected void scoreStratifier(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent) {
        for (MeasureReport.StratifierGroupComponent sgc : stratifierComponent.getStratum()) {
            this.scoreStratum(measureScoring, sgc);
        }
    }
}

