/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor;

import java.util.Objects;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.questionnaire.BaseQuestionnaireProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.PackageProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.PopulateProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.ResolveProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.prepopulate.PrePopulateProcessor;

public class QuestionnaireProcessor
extends BaseQuestionnaireProcessor<Questionnaire> {
    private PopulateProcessor populateProcessor;
    private ResolveProcessor resolveProcessor;
    private PackageProcessor packageProcessor;
    private PrePopulateProcessor prePopulateProcessor;
    private GenerateProcessor generateProcessor;

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, new ResolveProcessor(repository), new PackageProcessor(repository), new PopulateProcessor(), new PrePopulateProcessor(), new GenerateProcessor());
    }

    public QuestionnaireProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings, ResolveProcessor resolveProcessor, PackageProcessor packageProcessor, PopulateProcessor populateProcessor, PrePopulateProcessor prePopulateProcessor, GenerateProcessor generateProcessor) {
        super(repository, evaluationSettings);
        this.resolveProcessor = resolveProcessor;
        this.packageProcessor = packageProcessor;
        this.populateProcessor = populateProcessor;
        this.prePopulateProcessor = prePopulateProcessor;
        this.generateProcessor = generateProcessor;
    }

    @Override
    public <C extends IPrimitiveType<String>> Questionnaire resolveQuestionnaire(IIdType id, C canonical, IBaseResource questionnaire) {
        return this.resolveProcessor.resolve(id, canonical, questionnaire);
    }

    @Override
    public Questionnaire prePopulate(Questionnaire questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        Objects.requireNonNull(questionnaire);
        Objects.requireNonNull(libraryEngine);
        PrePopulateRequest prePopulateRequest = new PrePopulateRequest(patientId, parameters, bundle, libraryEngine);
        return this.prePopulateProcessor.prePopulate(questionnaire, prePopulateRequest);
    }

    @Override
    public IBaseResource populate(Questionnaire questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        Questionnaire prePopulatedQuestionnaire = this.prePopulate(questionnaire, patientId, parameters, bundle, libraryEngine);
        return this.populateProcessor.populate(questionnaire, prePopulatedQuestionnaire, patientId);
    }

    @Override
    public Questionnaire generateQuestionnaire(String id) {
        return this.generateProcessor.generate(id);
    }

    public Bundle packageQuestionnaire(Questionnaire questionnaire, boolean isPut) {
        return this.packageProcessor.packageQuestionnaire(questionnaire, isPut);
    }
}

