/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.prepopulate;

import java.util.List;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.instance.model.api.IBase;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.processor.prepopulate.PrePopulateHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProcessor {
    private PrePopulateHelper prePopulateHelper = new PrePopulateHelper();
    protected static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    protected static final String EXCEPTION_MESSAGE_TEMPLATE = "Error encountered evaluating expression (%s) for item (%s): %s";

    ExpressionProcessor() {
        new ExpressionProcessor(new PrePopulateHelper());
    }

    private ExpressionProcessor(PrePopulateHelper prePopulateHelper) {
        this.prePopulateHelper = prePopulateHelper;
    }

    CqfExpression getInitialExpression(Questionnaire questionnaire, Questionnaire.QuestionnaireItemComponent item) {
        if (item.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
            return this.prePopulateHelper.getExpressionByExtension(questionnaire, item, "http://hl7.org/fhir/StructureDefinition/cqf-expression");
        }
        if (item.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            return this.prePopulateHelper.getExpressionByExtension(questionnaire, item, "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
        }
        return null;
    }

    List<IBase> getExpressionResult(PrePopulateRequest prePopulateRequest, CqfExpression expression, String itemLinkId) throws ResolveExpressionException {
        try {
            return prePopulateRequest.getLibraryEngine().resolveExpression(prePopulateRequest.getPatientId(), expression, prePopulateRequest.getParameters(), prePopulateRequest.getBundle());
        }
        catch (Exception ex) {
            String message = String.format(EXCEPTION_MESSAGE_TEMPLATE, expression.getExpression(), itemLinkId, ex.getMessage());
            throw new ResolveExpressionException(message);
        }
    }
}

