/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r4.processor;

import java.util.List;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.utility.r4.PackageHelper;
import org.opencds.cqf.fhir.utility.r4.SearchHelper;

public class PackageProcessor {
    final Repository repository;

    public PackageProcessor(Repository repository) {
        this.repository = repository;
    }

    public Bundle packageQuestionnaire(Questionnaire questionnaire, boolean isPut) {
        CanonicalType libraryCanonical;
        Library library;
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        bundle.addEntry(PackageHelper.createEntry((Resource)questionnaire, (boolean)isPut));
        Extension libraryExtension = questionnaire.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        if (libraryExtension != null && (library = (Library)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)(libraryCanonical = (CanonicalType)libraryExtension.getValue()))) != null) {
            bundle.addEntry(PackageHelper.createEntry((Resource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                PackageHelper.addRelatedArtifacts((Bundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        return bundle;
    }
}

