/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r4.processor.prepopulate;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Questionnaire;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.common.ResolveExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(ExpressionProcessor.class);
    protected static final String EXCEPTION_MESSAGE_TEMPLATE = "Error encountered evaluating expression (%s) for item (%s): %s";

    Expression getInitialExpression(Questionnaire.QuestionnaireItemComponent item) {
        if (item.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
            return (Expression)item.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression").getValue();
        }
        if (item.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            return (Expression)item.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression").getValue();
        }
        return null;
    }

    List<IBase> getExpressionResult(PrePopulateRequest prePopulateRequest, Expression expression, String itemLinkId, Questionnaire questionnaire) throws ResolveExpressionException {
        if (expression == null || !expression.hasExpression()) {
            return new ArrayList<IBase>();
        }
        try {
            CqfExpression cqfExpression = this.getCqfExpression(expression, questionnaire);
            return prePopulateRequest.getLibraryEngine().resolveExpression(prePopulateRequest.getPatientId(), cqfExpression, prePopulateRequest.getParameters(), prePopulateRequest.getBundle());
        }
        catch (Exception ex) {
            String message = String.format(EXCEPTION_MESSAGE_TEMPLATE, expression.getExpression(), itemLinkId, ex.getMessage());
            throw new ResolveExpressionException(message);
        }
    }

    CqfExpression getCqfExpression(Expression expression, Questionnaire questionnaire) {
        String libraryUrl = this.getLibraryUrl(questionnaire);
        return new CqfExpression(expression, libraryUrl, null);
    }

    String getLibraryUrl(Questionnaire questionnaire) {
        return questionnaire.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-library") ? (String)((CanonicalType)questionnaire.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library").getValue()).getValue() : null;
    }
}

