/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.questionnaire.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem.ElementHasCqfExpression;
import org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem.ElementHasDefaultValue;
import org.opencds.cqf.fhir.cr.questionnaire.r5.generator.nestedquestionnaireitem.QuestionnaireTypeIsChoice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NestedQuestionnaireItemService {
    protected final ModelResolver modelResolver;
    protected final QuestionnaireTypeIsChoice questionnaireTypeIsChoice;
    protected final ElementHasDefaultValue elementHasDefaultValue;
    protected final ElementHasCqfExpression elementHasCqfExpression;
    protected static final String ITEM_TYPE_ERROR = "Unable to determine type for element: %s";
    protected static final Logger logger = LoggerFactory.getLogger(NestedQuestionnaireItemService.class);

    public static NestedQuestionnaireItemService of(Repository repository, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        QuestionnaireTypeIsChoice questionnaireTypeIsChoice = QuestionnaireTypeIsChoice.of(repository);
        ElementHasDefaultValue elementHasDefault = new ElementHasDefaultValue();
        ElementHasCqfExpression elementHasCqfExpression = new ElementHasCqfExpression(patientId, parameters, bundle, libraryEngine);
        return new NestedQuestionnaireItemService(questionnaireTypeIsChoice, elementHasDefault, elementHasCqfExpression, FhirModelResolverCache.resolverForVersion((FhirVersionEnum)repository.fhirContext().getVersion().getVersion()));
    }

    NestedQuestionnaireItemService(QuestionnaireTypeIsChoice questionnaireTypeIsChoice, ElementHasDefaultValue elementHasDefaultValue, ElementHasCqfExpression elementHasCqfExpression, ModelResolver modelResolver) {
        this.questionnaireTypeIsChoice = questionnaireTypeIsChoice;
        this.elementHasDefaultValue = elementHasDefaultValue;
        this.elementHasCqfExpression = elementHasCqfExpression;
        this.modelResolver = modelResolver;
    }

    public Questionnaire.QuestionnaireItemComponent getNestedQuestionnaireItem(String profileUrl, ElementDefinition element, String childLinkId, Resource caseFeature) {
        String path;
        Object pathValue;
        Questionnaire.QuestionnaireItemType itemType = this.getItemType(element);
        Questionnaire.QuestionnaireItemComponent item = this.initializeQuestionnaireItem(itemType, profileUrl, element, childLinkId);
        if (itemType == Questionnaire.QuestionnaireItemType.QUESTION) {
            this.questionnaireTypeIsChoice.addProperties(element, item);
        }
        if (element.hasFixedOrPattern()) {
            this.elementHasDefaultValue.addProperties(element.getFixedOrPattern(), item);
        } else if (element.hasDefaultValue()) {
            this.elementHasDefaultValue.addProperties(element.getDefaultValue(), item);
        } else if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
            this.elementHasCqfExpression.addProperties(element, item);
        } else if (caseFeature != null && (pathValue = this.modelResolver.resolvePath((Object)caseFeature, path = element.getPath().split("\\.")[1].replace("[x]", ""))) instanceof DataType) {
            item.addInitial().setValue(ItemValueTransformer.transformValue((DataType)pathValue));
        }
        item.setRequired(element.hasMin() && element.getMin() == 1);
        return item;
    }

    protected Questionnaire.QuestionnaireItemComponent initializeQuestionnaireItem(Questionnaire.QuestionnaireItemType itemType, String profileUrl, ElementDefinition element, String childLinkId) {
        String definition = profileUrl + "#" + element.getPath();
        return new Questionnaire.QuestionnaireItemComponent().setType(itemType).setDefinition(definition).setLinkId(childLinkId).setText(this.getElementText(element));
    }

    public Questionnaire.QuestionnaireItemType getItemType(ElementDefinition element) {
        String elementType = ((ElementDefinition.TypeRefComponent)element.getType().get(0)).getCode();
        Questionnaire.QuestionnaireItemType itemType = this.parseItemType(elementType, element.hasBinding());
        if (itemType == null) {
            String message = String.format(ITEM_TYPE_ERROR, element.getId());
            throw new IllegalArgumentException(message);
        }
        return itemType;
    }

    public Questionnaire.QuestionnaireItemType parseItemType(String elementType, Boolean hasBinding) {
        if (Boolean.TRUE.equals(hasBinding)) {
            return Questionnaire.QuestionnaireItemType.QUESTION;
        }
        switch (elementType) {
            case "CodeableConcept": {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case "uri": {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case "BackboneElement": {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case "Quantity": {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
            case "Reference": {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case "code": {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
        }
        return Questionnaire.QuestionnaireItemType.fromCode((String)elementType);
    }

    public String getElementText(ElementDefinition element) {
        return element.hasLabel() ? element.getLabel() : this.getElementDescription(element);
    }

    protected String getElementDescription(ElementDefinition element) {
        return element.hasShort() ? element.getShort() : element.getPath();
    }
}

