/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.processor;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.opencds.cqf.fhir.cr.questionnaire.common.ExtensionBuilders;

public class PopulateProcessor {
    public QuestionnaireResponse populate(Questionnaire originalQuestionnaire, Questionnaire prePopulatedQuestionnaire, String patientId) {
        QuestionnaireResponse response = new QuestionnaireResponse();
        response.setId(prePopulatedQuestionnaire.getIdPart() + "-response");
        Optional<OperationOutcome> operationOutcome = this.getOperationOutcomeFromPrePopulatedQuestionnaire(prePopulatedQuestionnaire);
        if (prePopulatedQuestionnaire.hasExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages") && operationOutcome.isPresent()) {
            response.addContained((Resource)operationOutcome.get());
            response.addExtension(ExtensionBuilders.buildR5(ExtensionBuilders.crmiMessagesExtension(operationOutcome.get().getIdPart())));
        }
        response.addContained((Resource)prePopulatedQuestionnaire);
        response.addExtension(ExtensionBuilders.buildR5(ExtensionBuilders.dtrQuestionnaireResponseExtension(prePopulatedQuestionnaire.getIdPart())));
        response.setQuestionnaire(originalQuestionnaire.getUrl());
        response.setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
        response.setSubject(new Reference((IIdType)new IdType("Patient", patientId)));
        response.setItem(this.processResponseItems(prePopulatedQuestionnaire.getItem()));
        return response;
    }

    Optional<OperationOutcome> getOperationOutcomeFromPrePopulatedQuestionnaire(Questionnaire prePopulatedQuestionnaire) {
        return prePopulatedQuestionnaire.getContained().stream().filter(resource -> resource.getResourceType() == ResourceType.OperationOutcome).map(OperationOutcome.class::cast).filter(this::filterOperationOutcome).findFirst();
    }

    boolean filterOperationOutcome(OperationOutcome operationOutcome) {
        if (operationOutcome.hasIssue()) {
            List filteredIssues = operationOutcome.getIssue().stream().filter(issue -> issue.getCode() == OperationOutcome.IssueType.EXCEPTION && issue.getSeverity() == OperationOutcome.IssueSeverity.ERROR).collect(Collectors.toList());
            return !filteredIssues.isEmpty();
        }
        return false;
    }

    List<QuestionnaireResponse.QuestionnaireResponseItemComponent> processResponseItems(List<Questionnaire.QuestionnaireItemComponent> questionnaireItems) {
        return questionnaireItems.stream().map(this::processResponseItem).collect(Collectors.toList());
    }

    QuestionnaireResponse.QuestionnaireResponseItemComponent processResponseItem(Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        QuestionnaireResponse.QuestionnaireResponseItemComponent responseItem = new QuestionnaireResponse.QuestionnaireResponseItemComponent((String)questionnaireItem.getLinkIdElement().getValue());
        responseItem.setDefinition(questionnaireItem.getDefinition());
        responseItem.setTextElement(questionnaireItem.getTextElement());
        if (questionnaireItem.hasItem()) {
            List<QuestionnaireResponse.QuestionnaireResponseItemComponent> nestedResponseItems = this.processResponseItems(questionnaireItem.getItem());
            responseItem.setItem(nestedResponseItems);
        } else if (questionnaireItem.hasInitial()) {
            responseItem = this.setAnswersForInitial(questionnaireItem, responseItem);
        }
        return responseItem;
    }

    QuestionnaireResponse.QuestionnaireResponseItemComponent setAnswersForInitial(Questionnaire.QuestionnaireItemComponent questionnaireItem, QuestionnaireResponse.QuestionnaireResponseItemComponent questionnaireResponseItem) {
        if (questionnaireItem.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author")) {
            questionnaireResponseItem.addExtension(questionnaireItem.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author"));
        }
        questionnaireItem.getInitial().forEach(initial -> {
            QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue(initial.getValue());
            questionnaireResponseItem.addAnswer(answer);
        });
        return questionnaireResponseItem;
    }
}

