/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.processor.prepopulate;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.cr.questionnaire.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.questionnaire.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.r5.processor.prepopulate.ExpressionProcessor;

public class PrePopulateItem {
    final ExpressionProcessor expressionProcessor;

    public PrePopulateItem() {
        this(new ExpressionProcessor());
    }

    private PrePopulateItem(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    Questionnaire.QuestionnaireItemComponent processItem(PrePopulateRequest prePopulateRequest, Questionnaire.QuestionnaireItemComponent questionnaireItem, Questionnaire questionnaire) throws ResolveExpressionException {
        Questionnaire.QuestionnaireItemComponent populatedItem = this.copyQuestionnaireItem(questionnaireItem);
        List<IBase> expressionResults = this.getExpressionResults(prePopulateRequest, questionnaire, populatedItem);
        expressionResults.forEach(result -> {
            populatedItem.addExtension(ExtensionBuilders.buildR5(ExtensionBuilders.QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION));
            populatedItem.addInitial(new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValue((DataType)result)));
        });
        return populatedItem;
    }

    Questionnaire.QuestionnaireItemComponent copyQuestionnaireItem(Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        return questionnaireItem.copy();
    }

    List<IBase> getExpressionResults(PrePopulateRequest prePopulateRequest, Questionnaire questionnaire, Questionnaire.QuestionnaireItemComponent questionnaireItem) throws ResolveExpressionException {
        Expression initialExpression = this.expressionProcessor.getInitialExpression(questionnaireItem);
        if (initialExpression != null) {
            List<IBase> expressionResult = this.expressionProcessor.getExpressionResult(prePopulateRequest, initialExpression, questionnaireItem.getLinkId(), questionnaire);
            return expressionResult.stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<IBase>();
    }
}

