/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r5.processor.prepopulate;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.opencds.cqf.fhir.cr.questionnaire.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.questionnaire.common.PrePopulateRequest;
import org.opencds.cqf.fhir.cr.questionnaire.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.r5.processor.prepopulate.PrePopulateItem;
import org.opencds.cqf.fhir.cr.questionnaire.r5.processor.prepopulate.PrePopulateItemWithExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrePopulateProcessor {
    protected static final Logger logger = LoggerFactory.getLogger(PrePopulateProcessor.class);
    private final PrePopulateItem prePopulateItem;
    private final PrePopulateItemWithExtension prePopulateItemWithExtension;
    OperationOutcome operationOutcome;

    public PrePopulateProcessor() {
        this(new PrePopulateItem(), new PrePopulateItemWithExtension());
    }

    private PrePopulateProcessor(PrePopulateItem prePopulateItem, PrePopulateItemWithExtension prePopulateItemWithExtension) {
        this.prePopulateItem = prePopulateItem;
        this.prePopulateItemWithExtension = prePopulateItemWithExtension;
    }

    public Questionnaire prePopulate(Questionnaire questionnaire, PrePopulateRequest prePopulateRequest) {
        String questionnaireId = this.getQuestionnaireId(prePopulateRequest, questionnaire);
        this.operationOutcome = this.getBaseOperationOutcome(questionnaireId);
        Questionnaire prepopulatedQuestionnaire = questionnaire.copy();
        prepopulatedQuestionnaire.setId(questionnaireId);
        prepopulatedQuestionnaire.addExtension(ExtensionBuilders.buildR5(ExtensionBuilders.prepopulateSubjectExtension(Enumerations.FHIRTypes.PATIENT.toCode(), prePopulateRequest.getPatientId())));
        List<Questionnaire.QuestionnaireItemComponent> processedItems = this.processItems(prePopulateRequest, questionnaire.getItem(), questionnaire);
        prepopulatedQuestionnaire.setItem(processedItems);
        if (!this.operationOutcome.getIssue().isEmpty()) {
            prepopulatedQuestionnaire.addContained((Resource)this.operationOutcome);
            prepopulatedQuestionnaire.addExtension(ExtensionBuilders.buildR5(ExtensionBuilders.crmiMessagesExtension(this.operationOutcome.getIdPart())));
        }
        return prepopulatedQuestionnaire;
    }

    List<Questionnaire.QuestionnaireItemComponent> processItems(PrePopulateRequest prePopulateRequest, List<Questionnaire.QuestionnaireItemComponent> questionnaireItems, Questionnaire questionnaire) {
        ArrayList<Questionnaire.QuestionnaireItemComponent> populatedItems = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        questionnaireItems.forEach(item -> {
            if (item.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext")) {
                populatedItems.addAll(this.prePopulateItemWithExtension(prePopulateRequest, (Questionnaire.QuestionnaireItemComponent)item, questionnaire));
            } else {
                Questionnaire.QuestionnaireItemComponent populatedItem = this.copyQuestionnaireItem((Questionnaire.QuestionnaireItemComponent)item);
                if (item.hasItem()) {
                    List<Questionnaire.QuestionnaireItemComponent> processedSubItems = this.processItems(prePopulateRequest, item.getItem(), questionnaire);
                    populatedItem.setItem(processedSubItems);
                    populatedItems.add(populatedItem);
                } else {
                    populatedItems.add(this.prePopulateItem(prePopulateRequest, populatedItem, questionnaire));
                }
            }
        });
        return populatedItems;
    }

    List<Questionnaire.QuestionnaireItemComponent> prePopulateItemWithExtension(PrePopulateRequest prePopulateRequest, Questionnaire.QuestionnaireItemComponent questionnaireItem, Questionnaire questionnaire) {
        try {
            return this.prePopulateItemWithExtension.processItem(prePopulateRequest, questionnaireItem, questionnaire);
        }
        catch (ResolveExpressionException e) {
            this.addExceptionToOperationOutcome(e.getMessage());
            return new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        }
    }

    Questionnaire.QuestionnaireItemComponent prePopulateItem(PrePopulateRequest prePopulateRequest, Questionnaire.QuestionnaireItemComponent questionnaireItem, Questionnaire questionnaire) {
        try {
            return this.prePopulateItem.processItem(prePopulateRequest, questionnaireItem, questionnaire);
        }
        catch (ResolveExpressionException e) {
            this.addExceptionToOperationOutcome(e.getMessage());
            return questionnaireItem.copy();
        }
    }

    void addExceptionToOperationOutcome(String exceptionMessage) {
        logger.error(exceptionMessage);
        this.operationOutcome.addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(exceptionMessage);
    }

    OperationOutcome getBaseOperationOutcome(String questionnaireId) {
        OperationOutcome baseOperationOutcome = new OperationOutcome();
        baseOperationOutcome.setId("populate-outcome-" + questionnaireId);
        return baseOperationOutcome;
    }

    String getQuestionnaireId(PrePopulateRequest prePopulateRequest, Questionnaire questionnaire) {
        return questionnaire.getIdPart() + "-" + prePopulateRequest.getPatientId();
    }

    Questionnaire.QuestionnaireItemComponent copyQuestionnaireItem(Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        return questionnaireItem.copy();
    }
}

