/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaireresponse.r4;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BaseDateTimeType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cr.questionnaireresponse.BaseQuestionnaireResponseProcessor;
import org.opencds.cqf.fhir.utility.search.Searches;

public class QuestionnaireResponseProcessor
extends BaseQuestionnaireResponseProcessor<QuestionnaireResponse> {
    public QuestionnaireResponseProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireResponseProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        super(repository, evaluationSettings);
    }

    @Override
    public QuestionnaireResponse resolveQuestionnaireResponse(IIdType id, IBaseResource questionnaireResponse) {
        IBaseResource baseQuestionnaireResponse = questionnaireResponse;
        if (baseQuestionnaireResponse == null && id != null) {
            baseQuestionnaireResponse = this.repository.read(QuestionnaireResponse.class, id);
        }
        return QuestionnaireResponseProcessor.castOrThrow((IBase)baseQuestionnaireResponse, QuestionnaireResponse.class, "The QuestionnaireResponse passed to repository was not a valid instance of QuestionnaireResponse.class").orElse(null);
    }

    @Override
    protected IBaseBundle createResourceBundle(QuestionnaireResponse questionnaireResponse, List<IBaseResource> resources) {
        Bundle newBundle = new Bundle();
        newBundle.setId((IIdType)new IdType(Enumerations.FHIRAllTypes.BUNDLE.toCode(), this.getExtractId(questionnaireResponse)));
        newBundle.setType(Bundle.BundleType.TRANSACTION);
        resources.forEach(resource -> {
            Bundle.BundleEntryRequestComponent request = new Bundle.BundleEntryRequestComponent();
            request.setMethod(Bundle.HTTPVerb.PUT);
            request.setUrl(resource.fhirType() + "/" + resource.getIdElement().getIdPart());
            Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
            entry.setResource((Resource)resource);
            entry.setRequest(request);
            newBundle.addEntry(entry);
        });
        return newBundle;
    }

    @Override
    protected void setup(QuestionnaireResponse questionnaireResponse) {
        this.patientId = questionnaireResponse.getSubject().getId();
        this.libraryUrl = questionnaireResponse.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-library") ? (String)((CanonicalType)questionnaireResponse.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library").getValue()).getValue() : null;
    }

    @Override
    public List<IBaseResource> processItems(QuestionnaireResponse questionnaireResponse) {
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        Reference subject = questionnaireResponse.getSubject();
        Questionnaire questionnaire = null;
        String questionnaireCanonical = questionnaireResponse.getQuestionnaire();
        if (questionnaireCanonical != null && !questionnaireCanonical.isEmpty()) {
            Bundle results = (Bundle)this.repository.search(Bundle.class, Questionnaire.class, Searches.byCanonical((String)questionnaireCanonical));
            Questionnaire questionnaire2 = questionnaire = results.hasEntry() ? (Questionnaire)results.getEntryFirstRep().getResource() : null;
        }
        if (questionnaireResponse.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext")) {
            questionnaireResponse.getItem().forEach(item -> this.processDefinitionItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item, questionnaireResponse, (List<IBaseResource>)resources, subject));
        } else {
            Map<String, List<Coding>> questionnaireCodeMap = this.createCodeMap(questionnaire);
            questionnaireResponse.getItem().forEach(item -> {
                if (item.hasItem()) {
                    this.processGroupItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item, questionnaireResponse, questionnaireCodeMap, (List<IBaseResource>)resources, subject);
                } else if (item.hasDefinition()) {
                    this.processDefinitionItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item, questionnaireResponse, (List<IBaseResource>)resources, subject);
                } else {
                    this.processItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)item, questionnaireResponse, questionnaireCodeMap, (List<IBaseResource>)resources, subject);
                }
            });
        }
        return resources;
    }

    private void processGroupItem(QuestionnaireResponse.QuestionnaireResponseItemComponent item, QuestionnaireResponse questionnaireResponse, Map<String, List<Coding>> questionnaireCodeMap, List<IBaseResource> resources, Reference subject) {
        Reference groupSubject;
        List subjectItems = item.getItem().stream().filter(child -> child.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject")).collect(Collectors.toList());
        Reference reference = groupSubject = !subjectItems.isEmpty() ? ((QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent)((QuestionnaireResponse.QuestionnaireResponseItemComponent)subjectItems.get(0)).getAnswer().get(0)).getValueReference() : subject.copy();
        if (item.hasDefinition()) {
            this.processDefinitionItem(item, questionnaireResponse, resources, groupSubject);
        } else {
            item.getItem().forEach(childItem -> {
                if (!childItem.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse-isSubject")) {
                    if (childItem.hasItem()) {
                        this.processGroupItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)childItem, questionnaireResponse, questionnaireCodeMap, resources, groupSubject);
                    } else {
                        this.processItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)childItem, questionnaireResponse, questionnaireCodeMap, resources, groupSubject);
                    }
                }
            });
        }
    }

    private Property getSubjectProperty(Resource resource) {
        Property property = resource.getNamedProperty("subject");
        if (property == null) {
            property = resource.getNamedProperty("patient");
        }
        return property;
    }

    private Property getAuthorProperty(Resource resource) {
        Property property = resource.getNamedProperty("recorder");
        if (property == null && resource.fhirType().equals(Enumerations.FHIRAllTypes.OBSERVATION.toCode())) {
            property = resource.getNamedProperty("performer");
        }
        return property;
    }

    private List<Property> getDateProperties(Resource resource) {
        ArrayList<Property> results = new ArrayList<Property>();
        results.add(resource.getNamedProperty("onset"));
        results.add(resource.getNamedProperty("issued"));
        results.add(resource.getNamedProperty("effective"));
        results.add(resource.getNamedProperty("recordDate"));
        return results.stream().filter(p -> p != null).collect(Collectors.toList());
    }

    private void resolveMeta(DomainResource resource, String definition) {
        Meta meta = new Meta();
        if (definition != null && !definition.isEmpty()) {
            meta.addProfile(definition.split("#")[0]);
            resource.setMeta(meta);
        }
    }

    private List<IBase> getExpressionResult(Expression expression, String itemLinkId) {
        if (expression == null || expression.getExpression().isEmpty()) {
            return null;
        }
        try {
            return this.libraryEngine.resolveExpression(this.patientId, new CqfExpression(expression, this.libraryUrl, null), this.parameters, this.bundle);
        }
        catch (Exception ex) {
            String message = String.format("Error encountered evaluating expression (%s) for item (%s): %s", expression.getExpression(), itemLinkId, ex.getMessage());
            logger.error(message);
            return null;
        }
    }

    private String getDefinitionType(String definition) {
        if (!definition.contains("#")) {
            throw new IllegalArgumentException(String.format("Unable to determine resource type from item definition: %s", definition));
        }
        return definition.split("#")[1];
    }

    private void processDefinitionItem(QuestionnaireResponse.QuestionnaireResponseItemComponent item, QuestionnaireResponse questionnaireResponse, List<IBaseResource> resources, Reference subject) {
        List<Property> dateProperties;
        Property authorProperty;
        Expression contextExpression;
        List<IBase> context;
        Extension itemExtractionContext;
        String contextExtension = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemExtractionContext";
        Extension extension = itemExtractionContext = item.hasExtension(contextExtension) ? item.getExtensionByUrl(contextExtension) : questionnaireResponse.getExtensionByUrl(contextExtension);
        if (itemExtractionContext == null || (context = this.getExpressionResult(contextExpression = (Expression)itemExtractionContext.getValue(), item.getLinkId())) == null || !context.isEmpty()) {
            // empty if block
        }
        String resourceType = this.getDefinitionType(item.getDefinition());
        Resource resource = (Resource)this.newValue(resourceType);
        resource.setId((IIdType)new IdType(resourceType, this.getExtractId(questionnaireResponse) + "-" + item.getLinkId()));
        this.resolveMeta((DomainResource)resource, item.getDefinition());
        Property subjectProperty = this.getSubjectProperty(resource);
        if (subjectProperty != null) {
            resource.setProperty(subjectProperty.getName(), (Base)subject);
        }
        if ((authorProperty = this.getAuthorProperty(resource)) != null && questionnaireResponse.hasAuthor()) {
            resource.setProperty(authorProperty.getName(), (Base)questionnaireResponse.getAuthor());
        }
        if ((dateProperties = this.getDateProperties(resource)) != null && !dateProperties.isEmpty() && questionnaireResponse.hasAuthored()) {
            dateProperties.forEach(p -> {
                try {
                    BaseRuntimeElementDefinition propertyDef = this.fhirContext().getElementDefinition(p.getTypeCode().contains("|") ? p.getTypeCode().split("\\|")[0] : p.getTypeCode());
                    if (propertyDef != null) {
                        this.modelResolver.setValue((Object)resource, p.getName(), propertyDef.getImplementingClass().getConstructor(Date.class).newInstance(questionnaireResponse.getAuthored()));
                    }
                }
                catch (Exception ex) {
                    String message = String.format("Error encountered attempting to set property (%s) on resource type (%s): %s", p.getName(), resource.fhirType(), ex.getMessage());
                    logger.error(message);
                }
            });
        }
        item.getItem().forEach(childItem -> {
            if (childItem.hasDefinition()) {
                String[] definition = childItem.getDefinition().split("#");
                String path = definition[1];
                path = path.replace(resourceType + ".", "");
                Type answerValue = childItem.getAnswerFirstRep().getValue();
                if (answerValue != null) {
                    this.modelResolver.setValue((Object)resource, path, (Object)answerValue);
                }
            }
        });
        resources.add((IBaseResource)resource);
    }

    private Base newValue(String type) {
        try {
            return (Base)Class.forName("org.hl7.fhir.r4.model." + type).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processItem(QuestionnaireResponse.QuestionnaireResponseItemComponent item, QuestionnaireResponse questionnaireResponse, Map<String, List<Coding>> questionnaireCodeMap, List<IBaseResource> resources, Reference subject) {
        if (questionnaireCodeMap == null || questionnaireCodeMap.isEmpty()) {
            throw new IllegalArgumentException("Unable to retrieve Questionnaire code map for Observation based extraction");
        }
        if (item.hasAnswer()) {
            item.getAnswer().forEach(answer -> {
                if (answer.hasItem()) {
                    answer.getItem().forEach(answerItem -> this.processItem((QuestionnaireResponse.QuestionnaireResponseItemComponent)answerItem, questionnaireResponse, questionnaireCodeMap, resources, subject));
                } else if (questionnaireCodeMap.get(item.getLinkId()) != null && !((List)questionnaireCodeMap.get(item.getLinkId())).isEmpty()) {
                    resources.add((IBaseResource)this.createObservationFromItemAnswer((QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent)answer, item.getLinkId(), questionnaireResponse, subject, questionnaireCodeMap));
                }
            });
        }
    }

    private Observation createObservationFromItemAnswer(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer, String linkId, QuestionnaireResponse questionnaireResponse, Reference subject, Map<String, List<Coding>> questionnaireCodeMap) {
        Observation obs = new Observation();
        obs.setId(this.getExtractId(questionnaireResponse) + "." + linkId);
        obs.setBasedOn(questionnaireResponse.getBasedOn());
        obs.setPartOf(questionnaireResponse.getPartOf());
        obs.setStatus(Observation.ObservationStatus.FINAL);
        Coding qrCategoryCoding = new Coding();
        qrCategoryCoding.setCode("survey");
        qrCategoryCoding.setSystem("http://hl7.org/fhir/observation-category");
        obs.setCategory(Collections.singletonList(new CodeableConcept().addCoding(qrCategoryCoding)));
        obs.setCode(new CodeableConcept().setCoding(questionnaireCodeMap.get(linkId)));
        obs.setSubject(subject);
        obs.setEncounter(questionnaireResponse.getEncounter());
        DateTimeType authoredDate = new DateTimeType((questionnaireResponse.hasAuthored() ? questionnaireResponse.getAuthored().toInstant() : Instant.now()).toString());
        obs.setEffective((Type)authoredDate);
        obs.setIssuedElement(new InstantType((BaseDateTimeType)authoredDate));
        obs.setPerformer(Collections.singletonList(questionnaireResponse.getAuthor()));
        switch (answer.getValue().fhirType()) {
            case "Coding": {
                obs.setValue((Type)new CodeableConcept().addCoding(answer.getValueCoding()));
                break;
            }
            case "date": {
                obs.setValue((Type)new DateTimeType((Date)((DateType)answer.getValue()).getValue()));
                break;
            }
            default: {
                obs.setValue(answer.getValue());
            }
        }
        obs.setDerivedFrom(Collections.singletonList(new Reference((IAnyResource)questionnaireResponse)));
        Extension linkIdExtension = new Extension();
        linkIdExtension.setUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/derivedFromLinkId");
        Extension innerLinkIdExtension = new Extension();
        innerLinkIdExtension.setUrl("text");
        innerLinkIdExtension.setValue((Type)new StringType(linkId));
        linkIdExtension.setExtension(Collections.singletonList(innerLinkIdExtension));
        obs.addExtension(linkIdExtension);
        return obs;
    }

    private Map<String, List<Coding>> createCodeMap(Questionnaire questionnaire) {
        if (questionnaire == null) {
            return null;
        }
        HashMap<String, List<Coding>> questionnaireCodeMap = new HashMap<String, List<Coding>>();
        questionnaire.getItem().forEach(item -> this.processQuestionnaireItems((Questionnaire.QuestionnaireItemComponent)item, (Map<String, List<Coding>>)questionnaireCodeMap));
        return questionnaireCodeMap;
    }

    private void processQuestionnaireItems(Questionnaire.QuestionnaireItemComponent item, Map<String, List<Coding>> questionnaireCodeMap) {
        if (item.hasItem()) {
            item.getItem().forEach(qItem -> this.processQuestionnaireItems((Questionnaire.QuestionnaireItemComponent)qItem, questionnaireCodeMap));
        } else {
            questionnaireCodeMap.put(item.getLinkId(), item.getCode());
        }
    }
}

