/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.dstu3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.ProcedureRequest;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.Task;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cr.activitydefinition.BaseActivityDefinitionProcessor;
import org.opencds.cqf.fhir.utility.dstu3.InputParameterResolver;
import org.opencds.cqf.fhir.utility.dstu3.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDefinitionProcessor
extends BaseActivityDefinitionProcessor<ActivityDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(ActivityDefinitionProcessor.class);
    protected InputParameterResolver inputParameterResolver;

    public ActivityDefinitionProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public ActivityDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        super(repository, evaluationSettings);
    }

    @Override
    public <C extends IPrimitiveType<String>> ActivityDefinition resolveActivityDefinition(IIdType id, C canonical, IBaseResource activityDefinition) throws FHIRException {
        IBaseResource baseActivityDefinition = activityDefinition;
        if (baseActivityDefinition == null) {
            baseActivityDefinition = id != null ? this.repository.read(ActivityDefinition.class, id) : (ActivityDefinition)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, canonical);
        }
        Objects.requireNonNull(baseActivityDefinition, "Couldn't find ActivityDefinition " + id);
        return ActivityDefinitionProcessor.castOrThrow((IBase)baseActivityDefinition, ActivityDefinition.class, "The activityDefinition passed in was not a valid instance of ActivityDefinition.class").orElse(null);
    }

    @Override
    protected ActivityDefinition initApply(ActivityDefinition activityDefinition) {
        logger.info("Performing $apply operation on {}", (Object)activityDefinition.getId());
        this.inputParameterResolver = new InputParameterResolver(this.subjectId, this.encounterId, this.practitionerId, this.parameters, this.useServerData, this.bundle, this.repository);
        return activityDefinition;
    }

    @Override
    public IBaseResource applyActivityDefinition(ActivityDefinition activityDefinition) {
        DomainResource result;
        try {
            result = (DomainResource)Class.forName("org.hl7.fhir.dstu3.model." + activityDefinition.getKind().toCode()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FHIRException("Could not find org.hl7.fhir.dstu3.model." + activityDefinition.getKind().toCode());
        }
        switch (result.fhirType()) {
            case "ReferralRequest": {
                result = this.resolveReferralRequest(activityDefinition);
                break;
            }
            case "ProcedureRequest": {
                result = this.resolveProcedureRequest(activityDefinition);
                break;
            }
            case "MedicationRequest": {
                result = this.resolveMedicationRequest(activityDefinition);
                break;
            }
            case "SupplyRequest": {
                result = this.resolveSupplyRequest(activityDefinition);
                break;
            }
            case "Procedure": {
                result = this.resolveProcedure(activityDefinition);
                break;
            }
            case "DiagnosticReport": {
                result = this.resolveDiagnosticReport(activityDefinition);
                break;
            }
            case "Communication": {
                result = this.resolveCommunication(activityDefinition);
                break;
            }
            case "CommunicationRequest": {
                result = this.resolveCommunicationRequest(activityDefinition);
                break;
            }
            case "Task": {
                result = this.resolveTask(activityDefinition);
                break;
            }
            default: {
                String msg = "Unsupported activity type: " + result.fhirType();
                logger.error(msg);
                throw new FHIRException(msg);
            }
        }
        this.resolveExtensions(result, activityDefinition);
        String defaultLibraryUrl = activityDefinition.hasLibrary() ? ((Reference)activityDefinition.getLibrary().get(0)).getReference() : null;
        Parameters inputParams = this.inputParameterResolver.getParameters();
        for (ActivityDefinition.ActivityDefinitionDynamicValueComponent dynamicValue : activityDefinition.getDynamicValue()) {
            if (!dynamicValue.hasExpression()) continue;
            List expressionResult = this.libraryEngine.resolveExpression(this.subjectId, new CqfExpression(dynamicValue.getLanguage(), dynamicValue.getExpression(), defaultLibraryUrl), (IBaseParameters)inputParams, this.bundle);
            this.resolveDynamicValue(expressionResult, dynamicValue.getExpression(), dynamicValue.getPath(), (IBaseResource)result);
        }
        return result;
    }

    private void resolveExtensions(DomainResource resource, ActivityDefinition activityDefinition) {
        if (activityDefinition.hasExtension()) {
            resource.setExtension(activityDefinition.getExtension().stream().filter(e -> !EXCLUDED_EXTENSION_LIST.contains(e.getUrl())).collect(Collectors.toList()));
        }
    }

    private Task resolveTask(ActivityDefinition activityDefinition) throws FHIRException {
        Task task = new Task();
        if (activityDefinition.hasExtension()) {
            Type value = ((Extension)activityDefinition.getExtensionsByUrl("http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus").get(0)).getValue();
            if (value instanceof StringType) {
                task.setStatus(Task.TaskStatus.valueOf((String)((StringType)value).asStringValue().toUpperCase()));
            } else {
                logger.debug("Extension {} should have a value of type {}", (Object)"http://hl7.org/fhir/us/ecr/StructureDefinition/targetStatus", (Object)StringType.class.getName());
            }
        } else {
            task.setStatus(Task.TaskStatus.DRAFT);
        }
        task.setIntent(Task.TaskIntent.PROPOSAL);
        if (activityDefinition.hasUrl()) {
            task.setDefinition((Type)activityDefinition.getUrlElement());
        }
        if (activityDefinition.hasCode()) {
            task.setCode(activityDefinition.getCode());
        }
        if (activityDefinition.hasDescription()) {
            task.setDescription(activityDefinition.getDescription());
        }
        return task;
    }

    private ReferralRequest resolveReferralRequest(ActivityDefinition activityDefinition) throws FHIRException {
        ReferralRequest referralRequest = new ReferralRequest();
        referralRequest.setStatus(ReferralRequest.ReferralRequestStatus.DRAFT);
        referralRequest.setIntent(ReferralRequest.ReferralCategory.ORDER);
        referralRequest.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            referralRequest.setDefinition(Collections.singletonList(new Reference(activityDefinition.getUrl())));
        }
        if (this.practitionerId != null) {
            referralRequest.setRequester(new ReferralRequest.ReferralRequestRequesterComponent(new Reference(this.practitionerId)));
        } else if (this.organizationId != null) {
            referralRequest.setRequester(new ReferralRequest.ReferralRequestRequesterComponent(new Reference(this.organizationId)));
        }
        if (activityDefinition.hasCode()) {
            referralRequest.setServiceRequested(Collections.singletonList(activityDefinition.getCode()));
        } else if (!activityDefinition.hasCode() && !activityDefinition.hasDynamicValue()) {
            throw new FHIRException("Missing required code property");
        }
        if (activityDefinition.hasBodySite()) {
            throw new FHIRException("BodySite does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasProduct()) {
            throw new FHIRException("Product does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasDosage()) {
            throw new FHIRException("Dosage does not map to " + activityDefinition.getKind());
        }
        return referralRequest;
    }

    private ProcedureRequest resolveProcedureRequest(ActivityDefinition activityDefinition) throws FHIRException {
        ProcedureRequest procedureRequest = new ProcedureRequest();
        procedureRequest.setStatus(ProcedureRequest.ProcedureRequestStatus.DRAFT);
        procedureRequest.setIntent(ProcedureRequest.ProcedureRequestIntent.PROPOSAL);
        procedureRequest.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            procedureRequest.setDefinition(Collections.singletonList(new Reference(activityDefinition.getUrl())));
        }
        if (this.practitionerId != null) {
            procedureRequest.setRequester(new ProcedureRequest.ProcedureRequestRequesterComponent().setAgent(new Reference(this.practitionerId)));
        } else if (this.organizationId != null) {
            procedureRequest.setRequester(new ProcedureRequest.ProcedureRequestRequesterComponent().setAgent(new Reference(this.organizationId)));
        }
        if (activityDefinition.hasCode()) {
            procedureRequest.setCode(activityDefinition.getCode());
        } else if (!activityDefinition.hasCode() && !activityDefinition.hasDynamicValue()) {
            throw new FHIRException("Missing required code property");
        }
        if (activityDefinition.hasBodySite()) {
            procedureRequest.setBodySite(activityDefinition.getBodySite());
        }
        if (activityDefinition.hasProduct()) {
            throw new FHIRException("Product does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasDosage()) {
            throw new FHIRException("Dosage does not map to " + activityDefinition.getKind());
        }
        return procedureRequest;
    }

    private MedicationRequest resolveMedicationRequest(ActivityDefinition activityDefinition) throws FHIRException {
        MedicationRequest medicationRequest = new MedicationRequest();
        medicationRequest.setIntent(MedicationRequest.MedicationRequestIntent.ORDER);
        medicationRequest.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            medicationRequest.setDefinition(Collections.singletonList(new Reference(activityDefinition.getUrl())));
        }
        if (!activityDefinition.hasProduct()) {
            throw new FHIRException("Missing required code property");
        }
        medicationRequest.setMedication(activityDefinition.getProduct());
        if (activityDefinition.hasDosage()) {
            medicationRequest.setDosageInstruction(activityDefinition.getDosage());
        }
        if (activityDefinition.hasBodySite()) {
            throw new FHIRException("BodySite does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasCode()) {
            throw new FHIRException("Code does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasQuantity()) {
            throw new FHIRException("Quantity does not map to " + activityDefinition.getKind());
        }
        return medicationRequest;
    }

    private SupplyRequest resolveSupplyRequest(ActivityDefinition activityDefinition) throws FHIRException {
        SupplyRequest supplyRequest = new SupplyRequest();
        if (this.practitionerId != null) {
            supplyRequest.setRequester(new SupplyRequest.SupplyRequestRequesterComponent(new Reference(this.practitionerId)));
        }
        if (this.organizationId != null) {
            supplyRequest.setRequester(new SupplyRequest.SupplyRequestRequesterComponent(new Reference(this.organizationId)));
        }
        if (activityDefinition.hasCode()) {
            if (!activityDefinition.hasQuantity()) {
                throw new FHIRException("Missing required orderedItem.quantity property");
            }
            supplyRequest.setOrderedItem(new SupplyRequest.SupplyRequestOrderedItemComponent((Quantity)activityDefinition.getQuantity()).setItem((Type)activityDefinition.getCode()));
        }
        if (activityDefinition.hasProduct()) {
            throw new FHIRException("Product does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasDosage()) {
            throw new FHIRException("Dosage does not map to " + activityDefinition.getKind());
        }
        if (activityDefinition.hasBodySite()) {
            throw new FHIRException("BodySite does not map to " + activityDefinition.getKind());
        }
        return supplyRequest;
    }

    private Procedure resolveProcedure(ActivityDefinition activityDefinition) {
        Procedure procedure = new Procedure();
        procedure.setStatus(Procedure.ProcedureStatus.UNKNOWN);
        procedure.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasUrl()) {
            procedure.setDefinition(Collections.singletonList(new Reference(activityDefinition.getUrl())));
        }
        if (activityDefinition.hasCode()) {
            procedure.setCode(activityDefinition.getCode());
        }
        if (activityDefinition.hasBodySite()) {
            procedure.setBodySite(activityDefinition.getBodySite());
        }
        return procedure;
    }

    private DiagnosticReport resolveDiagnosticReport(ActivityDefinition activityDefinition) {
        DiagnosticReport diagnosticReport = new DiagnosticReport();
        diagnosticReport.setStatus(DiagnosticReport.DiagnosticReportStatus.UNKNOWN);
        diagnosticReport.setSubject(new Reference(this.subjectId));
        if (!activityDefinition.hasCode()) {
            throw new FHIRException("Missing required ActivityDefinition.code property for DiagnosticReport");
        }
        diagnosticReport.setCode(activityDefinition.getCode());
        if (activityDefinition.hasRelatedArtifact()) {
            ArrayList<Attachment> presentedFormAttachments = new ArrayList<Attachment>();
            for (RelatedArtifact artifact : activityDefinition.getRelatedArtifact()) {
                Attachment attachment = new Attachment();
                if (artifact.hasUrl()) {
                    attachment.setUrl(artifact.getUrl());
                }
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                presentedFormAttachments.add(attachment);
            }
            diagnosticReport.setPresentedForm(presentedFormAttachments);
        }
        return diagnosticReport;
    }

    private Communication resolveCommunication(ActivityDefinition activityDefinition) {
        Communication communication = new Communication();
        communication.setStatus(Communication.CommunicationStatus.UNKNOWN);
        communication.setSubject(new Reference(this.subjectId));
        if (activityDefinition.hasCode()) {
            communication.setReasonCode(Collections.singletonList(activityDefinition.getCode()));
        }
        if (activityDefinition.hasRelatedArtifact()) {
            for (RelatedArtifact artifact : activityDefinition.getRelatedArtifact()) {
                if (!artifact.hasUrl()) continue;
                Attachment attachment = new Attachment().setUrl(artifact.getUrl());
                if (artifact.hasDisplay()) {
                    attachment.setTitle(artifact.getDisplay());
                }
                Communication.CommunicationPayloadComponent payload = new Communication.CommunicationPayloadComponent();
                payload.setContent((Type)(artifact.hasDisplay() ? attachment.setTitle(artifact.getDisplay()) : attachment));
                communication.setPayload(Collections.singletonList(payload));
            }
        }
        return communication;
    }

    private CommunicationRequest resolveCommunicationRequest(ActivityDefinition activityDefinition) {
        CommunicationRequest communicationRequest = new CommunicationRequest();
        communicationRequest.setStatus(CommunicationRequest.CommunicationRequestStatus.DRAFT);
        communicationRequest.setSubject(new Reference(this.subjectId));
        if (this.encounterId != null && !this.encounterId.isEmpty()) {
            communicationRequest.setContext(new Reference(this.encounterId));
        }
        if (this.practitionerId != null && !this.practitionerId.isEmpty()) {
            communicationRequest.setRequester(new CommunicationRequest.CommunicationRequestRequesterComponent(new Reference(this.practitionerId)));
        }
        if (activityDefinition.hasCode() && activityDefinition.getCode().hasText()) {
            communicationRequest.addPayload().setContent((Type)new StringType(activityDefinition.getCode().getText()));
        }
        return communicationRequest;
    }
}

