/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.helper;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateHelper {
    public static Date resolveRequestDate(String date, boolean start) {
        boolean isOffsetDateString;
        if (date.contains("Z")) {
            return Date.from(Instant.from(DateTimeFormatter.ISO_INSTANT.parse(date)));
        }
        boolean bl = isOffsetDateString = date.contains("T") && date.contains(".") && date.contains("-");
        if (isOffsetDateString) {
            return Date.from(Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(date)));
        }
        if (date.contains("T")) {
            TemporalAccessor ta = DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(date);
            LocalDateTime ld = LocalDateTime.from(ta);
            return Date.from(ld.atZone(ZoneId.systemDefault()).toInstant());
        }
        return DateHelper.resolveDate(start, date);
    }

    private static Date resolveDate(boolean start, String dateString) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        String[] dissect = dateString.split("-");
        ArrayList<Integer> dateVals = new ArrayList<Integer>();
        for (String dateElement : dissect) {
            dateVals.add(Integer.parseInt(dateElement));
        }
        if (dateVals.isEmpty()) {
            throw new IllegalArgumentException("Invalid date");
        }
        calendar.setTimeZone(TimeZone.getDefault());
        calendar.set(1, (Integer)dateVals.get(0));
        if (dateVals.size() > 1) {
            calendar.set(2, (Integer)dateVals.get(1) - 1);
        } else if (start) {
            calendar.set(2, 0);
        } else {
            calendar.set(2, 11);
        }
        if (dateVals.size() > 2) {
            calendar.set(5, (Integer)dateVals.get(2));
        } else if (start) {
            calendar.set(5, 1);
        } else {
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
        }
        if (start) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return Date.from(calendar.toInstant());
    }
}

