/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Factory;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.measure.CareGapsProperties;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.constant.HtmlConstants;
import org.opencds.cqf.fhir.cr.measure.enumeration.CareGapsStatusCode;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureProcessor;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.Resources;
import org.opencds.cqf.fhir.utility.builder.BundleBuilder;
import org.opencds.cqf.fhir.utility.builder.CodeableConceptSettings;
import org.opencds.cqf.fhir.utility.builder.CompositionBuilder;
import org.opencds.cqf.fhir.utility.builder.CompositionSectionComponentBuilder;
import org.opencds.cqf.fhir.utility.builder.DetectedIssueBuilder;
import org.opencds.cqf.fhir.utility.builder.NarrativeSettings;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.opencds.cqf.fhir.utility.search.Searches;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R4CareGapsService {
    private static final Logger ourLog = LoggerFactory.getLogger(R4CareGapsService.class);
    public static final Map<String, CodeableConceptSettings> CARE_GAPS_CODES = ImmutableMap.of((Object)"http://loinc.org/96315-7", (Object)new CodeableConceptSettings().add("http://loinc.org", "96315-7", "Gaps in care report"), (Object)"http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP", (Object)new CodeableConceptSettings().add("http://terminology.hl7.org/CodeSystem/v3-ActCode", "CAREGAP", "Care Gaps"));
    private final Repository myRepository;
    private final MeasureEvaluationOptions myMeasureEvaluationOptions;
    private static final FhirContext fhirContext = FhirContext.forCached((FhirVersionEnum)FhirVersionEnum.R4);
    private CareGapsProperties myCareGapsProperties;
    private Executor myCqlExecutor;
    private String myServerBase;
    private final Map<String, Resource> myConfiguredResources = new HashMap<String, Resource>();

    public R4CareGapsService(CareGapsProperties theCareGapsProperties, Repository theRepository, MeasureEvaluationOptions theMeasureEvaluationOptions, Executor theExecutor, String theServerBase) {
        this.myRepository = theRepository;
        this.myCareGapsProperties = theCareGapsProperties;
        this.myMeasureEvaluationOptions = theMeasureEvaluationOptions;
        this.myCqlExecutor = theExecutor;
        this.myServerBase = theServerBase;
    }

    public Parameters getCareGapsReport(IPrimitiveType<Date> thePeriodStart, IPrimitiveType<Date> thePeriodEnd, List<String> theTopic, String theSubject, String thePractitioner, String theOrganization, List<String> theStatuses, List<String> theMeasureIds, List<String> theMeasureIdentifiers, List<CanonicalType> theMeasureUrls, List<String> thePrograms) {
        this.validateConfiguration();
        List<Measure> measures = this.ensureMeasures(this.getMeasures(theMeasureIds, theMeasureIdentifiers, theMeasureUrls));
        if (Strings.isNullOrEmpty((String)theSubject)) {
            throw new NotImplementedOperationException(Msg.code((int)2275) + "Only the subject parameter has been implemented.");
        }
        List<Patient> patients = this.getPatientListFromSubject(theSubject);
        ArrayList futures = new ArrayList();
        Parameters result = this.initializeResult();
        if (this.myCareGapsProperties.getThreadedCareGapsEnabled()) {
            patients.forEach(patient -> {
                Parameters.ParametersParameterComponent patientReports = this.patientReports(thePeriodStart.getValueAsString(), thePeriodEnd.getValueAsString(), (Patient)patient, theStatuses, measures, theOrganization);
                futures.add(CompletableFuture.supplyAsync(() -> patientReports, this.myCqlExecutor));
            });
            futures.forEach(x -> result.addParameter((Parameters.ParametersParameterComponent)x.join()));
        } else {
            patients.forEach(patient -> {
                Parameters.ParametersParameterComponent patientReports = this.patientReports(thePeriodStart.getValueAsString(), thePeriodEnd.getValueAsString(), (Patient)patient, theStatuses, measures, theOrganization);
                if (patientReports != null) {
                    result.addParameter(patientReports);
                }
            });
        }
        return result;
    }

    public void validateConfiguration() {
        Preconditions.checkNotNull((Object)this.myCareGapsProperties, (Object)"Setting care-gaps properties are required for the $care-gaps operation.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.myCareGapsProperties.getCareGapsReporter()) ? 1 : 0) != 0, (Object)"Setting care-gaps properties.care_gaps_reporter setting is required for the $care-gaps operation.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.myCareGapsProperties.getCareGapsCompositionSectionAuthor()) ? 1 : 0) != 0, (Object)"Setting care-gaps properties.care_gaps_composition_section_author is required for the $care-gaps operation.");
        Preconditions.checkNotNull((Object)(!Strings.isNullOrEmpty((String)this.myServerBase) ? 1 : 0), (Object)"The fhirBaseUrl setting is required for the $care-gaps operation.");
        Organization configuredReporter = this.addConfiguredResource(Organization.class, this.myCareGapsProperties.getCareGapsReporter(), "care_gaps_reporter");
        Organization configuredAuthor = this.addConfiguredResource(Organization.class, this.myCareGapsProperties.getCareGapsCompositionSectionAuthor(), "care_gaps_composition_section_author");
        Preconditions.checkNotNull((Object)configuredReporter, (Object)String.format("The %s Resource is configured as the CareGapsProperties.care_gaps_reporter but the Resource could not be read.", this.myCareGapsProperties.getCareGapsReporter()));
        Preconditions.checkNotNull((Object)configuredAuthor, (Object)String.format("The %s Resource is configured as the CareGapsProperties.care_gaps_composition_section_author but the Resource could not be read.", this.myCareGapsProperties.getCareGapsCompositionSectionAuthor()));
    }

    List<Patient> getPatientListFromSubject(String theSubject) {
        if (theSubject.startsWith("Patient/")) {
            return Collections.singletonList(this.validatePatientExists(theSubject));
        }
        if (theSubject.startsWith("Group/")) {
            return this.getPatientListFromGroup(theSubject);
        }
        ourLog.info("Subject member was not a Patient or a Group, so skipping. \n{}", (Object)theSubject);
        return Collections.emptyList();
    }

    List<Patient> getPatientListFromGroup(String theSubjectGroupId) {
        ArrayList<Patient> patientList = new ArrayList<Patient>();
        Group group = (Group)this.myRepository.read(Group.class, (IIdType)Factory.newId((String)theSubjectGroupId));
        if (group == null) {
            throw new IllegalArgumentException(Msg.code((int)2276) + "Could not find Group: " + theSubjectGroupId);
        }
        group.getMember().forEach(member -> {
            Reference reference = member.getEntity();
            if (reference.getReferenceElement().getResourceType().equals("Patient")) {
                Patient patient = this.validatePatientExists(reference.getReference());
                patientList.add(patient);
            } else if (reference.getReferenceElement().getResourceType().equals("Group")) {
                patientList.addAll(this.getPatientListFromGroup(reference.getReference()));
            } else {
                ourLog.info("Group member was not a Patient or a Group, so skipping. \n{}", (Object)reference.getReference());
            }
        });
        return patientList;
    }

    Patient validatePatientExists(String thePatientRef) {
        Patient patient = (Patient)this.myRepository.read(Patient.class, (IIdType)new IdType(thePatientRef));
        if (patient == null) {
            throw new IllegalArgumentException(Msg.code((int)2277) + "Could not find Patient: " + thePatientRef);
        }
        return patient;
    }

    List<Measure> getMeasures(List<String> theMeasureIds, List<String> theMeasureIdentifiers, List<CanonicalType> theMeasureCanonicals) {
        int i;
        boolean hasMeasureUrls;
        boolean hasMeasureIds = theMeasureIds != null && !theMeasureIds.isEmpty();
        boolean hasMeasureIdentifiers = theMeasureIdentifiers != null && !theMeasureIdentifiers.isEmpty();
        boolean bl = hasMeasureUrls = theMeasureCanonicals != null && !theMeasureCanonicals.isEmpty();
        if (!(hasMeasureIds || hasMeasureIdentifiers || hasMeasureUrls)) {
            return Collections.emptyList();
        }
        ArrayList<Measure> measureList = new ArrayList<Measure>();
        if (hasMeasureIds) {
            for (i = 0; i < theMeasureIds.size(); ++i) {
                Measure measureById = this.resolveById(new IdType("Measure", theMeasureIds.get(i)));
                measureList.add(measureById);
            }
        }
        if (hasMeasureUrls) {
            for (i = 0; i < theMeasureCanonicals.size(); ++i) {
                Measure measureByUrl = this.resolveByUrl(theMeasureCanonicals.get(i));
                measureList.add(measureByUrl);
            }
        }
        if (hasMeasureIdentifiers) {
            throw new NotImplementedOperationException(Msg.code((int)2278) + "Measure identifiers have not yet been implemented.");
        }
        HashMap result = new HashMap();
        measureList.forEach(measure -> result.putIfAbsent(measure.getUrl(), measure));
        return new ArrayList<Measure>(result.values());
    }

    protected Measure resolveByUrl(CanonicalType url) {
        Canonicals.CanonicalParts parts = Canonicals.getParts((IPrimitiveType)url);
        Bundle result = (Bundle)this.myRepository.search(Bundle.class, Measure.class, Searches.byNameAndVersion((String)parts.idPart(), (String)parts.version()));
        return (Measure)result.getEntryFirstRep().getResource();
    }

    protected Measure resolveById(IdType id) {
        return (Measure)this.myRepository.read(Measure.class, (IIdType)id);
    }

    private <T extends Resource> T addConfiguredResource(Class<T> theResourceClass, String theId, String theKey) {
        Resource resource = null;
        resource = (Resource)this.myRepository.read(theResourceClass, (IIdType)new IdType(theId));
        this.myConfiguredResources.put(theKey, resource);
        return (T)resource;
    }

    private List<Measure> ensureMeasures(List<Measure> theMeasures) {
        theMeasures.forEach(measure -> {
            if (!measure.hasScoring()) {
                ourLog.info("Measure does not specify a scoring so skipping: {}.", (Object)measure.getId());
                theMeasures.remove(measure);
            }
            if (!measure.hasImprovementNotation()) {
                ourLog.info("Measure does not specify an improvement notation so skipping: {}.", (Object)measure.getId());
                theMeasures.remove(measure);
            }
        });
        return theMeasures;
    }

    private Parameters.ParametersParameterComponent patientReports(String thePeriodStart, String thePeriodEnd, Patient thePatient, List<String> theStatuses, List<Measure> theMeasures, String theOrganization) {
        HashMap<String, Resource> evalPlusSDE;
        ArrayList<DetectedIssue> detectedIssues;
        Composition composition = this.getComposition(thePatient);
        List<MeasureReport> reports = this.getReports(thePeriodStart, thePeriodEnd, thePatient, theStatuses, theMeasures, composition, detectedIssues = new ArrayList<DetectedIssue>(), evalPlusSDE = new HashMap<String, Resource>());
        if (reports.isEmpty()) {
            return null;
        }
        return this.initializePatientParameter(thePatient).setResource((Resource)this.addBundleEntries(this.myServerBase, composition, detectedIssues, reports, evalPlusSDE));
    }

    private List<MeasureReport> getReports(String thePeriodStart, String thePeriodEnd, Patient thePatient, List<String> theStatuses, List<Measure> theMeasures, Composition theComposition, List<DetectedIssue> theDetectedIssues, Map<String, Resource> theEvalPlusSDEs) {
        ArrayList<MeasureReport> reports = new ArrayList<MeasureReport>();
        String theReportType = MeasureReportType.INDIVIDUAL.toString();
        R4MeasureProcessor r4MeasureProcessor = new R4MeasureProcessor(this.myRepository, this.myMeasureEvaluationOptions, new R4RepositorySubjectProvider());
        for (Measure measure : theMeasures) {
            List<String> subjects = Collections.singletonList(Ids.simple((IBaseResource)thePatient));
            MeasureReport report = r4MeasureProcessor.evaluateMeasure((Either3<CanonicalType, IdType, Measure>)Eithers.forMiddle3((Object)measure.getIdElement()), thePeriodStart, thePeriodEnd, theReportType, subjects, null);
            if (!report.hasGroup()) {
                ourLog.info("Report does not include a group so skipping.\nSubject: {}\nMeasure: {}", (Object)Ids.simple((IBaseResource)thePatient), (Object)Ids.simplePart((IBaseResource)measure));
                continue;
            }
            this.initializeReport(report);
            CareGapsStatusCode gapStatus = this.getGapStatus(measure, report);
            if (!theStatuses.contains(gapStatus.toString())) continue;
            DetectedIssue detectedIssue = this.getDetectedIssue(thePatient, report, gapStatus);
            theDetectedIssues.add(detectedIssue);
            theComposition.addSection(this.getSection(measure, report, detectedIssue, gapStatus));
            this.populateEvaluatedResources(report, theEvalPlusSDEs);
            this.populateSDEResources(report, theEvalPlusSDEs);
            reports.add(report);
        }
        return reports;
    }

    private void initializeReport(MeasureReport theMeasureReport) {
        if (Strings.isNullOrEmpty((String)theMeasureReport.getId())) {
            IIdType id = Ids.newId(MeasureReport.class, (String)UUID.randomUUID().toString());
            theMeasureReport.setId(id);
        }
        Reference reporter = new Reference().setReference(this.myCareGapsProperties.getCareGapsReporter());
        theMeasureReport.setReporter(reporter);
        if (theMeasureReport.hasMeta()) {
            theMeasureReport.getMeta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm");
        } else {
            theMeasureReport.setMeta(new Meta().addProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/indv-measurereport-deqm"));
        }
    }

    private Parameters.ParametersParameterComponent initializePatientParameter(Patient thePatient) {
        Parameters.ParametersParameterComponent patientParameter = ((Parameters.ParametersParameterComponent)Resources.newBackboneElement(Parameters.ParametersParameterComponent.class)).setName("return");
        patientParameter.setId("subject-" + Ids.simplePart((IBaseResource)thePatient));
        return patientParameter;
    }

    private Bundle addBundleEntries(String theServerBase, Composition theComposition, List<DetectedIssue> theDetectedIssues, List<MeasureReport> theMeasureReports, Map<String, Resource> theEvalPlusSDEs) {
        Bundle reportBundle = this.getBundle();
        reportBundle.addEntry(this.getBundleEntry(theServerBase, (Resource)theComposition));
        theMeasureReports.forEach(report -> reportBundle.addEntry(this.getBundleEntry(theServerBase, (Resource)report)));
        theDetectedIssues.forEach(detectedIssue -> reportBundle.addEntry(this.getBundleEntry(theServerBase, (Resource)detectedIssue)));
        this.myConfiguredResources.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(theServerBase, (Resource)resource)));
        theEvalPlusSDEs.values().forEach(resource -> reportBundle.addEntry(this.getBundleEntry(theServerBase, (Resource)resource)));
        return reportBundle;
    }

    private CareGapsStatusCode getGapStatus(Measure theMeasure, MeasureReport theMeasureReport) {
        MutablePair inNumerator = new MutablePair((Object)"numerator", (Object)false);
        theMeasureReport.getGroup().forEach(arg_0 -> R4CareGapsService.lambda$getGapStatus$12((Pair)inNumerator, arg_0));
        boolean isPositive = theMeasure.getImprovementNotation().hasCoding("http://terminology.hl7.org/CodeSystem/measure-improvement-notation", "increase");
        if (isPositive && !((Boolean)inNumerator.getValue()).booleanValue() || !isPositive && ((Boolean)inNumerator.getValue()).booleanValue()) {
            return CareGapsStatusCode.OPEN_GAP;
        }
        return CareGapsStatusCode.CLOSED_GAP;
    }

    private Bundle.BundleEntryComponent getBundleEntry(String theServerBase, Resource theResource) {
        return new Bundle.BundleEntryComponent().setResource(theResource).setFullUrl(R4CareGapsService.getFullUrl(theServerBase, (IBaseResource)theResource));
    }

    private Composition.SectionComponent getSection(Measure theMeasure, MeasureReport theMeasureReport, DetectedIssue theDetectedIssue, CareGapsStatusCode theGapStatus) {
        String narrative = String.format(HtmlConstants.HTML_DIV_PARAGRAPH_CONTENT, theGapStatus == CareGapsStatusCode.CLOSED_GAP ? "No detected issues." : String.format("Issues detected.  See %s for details.", Ids.simple((IBaseResource)theDetectedIssue)));
        return (Composition.SectionComponent)new CompositionSectionComponentBuilder(Composition.SectionComponent.class).withTitle(theMeasure.hasTitle() ? theMeasure.getTitle() : theMeasure.getUrl()).withFocus(Ids.simple((IBaseResource)theMeasureReport)).withText(new NarrativeSettings(narrative)).withEntry(Ids.simple((IBaseResource)theDetectedIssue)).build();
    }

    private Bundle getBundle() {
        return (Bundle)((BundleBuilder)new BundleBuilder(Bundle.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-bundle-deqm")).withType(Bundle.BundleType.DOCUMENT.toString()).build();
    }

    private Composition getComposition(Patient thePatient) {
        return (Composition)((CompositionBuilder)new CompositionBuilder(Composition.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-composition-deqm")).withType(CARE_GAPS_CODES.get("http://loinc.org/96315-7")).withStatus(Composition.CompositionStatus.FINAL.toString()).withTitle("Care Gap Report for " + Ids.simplePart((IBaseResource)thePatient)).withSubject(Ids.simple((IBaseResource)thePatient)).withAuthor(Ids.simple((IBaseResource)((IBaseResource)this.myConfiguredResources.get("care_gaps_composition_section_author")))).build();
    }

    private DetectedIssue getDetectedIssue(Patient thePatient, MeasureReport theMeasureReport, CareGapsStatusCode theCareGapStatusCode) {
        return (DetectedIssue)((DetectedIssueBuilder)((DetectedIssueBuilder)new DetectedIssueBuilder(DetectedIssue.class).withProfile("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/gaps-detectedissue-deqm")).withStatus(DetectedIssue.DetectedIssueStatus.FINAL.toString()).withCode(CARE_GAPS_CODES.get("http://terminology.hl7.org/CodeSystem/v3-ActCode/CAREGAP")).withPatient(Ids.simple((IBaseResource)thePatient)).withEvidenceDetail(Ids.simple((IBaseResource)theMeasureReport)).withModifierExtension((Pair)new ImmutablePair((Object)"http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-gapStatus", (Object)new CodeableConceptSettings().add("http://hl7.org/fhir/us/davinci-deqm/CodeSystem/gaps-status", theCareGapStatusCode.toString(), theCareGapStatusCode.toDisplayString())))).build();
    }

    protected void populateEvaluatedResources(MeasureReport theMeasureReport, Map<String, Resource> theResources) {
        theMeasureReport.getEvaluatedResource().forEach(evaluatedResource -> {
            IIdType resourceId = evaluatedResource.getReferenceElement();
            if (resourceId.getResourceType() == null || theResources.containsKey(Ids.simple((IIdType)resourceId))) {
                return;
            }
            Class<?> resourceType = ((IBaseResource)fhirContext.getResourceDefinition(resourceId.getResourceType()).newInstance()).getClass();
            IBaseResource resource = this.myRepository.read(resourceType, resourceId);
            if (resource instanceof Resource) {
                Resource resourceBase = (Resource)resource;
                theResources.put(Ids.simple((IIdType)resourceId), resourceBase);
            }
        });
    }

    protected void populateSDEResources(MeasureReport theMeasureReport, Map<String, Resource> theResources) {
        if (theMeasureReport.hasExtension()) {
            for (Extension extension : theMeasureReport.getExtension()) {
                Class<?> resourceType;
                IBaseResource resource;
                IdType sdeId;
                Reference sdeRef;
                if (!extension.hasUrl() || !extension.getUrl().equals("http://hl7.org/fhir/us/davinci-deqm/StructureDefinition/extension-supplementalData") || (sdeRef = extension.hasValue() && extension.getValue() instanceof Reference ? (Reference)extension.getValue() : null) == null || !sdeRef.hasReference() || sdeRef.getReference().startsWith("#") || theResources.containsKey(Ids.simple((IIdType)(sdeId = new IdType(sdeRef.getReference())))) || !((resource = this.myRepository.read(resourceType = ((IBaseResource)fhirContext.getResourceDefinition(sdeId.getResourceType()).newInstance()).getClass(), (IIdType)sdeId)) instanceof Resource)) continue;
                Resource resourceBase = (Resource)resource;
                theResources.put(Ids.simple((IIdType)sdeId), resourceBase);
            }
        }
    }

    private Parameters initializeResult() {
        return (Parameters)Resources.newResource(Parameters.class, (String)("care-gaps-report-" + UUID.randomUUID()));
    }

    public static String getFullUrl(String theServerAddress, IBaseResource theResource) {
        Preconditions.checkArgument((boolean)theResource.getIdElement().hasIdPart(), (Object)"Cannot generate a fullUrl because the resource does not have an id.");
        return R4CareGapsService.getFullUrl(theServerAddress, theResource.fhirType(), Ids.simplePart((IBaseResource)theResource));
    }

    public static String getFullUrl(String theServerAddress, String theFhirType, String theElementId) {
        return String.format("%s%s/%s", theServerAddress + (theServerAddress.endsWith("/") ? "" : "/"), theFhirType, theElementId);
    }

    public CareGapsProperties getCareGapsProperties() {
        return this.myCareGapsProperties;
    }

    private static /* synthetic */ void lambda$getGapStatus$12(Pair inNumerator, MeasureReport.MeasureReportGroupComponent group) {
        group.getPopulation().forEach(population -> {
            if (population.hasCode() && population.getCode().hasCoding("http://terminology.hl7.org/CodeSystem/measure-population", (String)inNumerator.getKey()) && population.getCount() == 1) {
                inNumerator.setValue((Object)true);
            }
        });
    }
}

