/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.VersionedIdentifiers;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.cr.measure.helper.DateHelper;
import org.opencds.cqf.fhir.cr.measure.r4.R4MeasureEvaluation;
import org.opencds.cqf.fhir.cr.measure.r4.R4RepositorySubjectProvider;
import org.opencds.cqf.fhir.utility.Canonicals;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;
import org.opencds.cqf.fhir.utility.search.Searches;

@Named
public class R4MeasureProcessor {
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final SubjectProvider subjectProvider;

    public R4MeasureProcessor(Repository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this(repository, measureEvaluationOptions, new R4RepositorySubjectProvider());
    }

    public R4MeasureProcessor(Repository repository, MeasureEvaluationOptions measureEvaluationOptions, SubjectProvider subjectProvider) {
        this.repository = Objects.requireNonNull(repository);
        this.measureEvaluationOptions = measureEvaluationOptions != null ? measureEvaluationOptions : MeasureEvaluationOptions.defaultOptions();
        this.subjectProvider = subjectProvider;
    }

    public MeasureReport evaluateMeasure(Either3<CanonicalType, IdType, Measure> measure, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData) {
        Measure m = (Measure)measure.fold(this::resolveByUrl, this::resolveById, Function.identity());
        return this.evaluateMeasure(m, periodStart, periodEnd, reportType, subjectIds, additionalData);
    }

    protected MeasureReport evaluateMeasure(Measure measure, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData) {
        if (!measure.hasLibrary()) {
            throw new IllegalArgumentException(String.format("Measure %s does not have a primary library specified", measure.getUrl()));
        }
        Interval measurementPeriod = null;
        if (StringUtils.isNotBlank((CharSequence)periodStart) && StringUtils.isNotBlank((CharSequence)periodEnd)) {
            measurementPeriod = this.buildMeasurementPeriod(periodStart, periodEnd);
        }
        VersionedIdentifier id = VersionedIdentifiers.forUrl((String)((CanonicalType)measure.getLibrary().get(0)).asStringValue());
        CqlEngine context = Engines.forRepositoryAndSettings((EvaluationSettings)this.measureEvaluationOptions.getEvaluationSettings(), (Repository)this.repository, (IBaseBundle)additionalData);
        CompiledLibrary lib = context.getEnvironment().getLibraryManager().resolveLibrary(id);
        context.getState().init(lib.getLibrary());
        MeasureEvalType evalType = MeasureEvalType.fromCode(reportType).orElse(subjectIds == null || subjectIds.isEmpty() ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
        Repository actualRepo = this.repository;
        if (additionalData != null) {
            actualRepo = new FederatedRepository(this.repository, new Repository[]{new InMemoryFhirRepository(this.repository.fhirContext(), additionalData)});
        }
        List<String> subjects = this.subjectProvider.getSubjects(actualRepo, evalType, subjectIds).collect(Collectors.toList());
        R4MeasureEvaluation measureEvaluator = new R4MeasureEvaluation(context, measure);
        return (MeasureReport)measureEvaluator.evaluate(evalType, subjects, measurementPeriod);
    }

    protected Measure resolveByUrl(CanonicalType url) {
        Canonicals.CanonicalParts parts = Canonicals.getParts((IPrimitiveType)url);
        Bundle result = (Bundle)this.repository.search(Bundle.class, Measure.class, Searches.byNameAndVersion((String)parts.idPart(), (String)parts.version()));
        return (Measure)result.getEntryFirstRep().getResource();
    }

    protected Measure resolveById(IdType id) {
        return (Measure)this.repository.read(Measure.class, (IIdType)id);
    }

    protected MeasureReportType evalTypeToReportType(MeasureEvalType measureEvalType) {
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return MeasureReportType.INDIVIDUAL;
            }
            case PATIENTLIST: 
            case SUBJECTLIST: {
                return MeasureReportType.PATIENTLIST;
            }
            case POPULATION: {
                return MeasureReportType.SUMMARY;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported MeasureEvalType: %s", measureEvalType.toCode()));
    }

    private Interval buildMeasurementPeriod(String periodStart, String periodEnd) {
        return new Interval((Object)DateTime.fromJavaDate((Date)DateHelper.resolveRequestDate(periodStart, true)), true, (Object)DateTime.fromJavaDate((Date)DateHelper.resolveRequestDate(periodEnd, false)), true);
    }
}

