/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.dstu3;

import ca.uhn.fhir.util.ExtensionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cr.questionnaire.BaseQuestionnaireProcessor;
import org.opencds.cqf.fhir.cr.questionnaire.dstu3.ItemValueTransformer;
import org.opencds.cqf.fhir.utility.dstu3.PackageHelper;
import org.opencds.cqf.fhir.utility.dstu3.SearchHelper;

public class QuestionnaireProcessor
extends BaseQuestionnaireProcessor<Questionnaire> {
    protected OperationOutcome oc;
    protected Questionnaire populatedQuestionnaire;

    public QuestionnaireProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public QuestionnaireProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        super(repository, evaluationSettings);
    }

    @Override
    public <C extends IPrimitiveType<String>> Questionnaire resolveQuestionnaire(IIdType id, C canonical, IBaseResource questionnaire) {
        IBaseResource baseQuestionnaire = questionnaire;
        if (baseQuestionnaire == null) {
            baseQuestionnaire = id != null ? this.repository.read(Questionnaire.class, id) : (Questionnaire)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, canonical);
        }
        return QuestionnaireProcessor.castOrThrow((IBase)baseQuestionnaire, Questionnaire.class, "The Questionnaire passed to repository was not a valid instance of Questionnaire.class").orElse(null);
    }

    @Override
    public Questionnaire prePopulate(Questionnaire questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        if (questionnaire == null) {
            throw new IllegalArgumentException("No questionnaire passed in");
        }
        if (libraryEngine == null) {
            throw new IllegalArgumentException("No engine passed in");
        }
        this.patientId = patientId;
        this.parameters = parameters;
        this.bundle = bundle;
        this.libraryEngine = libraryEngine;
        this.libraryUrl = questionnaire.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-library") ? (String)((UriType)questionnaire.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library").getValue()).getValue() : null;
        this.populatedQuestionnaire = questionnaire.copy();
        this.populatedQuestionnaire.setId(questionnaire.getIdPart() + "-" + patientId);
        this.populatedQuestionnaire.addExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-prepopulate-subject", (Type)new Reference(Enumerations.FHIRAllTypes.PATIENT.toCode() + "/" + patientId));
        this.oc = new OperationOutcome();
        this.oc.setId("populate-outcome-" + this.populatedQuestionnaire.getIdPart());
        this.populatedQuestionnaire.setItem(this.processItems(questionnaire.getItem()));
        if (!this.oc.getIssue().isEmpty()) {
            this.populatedQuestionnaire.addContained((Resource)this.oc);
            this.populatedQuestionnaire.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new Reference("#" + this.oc.getIdPart()));
        }
        return this.populatedQuestionnaire;
    }

    private List<IBase> getExpressionResult(CqfExpression expression, String itemLinkId) {
        try {
            return this.libraryEngine.resolveExpression(this.patientId, expression, this.parameters, this.bundle);
        }
        catch (Exception ex) {
            String message = String.format("Error encountered evaluating expression (%s) for item (%s): %s", expression.getExpression(), itemLinkId, ex.getMessage());
            logger.error(message);
            this.oc.addIssue().setCode(OperationOutcome.IssueType.EXCEPTION).setSeverity(OperationOutcome.IssueSeverity.ERROR).setDiagnostics(message);
            return null;
        }
    }

    private CqfExpression getInitialExpression(Questionnaire.QuestionnaireItemComponent item) {
        Extension expressionExtension = null;
        if (item.hasExtension("http://hl7.org/fhir/StructureDefinition/cqf-expression")) {
            expressionExtension = item.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-expression");
        } else if (item.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression")) {
            expressionExtension = item.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-initialExpression");
        }
        if (expressionExtension == null) {
            return null;
        }
        IBaseExtension languageExtension = ExtensionUtil.getExtensionByUrl((IBase)item, (String)"http://hl7.org/fhir/StructureDefinition/cqf-expression-language");
        return new CqfExpression(languageExtension.getValue().toString(), expressionExtension.getValue().toString(), this.libraryUrl);
    }

    private void getInitial(Questionnaire.QuestionnaireItemComponent item) {
        List<IBase> results;
        CqfExpression initialExpression = this.getInitialExpression(item);
        if (initialExpression != null && (results = this.getExpressionResult(initialExpression, item.getLinkId())) != null && !results.isEmpty()) {
            for (IBase result : results) {
                if (result == null) continue;
                item.addExtension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author", (Type)new Reference("http://cqframework.org/fhir/Device/clinical-quality-language"));
                item.setInitial(ItemValueTransformer.transformValue((Type)result));
            }
        }
    }

    private CqfExpression getContextExpression(Questionnaire.QuestionnaireItemComponent item) {
        Extension contextExpressionExt = item.getExtensionByUrl("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
        if (contextExpressionExt == null) {
            return null;
        }
        IBaseExtension languageExtension = ExtensionUtil.getExtensionByUrl((IBase)item, (String)"http://hl7.org/fhir/StructureDefinition/cqf-expression-language");
        return new CqfExpression(languageExtension.getValue().toString(), contextExpressionExt.getValue().toString(), this.libraryUrl);
    }

    protected List<Questionnaire.QuestionnaireItemComponent> processItemWithContext(Questionnaire.QuestionnaireItemComponent groupItem) {
        ArrayList<Questionnaire.QuestionnaireItemComponent> populatedItems = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        List<IBase> populationContext = this.getExpressionResult(this.getContextExpression(groupItem), groupItem.getLinkId());
        if (populationContext == null || populationContext.isEmpty()) {
            return Collections.singletonList(groupItem.copy());
        }
        for (IBase context : populationContext) {
            Questionnaire.QuestionnaireItemComponent contextItem = groupItem.copy();
            for (Questionnaire.QuestionnaireItemComponent item : contextItem.getItem()) {
                String path = item.getDefinition().split("#")[1].split("\\.")[1];
                Property initialProperty = ((Base)context).getNamedProperty(path);
                if (!initialProperty.hasValues() || initialProperty.isList()) continue;
                item.addExtension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author", (Type)new Reference("http://cqframework.org/fhir/Device/clinical-quality-language"));
                item.setInitial(ItemValueTransformer.transformValue((Type)initialProperty.getValues().get(0)));
            }
            populatedItems.add(contextItem);
        }
        return populatedItems;
    }

    protected List<Questionnaire.QuestionnaireItemComponent> processItems(List<Questionnaire.QuestionnaireItemComponent> items) {
        ArrayList<Questionnaire.QuestionnaireItemComponent> populatedItems = new ArrayList<Questionnaire.QuestionnaireItemComponent>();
        items.forEach(item -> {
            if (item.hasExtension("http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext")) {
                populatedItems.addAll(this.processItemWithContext((Questionnaire.QuestionnaireItemComponent)item));
            } else {
                Questionnaire.QuestionnaireItemComponent populatedItem = item.copy();
                if (item.hasItem()) {
                    populatedItem.setItem(this.processItems(item.getItem()));
                } else {
                    this.getInitial(populatedItem);
                }
                populatedItems.add(populatedItem);
            }
        });
        return populatedItems;
    }

    @Override
    public IBaseResource populate(Questionnaire questionnaire, String patientId, IBaseParameters parameters, IBaseBundle bundle, LibraryEngine libraryEngine) {
        this.prePopulate(questionnaire, patientId, parameters, bundle, libraryEngine);
        QuestionnaireResponse response = new QuestionnaireResponse();
        response.setId(this.populatedQuestionnaire.getIdPart() + "-response");
        if (this.populatedQuestionnaire.hasExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages") && !this.oc.getIssue().isEmpty()) {
            response.addContained((Resource)this.oc);
            response.addExtension("http://hl7.org/fhir/uv/crmi/StructureDefinition/crmi-messages", (Type)new Reference("#" + this.oc.getIdPart()));
        }
        response.addContained((Resource)this.populatedQuestionnaire);
        response.addExtension("http://hl7.org/fhir/us/davinci-dtr/StructureDefinition/dtr-questionnaireresponse-questionnaire", (Type)new Reference("#" + this.populatedQuestionnaire.getIdPart()));
        response.setQuestionnaire(new Reference(questionnaire.getUrl()));
        response.setStatus(QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS);
        response.setSubject(new Reference((IIdType)new IdType("Patient", patientId)));
        ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> responseItems = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
        this.processResponseItems(this.populatedQuestionnaire.getItem(), responseItems);
        response.setItem(responseItems);
        return response;
    }

    protected void processResponseItems(List<Questionnaire.QuestionnaireItemComponent> items, List<QuestionnaireResponse.QuestionnaireResponseItemComponent> responseItems) {
        items.forEach(item -> {
            QuestionnaireResponse.QuestionnaireResponseItemComponent responseItem = new QuestionnaireResponse.QuestionnaireResponseItemComponent(item.getLinkIdElement());
            responseItem.setDefinition(item.getDefinition());
            responseItem.setTextElement(item.getTextElement());
            if (item.hasItem()) {
                ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent> nestedResponseItems = new ArrayList<QuestionnaireResponse.QuestionnaireResponseItemComponent>();
                this.processResponseItems(item.getItem(), nestedResponseItems);
                responseItem.setItem(nestedResponseItems);
            } else if (item.hasInitial()) {
                if (item.hasExtension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author")) {
                    responseItem.addExtension(item.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author"));
                }
                QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent answer = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue(item.getInitial());
                responseItem.addAnswer(answer);
            }
            responseItems.add(responseItem);
        });
    }

    @Override
    public Questionnaire generateQuestionnaire(String id) {
        Questionnaire questionnaire = new Questionnaire();
        questionnaire.setId((IIdType)new IdType("Questionnaire", id));
        return questionnaire;
    }

    public Bundle packageQuestionnaire(Questionnaire questionnaire, boolean isPut) {
        UriType libraryCanonical;
        Library library;
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        bundle.addEntry(PackageHelper.createEntry((Resource)questionnaire, (boolean)isPut));
        Extension libraryExtension = questionnaire.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        if (libraryExtension != null && (library = (Library)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)(libraryCanonical = (UriType)libraryExtension.getValue()))) != null) {
            bundle.addEntry(PackageHelper.createEntry((Resource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                PackageHelper.addRelatedArtifacts((Bundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        return bundle;
    }
}

