/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.r4.generator.questionnaireitem;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.StructureDefinition;

public class QuestionnaireItemService {
    public Questionnaire.QuestionnaireItemComponent createQuestionnaireItem(DataRequirement actionInput, String linkId, StructureDefinition profile) {
        String definition = this.getDefinition(profile);
        String text = this.getProfileText(profile);
        if (actionInput.hasExtension("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-text")) {
            text = actionInput.getExtensionString("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-text");
        }
        Questionnaire.QuestionnaireItemComponent item = this.createQuestionnaireItemComponent(text, linkId, definition);
        item.setExtension(this.copyExtensions(actionInput.getExtension(), profile.getExtension()));
        return item;
    }

    protected List<Extension> copyExtensions(List<Extension> inputExtensions, List<Extension> profileExtensions) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        inputExtensions.forEach(ext -> {
            if (ext.getUrl().equals("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-input-description") && extensions.stream().noneMatch(e -> e.getUrl().equals(ext.getUrl()))) {
                extensions.add((Extension)ext);
            }
        });
        return extensions.isEmpty() ? null : extensions;
    }

    protected String getProfileText(StructureDefinition profile) {
        return profile.hasTitle() ? profile.getTitle() : profile.getUrl().substring(profile.getUrl().lastIndexOf("/") + 1);
    }

    protected Questionnaire.QuestionnaireItemComponent createQuestionnaireItemComponent(String text, String linkId, String definition) {
        return new Questionnaire.QuestionnaireItemComponent().setType(Questionnaire.QuestionnaireItemType.GROUP).setDefinition(definition).setLinkId(linkId).setText(text);
    }

    protected String getDefinition(StructureDefinition profile) {
        return String.format("%s#%s", profile.getUrl(), profile.getType());
    }
}

