/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.common;

import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.elm.r1.ExpressionDef;
import org.hl7.elm.r1.FunctionDef;
import org.hl7.elm.r1.IntervalTypeSpecifier;
import org.hl7.elm.r1.Library;
import org.hl7.elm.r1.NamedTypeSpecifier;
import org.hl7.elm.r1.OperandDef;
import org.hl7.elm.r1.ParameterDef;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.execution.Libraries;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;
import org.opencds.cqf.fhir.cr.measure.common.PopulationDef;
import org.opencds.cqf.fhir.cr.measure.common.SdeDef;
import org.opencds.cqf.fhir.cr.measure.common.StratifierDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MeasureEvaluator.class);
    protected CqlEngine context;
    protected String measurementPeriodParameterName = null;

    public MeasureEvaluator(CqlEngine context, String measurementPeriodParameterName) {
        this.context = Objects.requireNonNull(context, "context is a required argument");
        this.measurementPeriodParameterName = Objects.requireNonNull(measurementPeriodParameterName, "measurementPeriodParameterName is a required argument");
    }

    public MeasureDef evaluate(MeasureDef measureDef, MeasureEvalType measureEvalType, List<String> subjectIds, Interval measurementPeriod) {
        Objects.requireNonNull(measureDef, "measureDef is a required argument");
        Objects.requireNonNull(subjectIds, "subjectIds is a required argument");
        if (measureEvalType == null) {
            measureEvalType = subjectIds.size() > 1 ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT;
        }
        this.setMeasurementPeriod(measurementPeriod);
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return this.evaluate(measureDef, MeasureReportType.INDIVIDUAL, subjectIds);
            }
            case SUBJECTLIST: {
                return this.evaluate(measureDef, MeasureReportType.SUBJECTLIST, subjectIds);
            }
            case PATIENTLIST: {
                return this.evaluate(measureDef, MeasureReportType.PATIENTLIST, subjectIds);
            }
            case POPULATION: {
                return this.evaluate(measureDef, MeasureReportType.SUMMARY, subjectIds);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported Measure Evaluation type: %s", measureEvalType.getDisplay()));
    }

    protected ParameterDef getMeasurementPeriodParameterDef() {
        Library lib = this.context.getState().getCurrentLibrary();
        if (lib.getParameters() == null || lib.getParameters().getDef() == null || lib.getParameters().getDef().isEmpty()) {
            return null;
        }
        for (ParameterDef pd : lib.getParameters().getDef()) {
            if (this.measurementPeriodParameterName == null || !pd.getName().equals(this.measurementPeriodParameterName)) continue;
            return pd;
        }
        return null;
    }

    protected void setMeasurementPeriod(Interval measurementPeriod) {
        ParameterDef pd = this.getMeasurementPeriodParameterDef();
        if (measurementPeriod == null && pd.getDefault() == null) {
            logger.warn("No default or value supplied for Parameter \"{}\". This may result in incorrect results or errors.", (Object)this.measurementPeriodParameterName);
            return;
        }
        if (pd == null) {
            logger.warn("Parameter \"{}\" was not found. Unable to validate type.", (Object)this.measurementPeriodParameterName);
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)measurementPeriod);
            return;
        }
        if (measurementPeriod == null) {
            measurementPeriod = (Interval)this.context.getEvaluationVisitor().visitParameterDef(pd, (Object)this.context.getState());
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)measurementPeriod);
            return;
        }
        IntervalTypeSpecifier intervalTypeSpecifier = (IntervalTypeSpecifier)pd.getParameterTypeSpecifier();
        if (intervalTypeSpecifier == null) {
            logger.debug("No ELM type information available. Unable to validate type of \"{}\"", (Object)this.measurementPeriodParameterName);
            this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)measurementPeriod);
            return;
        }
        NamedTypeSpecifier pointType = (NamedTypeSpecifier)intervalTypeSpecifier.getPointType();
        String targetType = pointType.getName().getLocalPart();
        Interval convertedPeriod = this.convertInterval(measurementPeriod, targetType);
        this.context.getState().setParameter(null, this.measurementPeriodParameterName, (Object)convertedPeriod);
    }

    protected Interval convertInterval(Interval interval, String targetType) {
        String sourceTypeQualified = interval.getPointType().getTypeName();
        String sourceType = sourceTypeQualified.substring(sourceTypeQualified.lastIndexOf(".") + 1, sourceTypeQualified.length());
        if (sourceType.equals(targetType)) {
            return interval;
        }
        if (sourceType.equals("DateTime") && targetType.equals("Date")) {
            logger.debug("A DateTime interval was provided and a Date interval was expected. The DateTime will be truncated.");
            return new Interval((Object)this.truncateDateTime((DateTime)interval.getLow()), interval.getLowClosed(), (Object)this.truncateDateTime((DateTime)interval.getHigh()), interval.getHighClosed());
        }
        throw new IllegalArgumentException(String.format("The interval type of %s did not match the expected type of %s and no conversion was possible.", sourceType, targetType));
    }

    protected Date truncateDateTime(DateTime dateTime) {
        OffsetDateTime odt = dateTime.getDateTime();
        return new Date(odt.getYear(), odt.getMonthValue(), odt.getDayOfMonth());
    }

    protected Pair<String, String> getSubjectTypeAndId(String subjectId) {
        if (subjectId.contains("/")) {
            String[] subjectIdParts = subjectId.split("/");
            return Pair.of((Object)subjectIdParts[0], (Object)subjectIdParts[1]);
        }
        throw new IllegalArgumentException(String.format("Unable to determine Subject type for id: %s. SubjectIds must be in the format {subjectType}/{subjectId} (e.g. Patient/123)", subjectId));
    }

    protected void captureEvaluatedResources(Set<Object> outEvaluatedResources) {
        if (outEvaluatedResources != null && this.context.getState().getEvaluatedResources() != null) {
            for (Object o : this.context.getState().getEvaluatedResources()) {
                outEvaluatedResources.add(o);
            }
        }
        this.clearEvaluatedResources();
    }

    private void clearEvaluatedResources() {
        this.context.getState().clearEvaluatedResources();
    }

    protected MeasureDef evaluate(MeasureDef measureDef, MeasureReportType type, List<String> subjectIds) {
        logger.info("Evaluating Measure {}, report type {}, with {} subject(s)", new Object[]{measureDef.url(), type.toCode(), subjectIds.size()});
        MeasureScoring scoring = measureDef.scoring();
        if (scoring == null) {
            throw new RuntimeException("MeasureScoring type is required in order to calculate.");
        }
        for (String subjectId : subjectIds) {
            if (subjectId == null) {
                throw new RuntimeException("SubjectId is required in order to calculate.");
            }
            Pair<String, String> subjectInfo = this.getSubjectTypeAndId(subjectId);
            String subjectTypePart = (String)subjectInfo.getLeft();
            String subjectIdPart = (String)subjectInfo.getRight();
            this.context.getState().setContextValue(subjectTypePart, (Object)subjectIdPart);
            this.evaluateSubject(measureDef, scoring, subjectTypePart, subjectIdPart);
        }
        return measureDef;
    }

    protected void evaluateSubject(MeasureDef measureDef, MeasureScoring scoring, String subjectType, String subjectId) {
        this.evaluateSdes(subjectId, measureDef.sdes());
        for (GroupDef groupDef : measureDef.groups()) {
            this.evaluateGroup(scoring, groupDef, subjectType, subjectId);
        }
    }

    protected Iterable<Object> evaluatePopulationCriteria(String subjectType, String subjectId, String criteriaExpression, Set<Object> outEvaluatedResources) {
        if (criteriaExpression == null || criteriaExpression.isEmpty()) {
            return Collections.emptyList();
        }
        Object result = this.evaluateCriteria(criteriaExpression, outEvaluatedResources);
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof Boolean) {
            if (Boolean.TRUE.equals(result)) {
                ExpressionDef ref = Libraries.resolveExpressionRef((String)subjectType, (Library)this.context.getState().getCurrentLibrary());
                Object booleanResult = this.context.getEvaluationVisitor().visitExpressionDef(ref, this.context.getState());
                this.clearEvaluatedResources();
                return Collections.singletonList(booleanResult);
            }
            return Collections.emptyList();
        }
        return (Iterable)result;
    }

    protected Object evaluateCriteria(String criteriaExpression, Set<Object> outEvaluatedResources) {
        ExpressionDef ref = Libraries.resolveExpressionRef((String)criteriaExpression, (Library)this.context.getState().getCurrentLibrary());
        Object result = this.context.getEvaluationVisitor().visitExpressionDef(ref, this.context.getState());
        this.captureEvaluatedResources(outEvaluatedResources);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateObservationCriteria(Object resource, String criteriaExpression, Set<Object> outEvaluatedResources) {
        ExpressionDef ed = Libraries.resolveExpressionRef((String)criteriaExpression, (Library)this.context.getState().getCurrentLibrary());
        if (!(ed instanceof FunctionDef)) {
            throw new IllegalArgumentException(String.format("Measure observation %s does not reference a function definition", criteriaExpression));
        }
        Object result = null;
        this.context.getState().pushWindow();
        try {
            this.context.getState().push(new Variable().withName(((OperandDef)((FunctionDef)ed).getOperand().get(0)).getName()).withValue(resource));
            result = this.context.getEvaluationVisitor().visitExpression(ed.getExpression(), (Object)this.context.getState());
        }
        finally {
            this.context.getState().popWindow();
        }
        this.captureEvaluatedResources(outEvaluatedResources);
        return result;
    }

    protected boolean evaluatePopulationMembership(String subjectType, String subjectId, PopulationDef inclusionDef, PopulationDef exclusionDef) {
        boolean inPopulation = false;
        for (Object resource : this.evaluatePopulationCriteria(subjectType, subjectId, inclusionDef.expression(), inclusionDef.getEvaluatedResources())) {
            inPopulation = true;
            inclusionDef.addResource(resource);
        }
        if (inPopulation && exclusionDef != null) {
            for (Object resource : this.evaluatePopulationCriteria(subjectType, subjectId, exclusionDef.expression(), exclusionDef.getEvaluatedResources())) {
                inPopulation = false;
                exclusionDef.addResource(resource);
                inclusionDef.removeResource(resource);
            }
        }
        if (inPopulation) {
            inclusionDef.addSubject(subjectId);
        }
        if (!inPopulation && exclusionDef != null) {
            exclusionDef.addSubject(subjectId);
        }
        return inPopulation;
    }

    protected void evaluateProportion(GroupDef groupDef, String subjectType, String subjectId) {
        boolean inNumerator;
        boolean inDenominator;
        boolean inInitialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION), null);
        if (inInitialPopulation && (inDenominator = this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.DENOMINATOR), groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCLUSION))) && !(inNumerator = this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.NUMERATOR), groupDef.getSingle(MeasurePopulationType.NUMERATOREXCLUSION))) && groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCEPTION) != null) {
            PopulationDef denominatorException = groupDef.getSingle(MeasurePopulationType.DENOMINATOREXCEPTION);
            PopulationDef denominator = groupDef.getSingle(MeasurePopulationType.DENOMINATOR);
            boolean inException = false;
            for (Object resource : this.evaluatePopulationCriteria(subjectType, subjectId, denominatorException.expression(), denominatorException.getEvaluatedResources())) {
                inException = true;
                denominatorException.addResource(resource);
                denominator.removeResource(resource);
            }
            if (inException) {
                denominatorException.addSubject(subjectId);
                denominator.removeSubject(subjectId);
            }
        }
    }

    protected void evaluateContinuousVariable(GroupDef groupDef, String subjectType, String subjectId) {
        PopulationDef measureObservation;
        PopulationDef measurePopulation;
        boolean inMeasurePopulation;
        boolean inInitialPopulation = this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION), null);
        if (inInitialPopulation && (inMeasurePopulation = this.evaluatePopulationMembership(subjectType, subjectId, measurePopulation = groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATION), groupDef.getSingle(MeasurePopulationType.MEASUREPOPULATIONEXCLUSION))) && (measureObservation = groupDef.getSingle(MeasurePopulationType.MEASUREOBSERVATION)) != null) {
            for (Object resource : measurePopulation.getResources()) {
                Object observationResult = this.evaluateObservationCriteria(resource, measureObservation.expression(), measureObservation.getEvaluatedResources());
                measureObservation.addResource(observationResult);
            }
        }
    }

    protected void evaluateCohort(GroupDef groupDef, String subjectType, String subjectId) {
        this.evaluatePopulationMembership(subjectType, subjectId, groupDef.getSingle(MeasurePopulationType.INITIALPOPULATION), null);
    }

    protected void evaluateGroup(MeasureScoring measureScoring, GroupDef groupDef, String subjectType, String subjectId) {
        this.evaluateStratifiers(subjectId, groupDef.stratifiers());
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                this.evaluateProportion(groupDef, subjectType, subjectId);
                break;
            }
            case CONTINUOUSVARIABLE: {
                this.evaluateContinuousVariable(groupDef, subjectType, subjectId);
                break;
            }
            case COHORT: {
                this.evaluateCohort(groupDef, subjectType, subjectId);
            }
        }
    }

    protected void evaluateSdes(String subjectId, List<SdeDef> sdes) {
        for (SdeDef sde : sdes) {
            ExpressionDef ref = Libraries.resolveExpressionRef((String)sde.expression(), (Library)this.context.getState().getCurrentLibrary());
            Object result = this.context.getEvaluationVisitor().visitExpressionDef(ref, this.context.getState());
            if (result instanceof List && ((List)result).size() == 1 && ((List)result).get(0) == null) {
                result = null;
            }
            sde.putResult(subjectId, result, this.context.getState().getEvaluatedResources());
            this.clearEvaluatedResources();
        }
    }

    protected void evaluateStratifiers(String subjectId, List<StratifierDef> stratifierDefs) {
        for (StratifierDef sd : stratifierDefs) {
            if (!sd.components().isEmpty()) {
                throw new UnsupportedOperationException("multi-component stratifiers are not yet supported.");
            }
            ExpressionDef ref = Libraries.resolveExpressionRef((String)sd.expression(), (Library)this.context.getState().getCurrentLibrary());
            Object result = this.context.getEvaluationVisitor().visitExpressionDef(ref, this.context.getState());
            if (result instanceof Iterable) {
                Iterator resultIter = ((Iterable)result).iterator();
                result = !resultIter.hasNext() ? null : resultIter.next();
                if (resultIter.hasNext()) {
                    throw new IllegalArgumentException("stratifiers may not return multiple values");
                }
            }
            if (result != null) {
                sd.putResult(subjectId, result, this.context.getState().getEvaluatedResources());
            }
            this.clearEvaluatedResources();
        }
    }
}

