/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.model.CompiledLibrary;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.execution.CqlEngine;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.Engines;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cr.measure.MeasureEvaluationOptions;
import org.opencds.cqf.fhir.cr.measure.common.MeasureEvalType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureReportType;
import org.opencds.cqf.fhir.cr.measure.common.SubjectProvider;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3MeasureEvaluation;
import org.opencds.cqf.fhir.cr.measure.dstu3.Dstu3RepositorySubjectProvider;
import org.opencds.cqf.fhir.cr.measure.helper.DateHelper;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;

@Named
public class Dstu3MeasureProcessor {
    private final Repository repository;
    private final MeasureEvaluationOptions measureEvaluationOptions;
    private final SubjectProvider subjectProvider;

    public Dstu3MeasureProcessor(Repository repository, MeasureEvaluationOptions measureEvaluationOptions) {
        this(repository, measureEvaluationOptions, new Dstu3RepositorySubjectProvider());
    }

    public Dstu3MeasureProcessor(Repository repository, MeasureEvaluationOptions measureEvaluationOptions, SubjectProvider subjectProvider) {
        this.repository = Objects.requireNonNull(repository);
        this.measureEvaluationOptions = measureEvaluationOptions != null ? measureEvaluationOptions : MeasureEvaluationOptions.defaultOptions();
        this.subjectProvider = subjectProvider;
    }

    public MeasureReport evaluateMeasure(IdType measureId, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData) {
        Measure measure = (Measure)this.repository.read(Measure.class, (IIdType)measureId);
        return this.evaluateMeasure(measure, periodStart, periodEnd, reportType, subjectIds, additionalData);
    }

    protected MeasureReport evaluateMeasure(Measure measure, String periodStart, String periodEnd, String reportType, List<String> subjectIds, IBaseBundle additionalData) {
        if (!measure.hasLibrary()) {
            throw new IllegalArgumentException(String.format("Measure %s does not have a primary library specified", measure.getUrl()));
        }
        Interval measurementPeriod = null;
        if (StringUtils.isNotBlank((CharSequence)periodStart) && StringUtils.isNotBlank((CharSequence)periodEnd)) {
            measurementPeriod = this.buildMeasurementPeriod(periodStart, periodEnd);
        }
        Reference reference = (Reference)measure.getLibrary().get(0);
        Library library = (Library)this.repository.read(Library.class, reference.getReferenceElement());
        CqlEngine context = Engines.forRepositoryAndSettings((EvaluationSettings)this.measureEvaluationOptions.getEvaluationSettings(), (Repository)this.repository, (IBaseBundle)additionalData);
        CompiledLibrary lib = context.getEnvironment().getLibraryManager().resolveLibrary(new VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion()));
        context.getState().init(lib.getLibrary());
        Repository actualRepo = this.repository;
        if (additionalData != null) {
            actualRepo = new FederatedRepository(this.repository, new Repository[]{new InMemoryFhirRepository(this.repository.fhirContext(), additionalData)});
        }
        MeasureEvalType evalType = MeasureEvalType.fromCode(reportType).orElse(subjectIds.get(0) == null || subjectIds == null || subjectIds.isEmpty() ? MeasureEvalType.POPULATION : MeasureEvalType.SUBJECT);
        List<String> subjects = this.subjectProvider.getSubjects(actualRepo, evalType, subjectIds).collect(Collectors.toList());
        Dstu3MeasureEvaluation measureEvaluator = new Dstu3MeasureEvaluation(context, measure);
        return (MeasureReport)measureEvaluator.evaluate(evalType, subjects, measurementPeriod);
    }

    protected MeasureReportType evalTypeToReportType(MeasureEvalType measureEvalType) {
        switch (measureEvalType) {
            case PATIENT: 
            case SUBJECT: {
                return MeasureReportType.INDIVIDUAL;
            }
            case PATIENTLIST: 
            case SUBJECTLIST: {
                return MeasureReportType.PATIENTLIST;
            }
            case POPULATION: {
                return MeasureReportType.SUMMARY;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported MeasureEvalType: %s", measureEvalType.toCode()));
    }

    private Interval buildMeasurementPeriod(String periodStart, String periodEnd) {
        return new Interval((Object)DateTime.fromJavaDate((Date)DateHelper.resolveRequestDate(periodStart, true)), true, (Object)DateTime.fromJavaDate((Date)DateHelper.resolveRequestDate(periodEnd, false)), true);
    }
}

